/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.timeline;

import com.arm.streamline.cmdline.CmdLineMessages;
import com.arm.streamline.cmdline.ReportProcessor;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.editortabs.report.TableExport;
import com.arm.streamline.editortabs.timeline.HeatmapExportFormatter;
import com.arm.streamline.editortabs.timeline.IHeatmapExportFormatter;
import com.arm.streamline.editortabs.timeline.TimelineMessages;
import com.arm.streamline.model.process.ITimelineRowProvider;
import com.arm.streamline.model.process.TimelineRowType;
import com.arm.streamline.utility.io.CharacterConversionOutputStream;
import com.arm.streamline.widget.Error;
import com.arm.utils.NullChecking;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ExportHeatMapDataJob
extends Job {
    private final @NonNull String fullPath;
    private final ReportProcessor.Format format;
    private final int firstBin;
    private final int lastBin;
    private final TIntHashSet selection;
    private final @NonNull List<@NonNull ITimelineRowProvider> allRowProviders;
    private final @NonNull ZoomLevel resolution;
    private final @NonNull TimeUnit timeUnit;

    public ExportHeatMapDataJob(@NonNull ReportProcessor.Format format, int from, int to, @NonNull List<@NonNull ITimelineRowProvider> allRowProviders, @Nullable TIntHashSet selection, @NonNull String fullPath, @NonNull ZoomLevel resolution, @NonNull TimeUnit timeUnit) {
        super(TimelineMessages.EXPORTING_HEATMAP_JOB_TITLE);
        this.setUser(true);
        this.fullPath = fullPath;
        this.format = format;
        this.firstBin = from;
        this.lastBin = to;
        this.allRowProviders = allRowProviders;
        this.selection = selection;
        this.resolution = resolution;
        this.timeUnit = timeUnit;
    }

    protected IStatus run(IProgressMonitor monitor) {
        @NonNull String nonNullPath = (String)NullChecking.neverNull((Object)this.fullPath);
        @NonNull List<@NonNull ITimelineRowProvider> selectedProviders = ExportHeatMapDataJob.getSelectedProviders(this.allRowProviders, this.selection);
        int MICRO_SIGN = 181;
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PrintStream out = new PrintStream(new CharacterConversionOutputStream(new BufferedOutputStream(new FileOutputStream(nonNullPath)), '\u00b5', 'u'));){
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(out));){
                    HeatmapExportFormatter formatter = new HeatmapExportFormatter();
                    ExportHeatMapDataJob.doExport(monitor, this.format, selectedProviders, writer, this.firstBin, this.lastBin, formatter, this.resolution, this.timeUnit);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            Error.show(exception.getMessage());
        }
        return Status.OK_STATUS;
    }

    public static void doExport(IProgressMonitor monitor, ReportProcessor.Format format, List<ITimelineRowProvider> selectedProviders, PrintWriter writer, int firstBin, int lastBin, IHeatmapExportFormatter formatter, @NonNull ZoomLevel resolution, @NonNull TimeUnit timeUnit) throws IOException {
        monitor.beginTask(TimelineMessages.EXPORTING_HEATMAP_JOB_TITLE, lastBin - firstBin + 1);
        boolean useTabs = format == ReportProcessor.Format.TABS;
        boolean useCommas = format == ReportProcessor.Format.COMMAS;
        ArrayList<ITimelineRowProvider> selectedProvidersWithMapData = new ArrayList<ITimelineRowProvider>();
        for (ITimelineRowProvider provider : selectedProviders) {
            TimelineRowType rowType = provider.getRowType();
            if (rowType != TimelineRowType.PROCESS && rowType != TimelineRowType.THREAD) continue;
            selectedProvidersWithMapData.add(provider);
        }
        int size = selectedProvidersWithMapData.size();
        @NonNull String[] strings = new String[size + 1];
        strings[0] = MessageFormat.format(CmdLineMessages.TIME, timeUnit.getBaseSymbol());
        int index = 1;
        for (ITimelineRowProvider provider : selectedProvidersWithMapData) {
            strings[index++] = formatter.formatColumnTitle((ITimelineRowProvider)NullChecking.neverNull((Object)provider));
        }
        TableExport.exportTextInColumns(writer, null, useTabs, useCommas, strings, 0);
        int i = firstBin;
        while (i <= lastBin) {
            strings[0] = formatter.formatTime(i, resolution, timeUnit);
            int index2 = 1;
            for (ITimelineRowProvider provider : selectedProvidersWithMapData) {
                int[] data = provider.getMapData(i, i);
                strings[index2++] = formatter.formatBinValue(data[0]);
            }
            TableExport.exportTextInColumns(writer, null, useTabs, useCommas, strings, 0);
            monitor.worked(1);
            ++i;
        }
        writer.flush();
        monitor.done();
    }

    public static @NonNull List<@NonNull ITimelineRowProvider> getSelectedProviders(@NonNull List<@NonNull ITimelineRowProvider> allProviders, @Nullable TIntHashSet selection) {
        return ExportHeatMapDataJob.getSelectedProviders(allProviders, selection, null);
    }

    private static @NonNull List<@NonNull ITimelineRowProvider> getSelectedProviders(@NonNull List<@NonNull ITimelineRowProvider> allProviders, @Nullable TIntHashSet selection, @Nullable ITimelineRowProvider processOrThreadRow) {
        @NonNull ArrayList<@NonNull ITimelineRowProvider> result = new ArrayList<ITimelineRowProvider>();
        block6: for (ITimelineRowProvider provider : allProviders) {
            switch (provider.getRowType()) {
                case GROUP: 
                case ANNOTATION: {
                    if (selection == null || processOrThreadRow == null) continue block6;
                    int uid = provider.getUID();
                    if (selection.contains(uid)) {
                        result.add(processOrThreadRow);
                        return result;
                    }
                    result.addAll(ExportHeatMapDataJob.getSelectedProviders(provider.getChildren(), selection, processOrThreadRow));
                    break;
                }
                case PROCESS: {
                    assert (processOrThreadRow == null);
                    int uid = provider.getUID();
                    if (selection == null || selection.isEmpty() || selection.contains(uid)) {
                        result.add(provider);
                        result.addAll(ExportHeatMapDataJob.getSelectedProviders(provider.getChildren(), null, null));
                        break;
                    }
                    result.addAll(ExportHeatMapDataJob.getSelectedProviders(provider.getChildren(), selection, provider));
                    break;
                }
                case THREAD: {
                    int uid = provider.getUID();
                    if (selection == null || selection.contains(uid)) {
                        result.add(provider);
                        break;
                    }
                    result.addAll(ExportHeatMapDataJob.getSelectedProviders(provider.getChildren(), selection, provider));
                    break;
                }
                case VMUID: {
                    assert (processOrThreadRow == null);
                    result.addAll(ExportHeatMapDataJob.getSelectedProviders(provider.getChildren(), selection, null));
                    break;
                }
                default: {
                    throw new AssertionError((Object)provider.getRowType());
                }
            }
        }
        return result;
    }
}

