/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.report;

import com.arm.streamline.utility.io.CharacterConversionOutputStream;
import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.PercentageCell;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.RowSorter;
import com.arm.streamline.widget.outline.TextCell;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jdt.annotation.NonNull;

public class TableExport {
    public static <C extends Column<C>> void export(OutputStream out, boolean useTabs, boolean useCSV, boolean includeChildren, @NonNull List<@NonNull C> columns, @NonNull List<@NonNull Row<C>> rows) throws IOException {
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(new CharacterConversionOutputStream(out, '\u00b5', 'u')));
        HashSet<Row<C>> seen = new HashSet<Row<C>>();
        int[] widths = null;
        int hLines = 1;
        if (!rows.isEmpty()) {
            rows.get(0).getOwner().setExporting(true);
        }
        try {
            int i;
            if (!useTabs && !useCSV) {
                int count;
                StringTokenizer tokenizer;
                widths = new int[columns.size()];
                i = 0;
                while (i < columns.size()) {
                    tokenizer = new StringTokenizer(((Column)columns.get(i)).toString(), "\n");
                    count = 0;
                    while (tokenizer.hasMoreTokens()) {
                        int width = tokenizer.nextToken().length();
                        if (width > widths[i]) {
                            widths[i] = width;
                        }
                        ++count;
                    }
                    if (count > hLines) {
                        hLines = count;
                    }
                    ++i;
                }
                i = 0;
                while (i < rows.size()) {
                    if (!includeChildren || !seen.contains(rows.get(i))) {
                        TableExport.preflightExportRow(widths, rows.get(i), columns, includeChildren, seen);
                    }
                    ++i;
                }
                data = new String[hLines];
                int j = 0;
                while (j < hLines) {
                    i = 0;
                    while (i < columns.size()) {
                        tokenizer = new StringTokenizer(((Column)columns.get(i)).toString(), "\n");
                        count = hLines - tokenizer.countTokens();
                        int k = 0;
                        while (k < count) {
                            data[k] = "";
                            ++k;
                        }
                        while (tokenizer.hasMoreTokens()) {
                            data[count++] = tokenizer.nextToken();
                        }
                        if (i != 0) {
                            writer.print("  ");
                        }
                        TableExport.writeField(writer, 0x1000000, widths[i], data[j]);
                        ++i;
                    }
                    writer.println();
                    ++j;
                }
                i = 0;
                while (i < columns.size()) {
                    if (i != 0) {
                        writer.print("  ");
                    }
                    writer.print(TableExport.makeFiller(widths[i], '-'));
                    ++i;
                }
                writer.println();
            } else {
                i = 0;
                while (i < columns.size()) {
                    data = ((Column)columns.get(i)).getCompleteName();
                    data = useCSV ? TableExport.makeCSVSafe((String)data) : TableExport.makeTabSafe((String)data);
                    if (i != 0) {
                        writer.print(useTabs ? (char)'\t' : ',');
                    }
                    writer.print((String)data);
                    ++i;
                }
                writer.println();
            }
            seen.clear();
            i = 0;
            while (i < rows.size()) {
                if (!includeChildren || !seen.contains(rows.get(i))) {
                    TableExport.exportRow(writer, widths, useTabs, useCSV, rows.get(i), columns, includeChildren, seen);
                }
                ++i;
            }
            writer.flush();
        }
        finally {
            if (rows.size() > 0) {
                rows.get(0).getOwner().setExporting(false);
            }
        }
    }

    public static void exportTextInColumns(PrintWriter out, int[] widths, boolean useTabs, boolean useCSV, String[] text, int alignment) {
        int i = 0;
        while (i < text.length) {
            String data = text[i];
            if (data != null) {
                if (i != 0) {
                    if (widths != null) {
                        out.print("  ");
                    } else if (useCSV) {
                        out.print(',');
                    } else if (useTabs) {
                        out.print('\t');
                    } else {
                        out.print(' ');
                    }
                }
                if (useCSV) {
                    data = TableExport.makeCSVSafe(data);
                } else if (useTabs) {
                    data = TableExport.makeTabSafe(data);
                }
                if (widths != null) {
                    TableExport.writeField(out, alignment, widths[i], data);
                } else {
                    out.print(data);
                }
            }
            ++i;
        }
        out.println();
    }

    public static @NonNull String makeFiller(int amt, char filler) {
        StringBuilder buffer = new StringBuilder(amt);
        int i = 0;
        while (i < amt) {
            buffer.append(filler);
            ++i;
        }
        return buffer.toString();
    }

    private static <C extends Column<C>> void exportRow(PrintWriter out, int[] widths, boolean useTabs, boolean useCSV, @NonNull Row<C> row, @NonNull List<@NonNull C> columns, boolean includeChildren, HashSet<Row<C>> seen) throws IOException {
        int depth = row.getPath().length - 1;
        if (includeChildren) {
            seen.add(row);
        }
        int i = 0;
        while (i < columns.size()) {
            String string = (String)NullChecking.neverNullOr((Object)row.getDataAsText((Column)columns.get(i)), (Object)"");
            if (i != 0) {
                if (widths != null) {
                    out.print("  ");
                } else if (useCSV) {
                    out.print(',');
                } else {
                    out.print('\t');
                }
            }
            if (((Column)columns.get(i)).isPrimary()) {
                String string2 = TableExport.makeFiller(2 * depth, ' ') + string;
            }
            if (useCSV) {
                String string3 = TableExport.makeCSVSafe((String)var10_14);
            } else if (useTabs) {
                String string4 = TableExport.makeTabSafe((String)var10_14);
            }
            if (widths != null) {
                ICell<Column> cell = ((Column)columns.get(i)).getRowCell(row);
                int alignment = cell instanceof TextCell ? ((TextCell)cell).getHAlignment() : (cell instanceof PercentageCell ? 131072 : 16384);
                TableExport.writeField(out, alignment, widths[i], (String)var10_11);
            } else {
                out.print((String)var10_11);
            }
            ++i;
        }
        out.println();
        if (includeChildren && row.hasChildren()) {
            ArrayList<@NonNull Row<C>> rows = new ArrayList(row.getChildren());
            RowSorter.sort(columns, rows);
            for (Row row2 : rows) {
                TableExport.exportRow(out, widths, useTabs, useCSV, row2, columns, includeChildren, seen);
            }
        }
    }

    public static String makeCSVSafe(@NonNull String data) {
        String quote = "\"";
        if (((String)data).startsWith(" ") || ((String)data).contains(",") || ((String)data).contains("\n") || ((String)data).contains("\r") || ((String)data).contains(quote)) {
            if (((String)data).contains(quote)) {
                data = ((String)data).replaceAll(quote, "\"\"");
            }
            data = quote + (String)data + quote;
        }
        return data;
    }

    private static String makeTabSafe(@NonNull String data) {
        return data.replaceAll("\t", " ");
    }

    private static <C extends Column<C>> void preflightExportRow(int[] widths, @NonNull Row<C> row, @NonNull List<@NonNull C> columns, boolean includeChildren, HashSet<Row<C>> seen) {
        int depth = row.getPath().length - 1;
        if (includeChildren) {
            seen.add(row);
        }
        int i = 0;
        while (i < columns.size()) {
            int width = row.getDataAsText((Column)columns.get(i)).length();
            if (((Column)columns.get(i)).isPrimary()) {
                width += 2 * depth;
            }
            if (width > widths[i]) {
                widths[i] = width;
            }
            ++i;
        }
        if (includeChildren && row.hasChildren()) {
            for (Row aRow : (List)NullChecking.neverNull(row.getChildren())) {
                TableExport.preflightExportRow(widths, aRow, columns, includeChildren, seen);
            }
        }
    }

    private static void writeField(PrintWriter out, int alignment, int width, String data) {
        switch (alignment) {
            case 0x1000000: {
                int remaining = width - data.length();
                int half = remaining / 2;
                if (half > 0) {
                    out.print(TableExport.makeFiller(half, ' '));
                }
                out.print(data);
                half = remaining - half;
                if (half <= 0) break;
                out.print(TableExport.makeFiller(half, ' '));
                break;
            }
            case 131072: {
                if (width > data.length()) {
                    out.print(TableExport.makeFiller(width - data.length(), ' '));
                }
                out.print(data);
                break;
            }
            default: {
                out.print(data);
                if (width <= data.length()) break;
                out.print(TableExport.makeFiller(width - data.length(), ' '));
            }
        }
    }
}

