/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.log;

import com.arm.streamline.common.utility.Task;
import com.arm.streamline.editortabs.log.LogEntryTab;
import com.arm.streamline.model.LogEntriesFile;
import com.arm.streamline.model.LogEntry;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class LogEntryFilterTask
implements Runnable {
    private LogEntryTab mOwner;
    private long mWhenStartMicros;
    private long mWhenEndMicros;
    private long mDurationStartMicros;
    private long mDurationEndMicros;
    private Pattern mMessagePattern;
    private Pattern mGroupPattern;
    private Pattern mChannelPattern;
    private Pattern mWherePattern;
    private boolean mCancel;
    private ArrayList<LogEntry> mList = new ArrayList();

    public LogEntryFilterTask(LogEntryTab owner, long whenStartMicros, long whenEndMicros, long durationStartMicros, long durationEndMicros, Pattern messagePattern, Pattern groupPattern, Pattern channelPattern, Pattern wherePattern) {
        this.mOwner = owner;
        this.mWhenStartMicros = whenStartMicros;
        this.mWhenEndMicros = whenEndMicros;
        this.mDurationStartMicros = durationStartMicros;
        this.mDurationEndMicros = durationEndMicros;
        this.mMessagePattern = messagePattern;
        this.mGroupPattern = groupPattern;
        this.mChannelPattern = channelPattern;
        this.mWherePattern = wherePattern;
    }

    public void cancel() {
        this.mCancel = true;
    }

    @Override
    public void run() {
        this.mOwner.getBusyIndicator().incrementBusy();
        LogEntriesFile file = this.mOwner.getAnalysis().getLogEntriesFile();
        for (LogEntry logEntry : file.getAllLogEntries()) {
            long duration;
            if (this.mCancel) break;
            long when = logEntry.getTimelineMarker();
            if (when < this.mWhenStartMicros || when > this.mWhenEndMicros || (duration = logEntry.getDurationNanoseconds() / 1000L) < this.mDurationStartMicros || duration > this.mDurationEndMicros || !this.mMessagePattern.matcher(logEntry.getMessage()).find() || !this.mGroupPattern.matcher(logEntry.getGroupName()).find() || !this.mChannelPattern.matcher(logEntry.getChannelName()).find() || !this.mWherePattern.matcher(logEntry.getCallPath().getFullName()).find()) continue;
            this.mList.add(logEntry);
        }
        if (this.mCancel) {
            this.mOwner.getBusyIndicator().decrementBusy();
        } else {
            Task.callOnUIThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    LogEntryFilterTask.this.post();
                }
            });
        }
    }

    void post() {
        this.mOwner.setCurrentLogEntries(this.mList);
        this.mOwner.getBusyIndicator().decrementBusy();
    }
}

