/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.log;

import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.editortabs.log.LogMessageCell;
import com.arm.streamline.editortabs.log.LogMessages;
import com.arm.streamline.editortabs.report.IColumnEnum;
import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.LogEntry;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.IColumnCompareType;
import com.arm.streamline.widget.outline.TextCell;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Image;

public enum LogEntryColumns implements IColumnEnum<LogEntry, Analysis>
{
    WHEN{

        @Override
        public boolean filterUsesPattern() {
            return false;
        }

        @Override
        public IColumnCompareType<EnumColumn<LogEntry>> getCompareType() {
            return IColumnCompareType.INTEGER();
        }

        @Override
        public double getDataAsDouble(ReportRow<LogEntry> row) {
            return this.getDataAsLong(row);
        }

        @Override
        public long getDataAsLong(ReportRow<LogEntry> row) {
            return row.getModelObject().getTimelineMarker();
        }

        @Override
        public String getDataAsText(ReportRow<LogEntry> row) {
            LogEntry entry = row.getModelObject();
            return entry.getTimeUnit().formatInBase((double)(entry.getTimelineMarker() * 1000L), 1000.0, TimeUnit.Style.NO_UNIT, true);
        }

        @Override
        public int getPreferredWidth(Analysis analysis) {
            String text = analysis.getTimeUnit().formatInBase((double)(analysis.getLogEntriesFile().getLastTimelineMarker() * 1000L), 1000.0, TimeUnit.Style.NO_UNIT, true);
            return FontInfo.get(Fonts.getNormal()).getWidth(text);
        }

        @Override
        public String getToolTip(@NonNull Analysis data) {
            return MessageFormat.format(LogMessages.WHEN_DESCRIPTION, data.getTimeUnit().getBaseTextMany());
        }

        @Override
        public String getHeader(@NonNull Analysis data) {
            return MessageFormat.format(LogMessages.WHEN_TITLE, data.getTimeUnit().getBaseSymbol());
        }
    }
    ,
    DURATION{

        @Override
        public boolean filterUsesPattern() {
            return false;
        }

        @Override
        public IColumnCompareType<EnumColumn<LogEntry>> getCompareType() {
            return IColumnCompareType.INTEGER();
        }

        @Override
        public double getDataAsDouble(ReportRow<LogEntry> row) {
            return this.getDataAsLong(row);
        }

        @Override
        public long getDataAsLong(ReportRow<LogEntry> row) {
            return row.getModelObject().getDurationNanoseconds();
        }

        @Override
        public String getDataAsText(ReportRow<LogEntry> row) {
            LogEntry entry = row.getModelObject();
            return entry.getTimeUnit().formatInBase((double)entry.getDurationNanoseconds(), 1000.0, TimeUnit.Style.NO_UNIT, true);
        }

        @Override
        public int getPreferredWidth(Analysis analysis) {
            String text = analysis.getTimeUnit().formatInBase((double)analysis.getLogEntriesFile().getLastTimelineMarker(), 1000.0, TimeUnit.Style.NO_UNIT, true);
            return FontInfo.get(Fonts.getNormal()).getWidth(text);
        }

        @Override
        public String getToolTip(@NonNull Analysis data) {
            return MessageFormat.format(LogMessages.DURATION_DESCRIPTION, data.getTimeUnit().getBaseTextMany());
        }

        @Override
        public String getHeader(@NonNull Analysis data) {
            return MessageFormat.format(LogMessages.DURATION_TITLE, data.getTimeUnit().getBaseSymbol());
        }
    }
    ,
    MESSAGE{

        @Override
        public int getAlignment() {
            return 16384;
        }

        @Override
        public ICell<EnumColumn<LogEntry>> getCell(@NonNull Analysis data) {
            return new LogMessageCell();
        }

        @Override
        public double getDataAsDouble(ReportRow<LogEntry> row) {
            return 0.0;
        }

        @Override
        public long getDataAsLong(ReportRow<LogEntry> row) {
            return 0L;
        }

        @Override
        public @NonNull String getDataAsText(ReportRow<LogEntry> row) {
            return row.getModelObject().getOneLineMessage();
        }

        @Override
        public int getPreferredWidth(Analysis analysis) {
            int one = FontInfo.get(Fonts.getNormal()).getWidth("aw") / 2;
            return one * analysis.getLogEntriesFile().getLongestMessage();
        }

        @Override
        public String getToolTip(@NonNull Analysis data) {
            return LogMessages.MESSAGE_DESCRIPTION;
        }

        @Override
        public String getToolTip(ReportRow<LogEntry> row) {
            LogEntry logEntry = row.getModelObject();
            String msg = logEntry.getMessage();
            if (!logEntry.getOneLineMessage().equals(msg)) {
                return msg;
            }
            return null;
        }

        @Override
        public boolean isPrimary() {
            return true;
        }

        @Override
        public String getHeader(@NonNull Analysis data) {
            return LogMessages.MESSAGE_TITLE;
        }
    }
    ,
    GROUP{

        @Override
        public int getAlignment() {
            return 16384;
        }

        @Override
        public double getDataAsDouble(ReportRow<LogEntry> row) {
            return 0.0;
        }

        @Override
        public long getDataAsLong(ReportRow<LogEntry> row) {
            return 0L;
        }

        @Override
        public @NonNull String getDataAsText(ReportRow<LogEntry> row) {
            return row.getModelObject().getGroupName();
        }

        @Override
        public int getPreferredWidth(Analysis analysis) {
            int one = FontInfo.get(Fonts.getNormal()).getWidth("aw") / 2;
            return one * analysis.getLogEntriesFile().getLongestGroup();
        }

        @Override
        public String getToolTip(@NonNull Analysis data) {
            return LogMessages.GROUP_DESCRIPTION;
        }

        @Override
        public String getHeader(@NonNull Analysis data) {
            return LogMessages.GROUP_TITLE;
        }
    }
    ,
    CHANNEL{

        @Override
        public int getAlignment() {
            return 16384;
        }

        @Override
        public double getDataAsDouble(ReportRow<LogEntry> row) {
            return 0.0;
        }

        @Override
        public long getDataAsLong(ReportRow<LogEntry> row) {
            return 0L;
        }

        @Override
        public @NonNull String getDataAsText(ReportRow<LogEntry> row) {
            return row.getModelObject().getChannelName();
        }

        @Override
        public int getPreferredWidth(Analysis analysis) {
            int one = FontInfo.get(Fonts.getNormal()).getWidth("aw") / 2;
            return one * analysis.getLogEntriesFile().getLongestChannel();
        }

        @Override
        public String getToolTip(@NonNull Analysis data) {
            return LogMessages.CHANNEL_DESCRIPTION;
        }

        @Override
        public String getHeader(@NonNull Analysis data) {
            return LogMessages.CHANNEL_TITLE;
        }
    }
    ,
    WHERE{

        @Override
        public int getAlignment() {
            return 16384;
        }

        @Override
        public double getDataAsDouble(ReportRow<LogEntry> row) {
            return 0.0;
        }

        @Override
        public long getDataAsLong(ReportRow<LogEntry> row) {
            return 0L;
        }

        @Override
        public String getDataAsText(ReportRow<LogEntry> row) {
            return row.getModelObject().getCallPath().getFullName();
        }

        @Override
        public int getPreferredWidth(Analysis analysis) {
            int one = FontInfo.get(Fonts.getNormal()).getWidth("aw") / 2;
            return one * analysis.getInstructionCounterModel().getLargestCallPathName().length() * 2;
        }

        @Override
        public String getToolTip(@NonNull Analysis data) {
            return LogMessages.WHERE_DESCRIPTION;
        }

        @Override
        public String getHeader(@NonNull Analysis data) {
            return LogMessages.WHERE_TITLE;
        }
    };


    public boolean filterUsesPattern() {
        return true;
    }

    public int getAlignment() {
        return 131072;
    }

    @Override
    public ICell<EnumColumn<LogEntry>> getCell(@NonNull Analysis data) {
        return new TextCell<EnumColumn<LogEntry>>(this.getAlignment());
    }

    public IColumnCompareType<EnumColumn<LogEntry>> getCompareType() {
        return IColumnCompareType.TEXT();
    }

    public String getFilterToolTip() {
        return this.filterUsesPattern() ? LogMessages.FILTER_TOOLTIP : LogMessages.RANGE_FILTER_TOOLTIP;
    }

    @Override
    public Image getImage(ReportRow<LogEntry> row) {
        return null;
    }

    @Override
    public int getInitialSortSequence() {
        return -1;
    }

    public int getMinimumFilterWidth() {
        return 50;
    }

    public abstract int getPreferredWidth(Analysis var1);

    public String getTitleSingleLine(@NonNull Analysis analysis) {
        return this.getHeader(analysis).replace('\n', ' ');
    }

    @Override
    public String getToolTip(ReportRow<LogEntry> row) {
        return null;
    }

    @Override
    public boolean isInitialSortAscending() {
        return true;
    }

    @Override
    public boolean isPrimary() {
        return false;
    }
}

