/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.histogram;

import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.histogram.HistogramCellDataProvider;
import com.arm.streamline.editortabs.histogram.HistogramDataRebinner;
import com.arm.streamline.widget.outline.HistogramCell;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.function.Function;
import java.util.function.ToLongBiFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class HistogramScaledCellDataProvider<T>
implements HistogramCellDataProvider.IHistogramSizedCellDataProvider<T> {
    protected final long @NonNull [] datapointBase;
    protected final @NonNull ToLongBiFunction<@NonNull T, long @NonNull []> limitSupplier;
    protected final @NonNull Function<@NonNull T, long @Nullable []> mapper;
    protected final long numberOfDataPointsPerBin;
    protected final int pixelWidth;
    protected final @NonNull HistogramDataRebinner rebinner;
    protected final long smallestDataPoint;
    protected final @NonNull String unitsSuffix;

    public HistogramScaledCellDataProvider(int pixelWidth, long numberOfDataPoints, long @NonNull [] datapointBase, int @NonNull [] datapointWidth, long smallestDataPoint, @NonNull String units, @NonNull ToLongBiFunction<@NonNull T, long @NonNull []> limitSupplier, @NonNull Function<@NonNull T, long @Nullable []> mapper) {
        assert (pixelWidth > 0);
        assert (numberOfDataPoints > (long)pixelWidth);
        units = units.trim();
        this.pixelWidth = pixelWidth;
        this.datapointBase = datapointBase;
        this.smallestDataPoint = smallestDataPoint;
        this.limitSupplier = limitSupplier;
        this.mapper = mapper;
        this.unitsSuffix = units.isEmpty() ? units : String.format(" %s", units);
        this.numberOfDataPointsPerBin = (numberOfDataPoints + (long)pixelWidth - 1L) / (long)pixelWidth;
        int numberOfBins = Math.toIntExact((numberOfDataPoints + this.numberOfDataPointsPerBin - 1L) / this.numberOfDataPointsPerBin);
        long displayNumberOfDataPoints = (long)numberOfBins * this.numberOfDataPointsPerBin;
        assert (this.numberOfDataPointsPerBin > 1L);
        assert (numberOfBins >= 1);
        assert (numberOfBins <= pixelWidth);
        assert (displayNumberOfDataPoints >= numberOfDataPoints);
        this.rebinner = new HistogramDataRebinner(datapointBase, datapointWidth, (rawBase, width, consumer) -> {
            long base = rawBase - smallestDataPoint;
            long end = base + (long)width;
            int firstBin = (int)(base / this.numberOfDataPointsPerBin);
            int endBin = (int)((end + this.numberOfDataPointsPerBin - 1L) / this.numberOfDataPointsPerBin);
            int binIndex = firstBin;
            while (binIndex < endBin) {
                long lastBinEnd = (long)binIndex * this.numberOfDataPointsPerBin;
                long nextBinEnd = lastBinEnd + this.numberOfDataPointsPerBin;
                long baseForCalculation = Math.max(base, lastBinEnd);
                long endForCalculation = Math.min(end, nextBinEnd);
                long widthForCalculation = endForCalculation - baseForCalculation;
                assert (widthForCalculation <= this.numberOfDataPointsPerBin);
                if (widthForCalculation > 0L) {
                    double proportion = (double)widthForCalculation / (double)width;
                    consumer.accept(binIndex, proportion);
                }
                ++binIndex;
            }
        });
    }

    @Override
    public  @Nullable HistogramCell.IHistogramData get(@NonNull T value) {
        long @Nullable [] histogramData = this.mapper.apply(value);
        if (histogramData == null) {
            return null;
        }
        assert (histogramData.length == this.datapointBase.length);
        final double limit = this.limitSupplier.applyAsLong(value, histogramData);
        final double @NonNull [] binDataValueHeightTuples = this.rebinner.transform(histogramData, limit);
        final double maxProportion = this.rebinner.getScaleFactor();
        final int minBinIndex = this.rebinner.getMinDataBinIndex();
        final int realBinCount = this.rebinner.getRealBinCount();
        return new HistogramCell.IHistogramData(){

            @Override
            public int getBinCount() {
                return realBinCount;
            }

            @Override
            public int getBinOffset(int bin) {
                return bin * HistogramScaledCellDataProvider.this.pixelWidth / realBinCount;
            }

            @Override
            public double getBinValue(int bin) {
                if (bin >= minBinIndex) {
                    int bindex = bin - minBinIndex;
                    return binDataValueHeightTuples[bindex * 2 + 1] / maxProportion;
                }
                return 0.0;
            }

            @Override
            public int getBinWidth(int bin) {
                int offsetBin = this.getBinOffset(bin);
                int offsetNext = this.getBinOffset(bin + 1);
                return offsetNext - offsetBin;
            }

            @Override
            @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"})
            public @NonNull String getLabelForBin(int bin) {
                long baseValue = HistogramScaledCellDataProvider.this.smallestDataPoint + (long)bin * HistogramScaledCellDataProvider.this.numberOfDataPointsPerBin;
                long endValue = HistogramScaledCellDataProvider.this.smallestDataPoint + (long)(bin + 1) * HistogramScaledCellDataProvider.this.numberOfDataPointsPerBin - 1L;
                int bindex = bin - minBinIndex;
                double value = bin >= minBinIndex ? binDataValueHeightTuples[bindex * 2 + 0] * limit : 0.0;
                long longValue = (long)value;
                if ((double)longValue == value) {
                    return String.format("%d-%d%s: %d", baseValue, endValue, HistogramScaledCellDataProvider.this.unitsSuffix, longValue);
                }
                return String.format("%d-%d%s: %s", baseValue, endValue, HistogramScaledCellDataProvider.this.unitsSuffix, NumberUtils.prettyFormat((double)value));
            }

            @Override
            public double getMaxValue() {
                double result = 0.0;
                int i = 1;
                while (i < binDataValueHeightTuples.length) {
                    double height = binDataValueHeightTuples[i];
                    result = Math.max(result, height / maxProportion);
                    i += 2;
                }
                return result;
            }

            @Override
            public @Nullable String getText() {
                return null;
            }
        };
    }
}

