/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.histogram;

import com.arm.streamline.editortabs.histogram.HistogramScaledCellDataProvider;
import com.arm.streamline.editortabs.histogram.HistogramUnscaledCellDataProvider;
import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.report.model.icounters.HistogramDataPoint;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.HistogramCell;
import com.arm.streamline.widget.outline.Row;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.ToLongBiFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class HistogramCellDataProvider<T>
implements HistogramCell.IHistogramCellDataProvider<EnumColumn<T>> {
    private static final boolean USE_LINEAR_SCALE = false;
    protected final long @NonNull [] datapointBase;
    protected final int @NonNull [] datapointWidth;
    protected final long largestDataPoint;
    protected final @NonNull ToLongBiFunction<@NonNull T, long @NonNull []> limitSupplier;
    protected final @NonNull Function<@NonNull T, long @Nullable []> mapper;
    protected final long numberOfDataPoints;
    protected final long smallestDataPoint;
    private final @Nullable Integer colour;
    private @Nullable IHistogramSizedCellDataProvider<T> lastDataProvider;
    private long lastPixelWidth = 0L;
    private final boolean scaleRelativeToLimit;
    private final @NonNull IHistogramSizedCellDataProvider<T> zeroWidthDataProvider;
    private final @NonNull String units;

    public HistogramCellDataProvider(@NonNull HistogramDataPoint @NonNull [] datapoints, boolean scaleRelativeToLimit, @Nullable Integer colour, @NonNull String units, @NonNull ToLongBiFunction<@NonNull T, long @NonNull []> limitSupplier, @NonNull Function<@NonNull T, long @Nullable []> mapper) {
        this.scaleRelativeToLimit = scaleRelativeToLimit;
        this.colour = colour;
        this.units = units;
        this.mapper = mapper;
        this.limitSupplier = limitSupplier;
        this.datapointBase = HistogramDataPoint.calculateAbsoluteBaseValues((HistogramDataPoint[])datapoints);
        this.datapointWidth = Arrays.stream(datapoints).mapToInt(d -> d.width).toArray();
        assert (this.datapointBase.length == datapoints.length);
        assert (this.datapointWidth.length == datapoints.length);
        this.smallestDataPoint = this.datapointBase.length > 0 ? this.datapointBase[0] : 0L;
        this.largestDataPoint = this.datapointBase.length > 0 ? this.datapointBase[this.datapointBase.length - 1] + (long)this.datapointWidth[this.datapointWidth.length - 1] - 1L : 0L;
        this.numberOfDataPoints = this.largestDataPoint - this.smallestDataPoint + 1L;
        this.zeroWidthDataProvider = new IHistogramSizedCellDataProvider<T>(){

            @Override
            public  @Nullable HistogramCell.IHistogramData get(@NonNull T value) {
                return null;
            }
        };
    }

    @Override
    public int compare(EnumColumn<T> column, Row<EnumColumn<T>> one, Row<EnumColumn<T>> two) {
        @NonNull T value1 = ((ReportRow)one).getModelObject();
        @NonNull T value2 = ((ReportRow)two).getModelObject();
        long @Nullable [] histogramData1 = this.mapper.apply(value1);
        long @Nullable [] histogramData2 = this.mapper.apply(value2);
        long total1 = this.calculateTotal(histogramData1);
        long total2 = this.calculateTotal(histogramData2);
        return Long.compare(total1, total2);
    }

    @Override
    public  @Nullable HistogramCell.IHistogramData get(EnumColumn<T> column, Row<EnumColumn<T>> row, int pixelWidth) {
        @NonNull T value = ((ReportRow)row).getModelObject();
        return this.getForPixelWidth(pixelWidth).get(value);
    }

    @Override
    public @Nullable Integer getColor(EnumColumn<T> column, Row<EnumColumn<T>> row) {
        return this.colour;
    }

    public @NonNull IHistogramSizedCellDataProvider<T> getForPixelWidth(int pixelWidth) {
        if (pixelWidth < 1) {
            return this.zeroWidthDataProvider;
        }
        @Nullable IHistogramSizedCellDataProvider<T> lastDataProvider = this.lastDataProvider;
        if ((long)pixelWidth == this.lastPixelWidth && lastDataProvider != null) {
            return lastDataProvider;
        }
        @NonNull IHistogramSizedCellDataProvider<T> result = this.numberOfDataPoints <= (long)pixelWidth || this.datapointBase.length <= pixelWidth ? this.createUnscaledHistogramBinData(false, pixelWidth) : this.createScaledHistogramBinData(pixelWidth);
        this.lastDataProvider = result;
        this.lastPixelWidth = pixelWidth;
        return result;
    }

    @Override
    public @Nullable String getTooltip(EnumColumn<T> column, Row<EnumColumn<T>> row) {
        return null;
    }

    @Override
    public boolean shouldScaleRelativeToLimit() {
        return this.scaleRelativeToLimit;
    }

    private long calculateTotal(long @Nullable [] histogramData) {
        if (histogramData == null || histogramData.length == 0) {
            return 0L;
        }
        assert (histogramData.length == this.datapointBase.length);
        long result = 0L;
        int i = 0;
        while (i < histogramData.length) {
            long n = histogramData[i];
            long base = this.datapointBase[i];
            long width = this.datapointWidth[i];
            long v = width > 1L ? n * base + n * width * (width - 1L) / (2L * width) : n * base;
            result += v;
            ++i;
        }
        return result;
    }

    private @NonNull IHistogramSizedCellDataProvider<T> createScaledHistogramBinData(int pixelWidth) {
        return new HistogramScaledCellDataProvider<T>(pixelWidth, this.numberOfDataPoints, this.datapointBase, this.datapointWidth, this.smallestDataPoint, this.units, this.limitSupplier, this.mapper);
    }

    private @NonNull IHistogramSizedCellDataProvider<T> createUnscaledHistogramBinData(boolean linearScale, int pixelWidth) {
        return new HistogramUnscaledCellDataProvider<T>(linearScale, pixelWidth, this.numberOfDataPoints, this.datapointBase, this.datapointWidth, this.smallestDataPoint, this.units, this.limitSupplier, this.mapper);
    }

    public static interface IHistogramSizedCellDataProvider<T> {
        public  @Nullable HistogramCell.IHistogramData get(@NonNull T var1);
    }
}

