/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.function;

import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.AnalysisEditor;
import com.arm.streamline.editortabs.EditorTab;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.IUpdateOnDisplayTab;
import com.arm.streamline.editortabs.InstructionCounterOutlineUpdater;
import com.arm.streamline.editortabs.InstructionCountersViewModel;
import com.arm.streamline.editortabs.InstructionCountersViewUtils;
import com.arm.streamline.editortabs.OpenSourceFileAction;
import com.arm.streamline.editortabs.StreamlineContextMenu;
import com.arm.streamline.editortabs.function.FunctionColumn;
import com.arm.streamline.editortabs.function.FunctionContributor;
import com.arm.streamline.editortabs.function.FunctionMessages;
import com.arm.streamline.editortabs.function.FunctionRow;
import com.arm.streamline.editortabs.function.IFunctionColumn;
import com.arm.streamline.editortabs.report.AnalysisOutline;
import com.arm.streamline.editortabs.report.ExportTableAction;
import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionViews;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.utility.CommandAction;
import com.arm.streamline.utility.ICommandTarget;
import com.arm.streamline.widget.CustomToolbar;
import com.arm.streamline.widget.FilterField;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.SafeUpdate;
import com.arm.streamline.widget.ToolbarReadout;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.Header;
import com.arm.streamline.widget.outline.IOutlineListener;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.selection.StdSelection;
import com.arm.utils.NullChecking;
import gnu.trove.TIntCollection;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.ActionFactory;

public class FunctionTab
extends EditorTab
implements FilterField.IFilterMatcher,
ICommandTarget,
IOutlineListener<EnumColumn<IInstructionCounterFunctionView>>,
ISelectionChangedListener,
IUpdateOnDisplayTab {
    private FilterField mFilterField;
    private AnalysisOutline<IInstructionCounterFunctionView> mFunctionOutline;
    private ToolbarReadout mSamplesField;
    private TIntHashSet mSelectedIds;
    private ToolbarReadout mTotalsField;
    private InstructionCounterFunctionOutlineUpdater updateListener;

    public FunctionTab(@NonNull AnalysisEditor editor, BaseTimelineContent baseTimelineContent) {
        super(editor, baseTimelineContent);
        this.init();
    }

    @Override
    public void deleteSelectionRequested(Outline<EnumColumn<IInstructionCounterFunctionView>> outline) {
    }

    @Override
    public void editorChanged(Outline<EnumColumn<IInstructionCounterFunctionView>> outline) {
    }

    @Override
    public void dispose() {
        if (this.updateListener != null) {
            this.getInstructionCounterViewModel().propertyCurrentSelectedSource().removeValueChangeListener((IValueChangeListener)this.updateListener);
        }
        super.dispose();
    }

    @Override
    public void findMatches(FilterField field) {
        @NonNull InstructionCountersViewModel instructionCounterViewModel = this.getInstructionCounterViewModel();
        @Nullable IInstructionCounterSource instructionCounterSource = (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue();
        String config = this.mFunctionOutline.getConfig();
        OutlineModel model = this.mFunctionOutline.getModel();
        HashSet<IInstructionCounterFunctionView> selected = new HashSet<IInstructionCounterFunctionView>();
        ArrayList<@NonNull FunctionRow> selection = new ArrayList<FunctionRow>();
        ArrayList<@NonNull FunctionRow> rows = new ArrayList<FunctionRow>();
        for (Row row : model.getSelectionAsList()) {
            selected.add((IInstructionCounterFunctionView)((FunctionRow)row).getModelObject());
        }
        this.mFunctionOutline.setAllowLazyAdjust(false);
        boolean canNotify = model.getSelection().canNotify();
        model.getSelection().setNotify(false);
        model.removeAllRows();
        Pattern pattern = field.getPattern();
        if (instructionCounterSource != null) {
            @NonNull IInstructionCounterFunctionViews functions = instructionCounterSource.getFunctionViews();
            for (IInstructionCounterFunctionView function : functions) {
                if (!pattern.matcher(function.getFunction().getName()).find()) continue;
                FunctionRow row = new FunctionRow(function);
                rows.add(row);
                if (!selected.contains(function)) continue;
                selection.add(row);
            }
        }
        model.addNonHierarchicalRowsFast(rows);
        this.mFunctionOutline.applyConfig(config, true, true);
        this.mFunctionOutline.setAllowLazyAdjust(true);
        model.getSelection().setNotify(canNotify);
        this.mFunctionOutline.adjustScrollBarsForContent();
        if (!selection.isEmpty()) {
            model.select(selection, false);
        }
        this.mFunctionOutline.notifyOfSelectionChange();
    }

    public AnalysisOutline<IInstructionCounterFunctionView> getFunctionOutline() {
        return this.mFunctionOutline;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.mFunctionOutline;
    }

    @Override
    public void obeyCommand(CommandAction commandAction) {
        String command = commandAction.getCommand();
        if (!this.mFilterField.handleCommand(command) && this.mFunctionOutline.isFocusControl()) {
            this.mFunctionOutline.obeyCommand(commandAction);
        }
    }

    @Override
    public void onTabDisplayed() {
        TIntHashSet selectedPidsAndTids;
        @NonNull InstructionCountersViewModel instructionCounterViewModel = this.getInstructionCounterViewModel();
        BaseTimelineContent baseTimelineContent = this.getBaseTimelineContent();
        TIntHashSet tIntHashSet = selectedPidsAndTids = baseTimelineContent == null ? null : baseTimelineContent.getSelectedProcessAndThreadIds();
        if (this.mSelectedIds.isEmpty() && selectedPidsAndTids == null || this.mSelectedIds.equals((Object)selectedPidsAndTids)) {
            return;
        }
        this.mSelectedIds.clear();
        if (selectedPidsAndTids != null) {
            this.mSelectedIds.addAll((TIntCollection)selectedPidsAndTids);
        }
        this.loadFunctionOutline((IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue());
    }

    @Override
    public void openSelectionRequested(Outline<EnumColumn<IInstructionCounterFunctionView>> outline) {
        OutlineModel<EnumColumn<IInstructionCounterFunctionView>> model = outline.getModel();
        StdSelection selection = model.getSelection();
        int index = selection.firstSelectedIndex();
        ArrayList<IInstructionCounterFunctionView> functions = new ArrayList<IInstructionCounterFunctionView>();
        while (index >= 0) {
            functions.add((IInstructionCounterFunctionView)((FunctionRow)model.getRowAtIndex(index)).getModelObject());
            index = selection.nextSelectedIndex(index + 1);
        }
        if (!functions.isEmpty()) {
            this.requireEditor().select(EditorTabID.CODE, (ISelection)new StructuredSelection(functions.toArray()));
        }
    }

    @Override
    public void recomputeFromModel() {
        final AnalysisOutline<IInstructionCounterFunctionView> functionOutline = this.mFunctionOutline;
        Task.callOnUIThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!functionOutline.isDisposed()) {
                    functionOutline.getModel().sort();
                    functionOutline.notifyOfSelectionChange();
                }
            }
        });
    }

    public void select(IInstructionCounterFunctionView ... functions) {
        OutlineModel model = this.mFunctionOutline.getModel();
        ArrayList<@NonNull Row<C>> rows = new ArrayList();
        HashSet<IInstructionCounterFunctionView> set = new HashSet<IInstructionCounterFunctionView>();
        IInstructionCounterFunctionView[] iInstructionCounterFunctionViewArray = functions;
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            IInstructionCounterFunctionView obj = iInstructionCounterFunctionViewArray[n2];
            set.add(obj);
            ++n2;
        }
        for (Row row : model.getRows()) {
            if (!set.contains(((FunctionRow)row).getModelObject())) continue;
            rows.add(row);
        }
        model.select(rows, false);
        this.mFunctionOutline.scrollSelectionIntoView(true);
    }

    @Override
    public void selectionChanged(Outline<EnumColumn<IInstructionCounterFunctionView>> outline) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        @NonNull InstructionCountersViewModel instructionCounterViewModel = this.getInstructionCounterViewModel();
        @Nullable IInstructionCounterSource instructionCounterSource = (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue();
        List rows = this.mFunctionOutline.getModel().getSelectionAsList();
        int count = rows.size();
        @NonNull String text = instructionCounterSource != null && !rows.isEmpty() ? instructionCounterSource.calculateFunctionTabSelectionText(rows.stream().map(row -> (FunctionRow)row).map(ReportRow::getModelObject)) : FunctionMessages.NA;
        boolean needLayout = false;
        needLayout |= this.mTotalsField.setText(NumberUtils.prettyFormat((int)count));
        if (needLayout |= this.mSamplesField.setText(text)) {
            SafeUpdate.layout(this.getToolbar());
        }
    }

    public boolean setFocus() {
        return this.mFunctionOutline.setFocus();
    }

    @Override
    public void sourceFilePathChanged(SourceFile[] files) {
        this.mFunctionOutline.redraw();
    }

    @Override
    protected Composite createContent() {
        Composite content = new Composite((Composite)this, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(content);
        this.createFunctionOutline(content);
        return content;
    }

    @Override
    protected void fillToolbar(CustomToolbar toolbar) {
        @NonNull Analysis analysis = this.getAnalysis();
        @NonNull InstructionCountersViewModel instructionCountersViewModel = this.getInstructionCounterViewModel();
        @NonNull AnalysisOutline mFunctionOutline = (AnalysisOutline)NullChecking.neverNull(this.mFunctionOutline);
        toolbar.addAction(new OpenSourceFileAction(mFunctionOutline, analysis::showPathSubstitutionDialog)).setLayoutData(new CustomToolbar.LayoutData().setGap(1));
        InstructionCountersViewUtils.createSelectCurrentSourceCombo(instructionCountersViewModel, this.ctx, toolbar, new CustomToolbar.LayoutData().setFillRowHeight().setMinimumWidth(50).setGap(5).setExcludeHidden());
        this.mFilterField = new FilterField(toolbar, this, FunctionMessages.FILTER, FunctionMessages.FILTER_TOOLTIP);
        this.mFilterField.setLayoutData(new CustomToolbar.LayoutData().setFill().setMinimumWidth(100).setGap(5));
        this.mTotalsField = new ToolbarReadout(toolbar, NumberUtils.prettyFormat((int)0), 131072, FunctionMessages.TOTAL_TOOLTIP);
        this.mTotalsField.setDesiredMinimumTextWidth(FontInfo.get(this.mTotalsField.getFont()).getWidth("000"));
        this.mTotalsField.setLayoutData(new CustomToolbar.LayoutData().setMinimumWidth(this.mTotalsField.computeSize((int)-1, (int)-1).x).setGap(5));
        this.mSamplesField = new ToolbarReadout(toolbar, FunctionMessages.NA, 131072, FunctionMessages.SAMPLES_TOOLTIP);
        this.mSamplesField.setDesiredMinimumTextWidth(FontInfo.get(this.mSamplesField.getFont()).getWidth("0000000000000000"));
        this.mSamplesField.setLayoutData(new CustomToolbar.LayoutData().setMinimumWidth(this.mSamplesField.computeSize((int)-1, (int)-1).x).setGap(5));
        toolbar.addAction(new ExportTableAction(analysis, mFunctionOutline, "functions_for_{0}.csv"));
    }

    @Override
    protected String getHelpID() {
        return "com.arm.streamline.functions";
    }

    @Override
    protected void initActionMap(Map<String, IAction> map) {
        String id = ActionFactory.SELECT_ALL.getId();
        map.put(id, (IAction)new CommandAction(id, this));
        id = ActionFactory.COPY.getId();
        map.put(id, (IAction)new CommandAction(id, this));
    }

    protected final void loadFunctionOutline(@Nullable IInstructionCounterSource instructionCounterSource) {
        Pattern pattern;
        String config = this.mFunctionOutline.getConfig();
        this.mFunctionOutline.setAllowLazyAdjust(false);
        OutlineModel outlineModel = this.mFunctionOutline.getModel();
        boolean canNotify = outlineModel.getSelection().canNotify();
        outlineModel.getSelection().setNotify(false);
        outlineModel.removeAllRows();
        Pattern pattern2 = pattern = this.mFilterField != null && !this.mFilterField.getText().trim().isEmpty() ? this.mFilterField.getPattern() : null;
        if (instructionCounterSource != null) {
            @NonNull IInstructionCounterFunctionViews functions = instructionCounterSource.getFunctionViews();
            if (functions.size() > 10000) {
                for (EnumColumn column : outlineModel.getColumns()) {
                    @NonNull IFunctionColumn one = (IFunctionColumn)column.getColumnEnum();
                    column.setDefaultPreferredWidth(Math.min(one.getPreferredWidth(instructionCounterSource) + 12, column.getMaxWidth()));
                }
            }
            ArrayList<@NonNull FunctionRow> rows = new ArrayList<FunctionRow>();
            if (this.mSelectedIds == null || this.mSelectedIds.isEmpty()) {
                StreamSupport.stream(functions.spliterator(), false).filter(function -> pattern == null || pattern.matcher(function.getFunction().getName()).find()).map(FunctionRow::new).forEach(f -> {
                    if (f != null) {
                        rows.add((FunctionRow)f);
                    }
                });
            } else {
                for (IInstructionCounterFunctionView function2 : functions) {
                    Optional<Integer> matchesCallPathFilter;
                    if (pattern != null && !pattern.matcher(function2.getFunction().getName()).find() || !(matchesCallPathFilter = function2.getAssociatedCallPaths().stream().flatMap(cp -> StreamSupport.stream(cp.walkToRoot().spliterator(), false)).map(ICallPath::getID).filter(id -> id != null && this.mSelectedIds.contains(id.intValue())).findFirst()).isPresent()) continue;
                    rows.add(new FunctionRow(function2));
                }
            }
            outlineModel.addNonHierarchicalRowsFast(rows);
        }
        this.mFunctionOutline.applyConfig(config, true, true);
        this.mFunctionOutline.setAllowLazyAdjust(true);
        this.mFunctionOutline.sizeColumnsToFit();
        outlineModel.getSelection().setNotify(canNotify);
        this.mFunctionOutline.getDefaultConfig();
        this.mFunctionOutline.adjustScrollBarsForContent();
    }

    private Composite createFunctionOutline(Composite parent) {
        @NonNull Analysis analysis = this.getAnalysis();
        @NonNull InstructionCountersViewModel instructionCounterViewModel = this.getInstructionCounterViewModel();
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(wrapper);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)wrapper);
        Header header = new Header(wrapper);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(header);
        OutlineModel model = new OutlineModel();
        AnalysisOutline<IInstructionCounterFunctionView> mFunctionOutline = new AnalysisOutline<IInstructionCounterFunctionView>(wrapper, model, IInstructionCounterFunctionView.class, false);
        this.mFunctionOutline = mFunctionOutline;
        mFunctionOutline.setAnalysis(analysis);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(mFunctionOutline);
        BaseTimelineContent baseTimelineContent = this.getBaseTimelineContent();
        TIntHashSet selectedPidsAndTids = baseTimelineContent == null ? null : baseTimelineContent.getSelectedProcessAndThreadIds();
        this.mSelectedIds = new TIntHashSet();
        if (selectedPidsAndTids != null) {
            this.mSelectedIds.addAll((TIntCollection)selectedPidsAndTids);
        }
        mFunctionOutline.addOutlineListener(this);
        mFunctionOutline.addSelectionChangedListener(this);
        mFunctionOutline.setHeader(header);
        ContextMenu cm = StreamlineContextMenu.createStdContextMenu(this.getEditor(), mFunctionOutline, new EditorTabID[]{EditorTabID.FUNCTIONS});
        cm.add(new FunctionContributor(() -> FunctionTab.createFunctionMenuContributionSorters(instructionCounterViewModel)));
        this.updateListener = new InstructionCounterFunctionOutlineUpdater(mFunctionOutline, (IInstructionCounterSource)instructionCounterViewModel.propertyCurrentSelectedSource().getValue());
        instructionCounterViewModel.propertyCurrentSelectedSource().addValueChangeListener((IValueChangeListener)this.updateListener);
        return wrapper;
    }

    private static @NonNull List<@NonNull FunctionContributor.IFunctionContributorSortProperties> createFunctionMenuContributionSorters(@NonNull InstructionCountersViewModel instructionCounterViewModel) {
        return Arrays.asList(new FunctionContributor.IFunctionContributorSortProperties(){

            @Override
            public long getItemCount(@NonNull ICallPath callPath) {
                return callPath.getCounters().getSelfCounterValue(0, 0);
            }

            @Override
            public @NonNull String getName() {
                return FunctionMessages.TOP_LINKS_BY_SELF;
            }

            @Override
            public long getTotalCount(@NonNull IInstructionCounterFunctionView function) {
                return function.getCounterSet().getSelfCounterValue(0, 0);
            }
        }, new FunctionContributor.IFunctionContributorSortProperties(){

            @Override
            public long getItemCount(@NonNull ICallPath callPath) {
                return callPath.getCounters().getTotalCounterValue(0, 0);
            }

            @Override
            public @NonNull String getName() {
                return FunctionMessages.TOP_LINKS_BY_TOTAL;
            }

            @Override
            public long getTotalCount(@NonNull IInstructionCounterFunctionView function) {
                return function.getCounterSet().getTotalCounterValue(0, 0);
            }
        });
    }

    private @NonNull InstructionCountersViewModel getInstructionCounterViewModel() {
        return this.requireEditor().requireInstructionCountersViewModel();
    }

    public final class InstructionCounterFunctionOutlineUpdater
    extends InstructionCounterOutlineUpdater<IInstructionCounterFunctionView, IFunctionColumn> {
        public InstructionCounterFunctionOutlineUpdater(@Nullable AnalysisOutline<IInstructionCounterFunctionView> outline, IInstructionCounterSource instructionCounterSource) {
            super(outline, instructionCounterSource);
        }

        @Override
        protected @NonNull Iterable<@NonNull IFunctionColumn> aggregateColumns(@Nullable IInstructionCounterSource instructionCounterSource) {
            return FunctionColumn.aggregateColumns(instructionCounterSource);
        }

        @Override
        protected void populateOutline(@Nullable IInstructionCounterSource instructionCounterSource) {
            FunctionTab.this.loadFunctionOutline(instructionCounterSource);
        }
    }
}

