/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.function;

import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.function.FunctionMessages;
import com.arm.streamline.editortabs.function.FunctionRow;
import com.arm.streamline.editortabs.function.FunctionTab;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.widget.WidgetUtils;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.contextmenu.IContextMenuContributor;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;

public class FunctionContributor
implements IContextMenuContributor {
    private static final String CMD = "FunctionCallPathLink";
    private static final int MAX = 10;
    private final @NonNull Supplier<@NonNull List<@NonNull IFunctionContributorSortProperties>> columnPropertiesSupplier;

    private static String getValue(long total, long selfTime, ICallPath callPath) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(NumberUtils.prettyFormat((long)selfTime));
        buffer.append(" (");
        buffer.append(NumberUtils.formatPercentage((double)(total > 0L ? (double)selfTime * 100.0 / (double)total : 0.0), (boolean)false));
        buffer.append(")");
        if (callPath != null) {
            buffer.append(' ');
            buffer.append(callPath.getThreadName());
        }
        return buffer.toString();
    }

    public FunctionContributor(@NonNull Supplier<@NonNull List<@NonNull IFunctionContributorSortProperties>> columnPropertiesSupplier) {
        this.columnPropertiesSupplier = columnPropertiesSupplier;
    }

    @Override
    public void cleanup(ContextMenu cm) {
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void handleCommand(ContextMenu cm, MenuItem menuItem, String menuID, String commandID) {
        if (CMD.equals(commandID)) {
            FunctionTab tab = (FunctionTab)WidgetUtils.getAncestorOfType(cm.getClickControl(), FunctionTab.class);
            tab.requireEditor().select(EditorTabID.CALL_PATH, (ISelection)new StructuredSelection(menuItem.getData()));
        }
    }

    @Override
    public void prepareMenu(ContextMenu cm) {
        OutlineModel model;
        Control control = cm.getClickControl();
        if (control instanceof Outline && (model = ((Outline)control).getModel()).getSelectionCount() == 1) {
            FunctionRow cpfRow = (FunctionRow)model.getSelectionAsList().get(0);
            IInstructionCounterFunctionView function = (IInstructionCounterFunctionView)cpfRow.getModelObject();
            ArrayList<@NonNull ICallPath> callPaths = new ArrayList<ICallPath>(function.getAssociatedCallPaths());
            @NonNull List<@NonNull IFunctionContributorSortProperties> columns = this.columnPropertiesSupplier.get();
            if (!callPaths.isEmpty() && !columns.isEmpty()) {
                cm.createConditionalSeparator();
                for (IFunctionContributorSortProperties properties : columns) {
                    this.createMenuFor(cm, function, callPaths, properties);
                }
            }
        }
    }

    private void createMenuFor(@NonNull ContextMenu cm, @NonNull IInstructionCounterFunctionView function, @NonNull List<@NonNull ICallPath> callPaths, @NonNull IFunctionContributorSortProperties properties) {
        boolean needRemainder;
        int max;
        cm.createCascadeMenu(properties.getName(), CMD, true);
        long total = properties.getTotalCount(function);
        if (callPaths.size() > 11) {
            max = 11;
            needRemainder = true;
        } else {
            max = callPaths.size() + 1;
            needRemainder = false;
        }
        long remainderTime = 0L;
        int count = 0;
        for (ICallPath callPath : callPaths) {
            long time = properties.getItemCount(callPath);
            if (++count < max) {
                MenuItem item = cm.createCascadeMenuItem(this, CMD, FunctionContributor.getValue(total, time, callPath), CMD, true);
                item.setData((Object)callPath);
                continue;
            }
            remainderTime += time;
        }
        if (needRemainder) {
            String value = FunctionContributor.getValue(total, remainderTime, null);
            cm.createCascadeMenuItem(this, CMD, MessageFormat.format(FunctionMessages.REMAINDER, value, NumberUtils.format((long)(count - 10))), CMD, false);
        }
    }

    public static interface IFunctionContributorSortProperties
    extends Comparator<ICallPath> {
        @Override
        default public int compare(ICallPath o1, ICallPath o2) {
            long t2;
            long t1 = this.getItemCount(o1);
            if (t1 < (t2 = this.getItemCount(o2))) {
                return 1;
            }
            if (t1 > t2) {
                return -1;
            }
            return o1.compareTo((Object)o2);
        }

        public long getItemCount(@NonNull ICallPath var1);

        public @NonNull String getName();

        public long getTotalCount(@NonNull IInstructionCounterFunctionView var1);
    }
}

