/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.function;

import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.FunctionColumnUtils;
import com.arm.streamline.editortabs.callpath.CallPathFunctionColumn;
import com.arm.streamline.editortabs.function.FunctionInstructionCounterColumn;
import com.arm.streamline.editortabs.function.FunctionMessages;
import com.arm.streamline.editortabs.function.FunctionNameCell;
import com.arm.streamline.editortabs.function.FunctionStackCell;
import com.arm.streamline.editortabs.function.IFunctionColumn;
import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.report.model.ISourceReference;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.IInstructionCounter;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.IColumnCompareType;
import com.arm.streamline.widget.outline.TextCell;
import com.arm.utils.StreamUtils;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Image;

public abstract class FunctionColumn
implements IFunctionColumn {
    public static final @NonNull FunctionColumn IMAGE = new FunctionColumn(FunctionMessages.IMAGE_TITLE, true){

        @Override
        public String getDataAsText(ReportRow<IInstructionCounterFunctionView> row, IInstructionCounterFunctionView function) {
            if (function.getFunction().isUnknown()) {
                return FunctionMessages.NA;
            }
            SourceFile imageFile = function.getFunction().getImageFile();
            if (row != null && row.getOwner().isExporting()) {
                return FilePath.getPathForPlatform((String)imageFile.getFullPath());
            }
            return imageFile.getName();
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            int one = FontInfo.get(Fonts.getNormal()).getWidth("aw") / 2;
            return one * source.getModel().getImagesFile().getLargestFileName().length();
        }

        @Override
        public String getToolTip(IInstructionCounterFunctionView function) {
            if (function == null) {
                return FunctionMessages.IMAGE_DESCRIPTION;
            }
            return FilePath.getPathForPlatform((String)function.getFunction().getImageFile().getFullPath());
        }
    };
    public static final @NonNull FunctionColumn INSTANCES = new FunctionColumn(FunctionMessages.INSTANCES_TITLE){

        @Override
        public Object getData(ReportRow<IInstructionCounterFunctionView> row, IInstructionCounterFunctionView function) {
            return this.getDataAsLong(row, function);
        }

        @Override
        public long getDataAsLong(ReportRow<IInstructionCounterFunctionView> row, IInstructionCounterFunctionView function) {
            return function.getAssociatedCallPaths().size();
        }

        @Override
        public String getDataAsText(ReportRow<IInstructionCounterFunctionView> row, IInstructionCounterFunctionView function) {
            return NumberUtils.format((long)this.getDataAsLong(row, function));
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            return FontInfo.get(Fonts.getNormal()).getWidth(NumberUtils.fill((int)NumberUtils.prettyFormat((int)source.getModel().getLargestFunctionCallPathCount()).length(), (char)'0'));
        }

        @Override
        public String getToolTip(IInstructionCounterFunctionView function) {
            return function == null ? FunctionMessages.INSTANCES_DESCRIPTION : null;
        }
    };
    public static final @NonNull FunctionColumn LOCATION = new FunctionColumn(FunctionMessages.LOCATION_TITLE, true){

        @Override
        public String getDataAsText(ReportRow<IInstructionCounterFunctionView> row, IInstructionCounterFunctionView function) {
            if (function.getFunction().isUnknown()) {
                return FunctionMessages.NA;
            }
            SourceFile sourceFile = function.getFunction().getSourceFile();
            if (row != null && row.getOwner().isExporting()) {
                return FilePath.getPathForPlatform((String)sourceFile.getFullPath()) + SourceFile.getLineColumnDescription((ISourceReference)function.getFunction());
            }
            return sourceFile.getName() + SourceFile.getLineColumnDescription((ISourceReference)function.getFunction());
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            return FunctionColumnUtils.getPreferredWidth(source);
        }

        @Override
        public String getToolTip(IInstructionCounterFunctionView function) {
            if (function == null || function.getFunction().isUnknown()) {
                return FunctionMessages.LOCATION_DESCRIPTION;
            }
            return FilePath.getPathForPlatform((String)function.getFunction().getSourceFile().getFullPath());
        }
    };
    public static final @NonNull FunctionColumn NAME = new FunctionColumn(FunctionMessages.NAME_TITLE, 16384, true, 1, IColumnCompareType.TEXT()){

        @Override
        public ICell<EnumColumn<IInstructionCounterFunctionView>> getCell(Void data) {
            return new FunctionNameCell<IInstructionCounterFunctionView>();
        }

        @Override
        public String getDataAsText(ReportRow<IInstructionCounterFunctionView> row, IInstructionCounterFunctionView function) {
            return function.getFunction().getName();
        }

        @Override
        public Image getImage(ReportRow<IInstructionCounterFunctionView> row) {
            return CallPathFunctionColumn.getCallPathFunctionImage(row.getModelObject().getFunction());
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            int one = FontInfo.get(Fonts.getNormal()).getWidth("aw") / 2;
            return one * source.getModel().getLargestFunctionName().length();
        }

        @Override
        public String getToolTip(IInstructionCounterFunctionView function) {
            return function == null ? FunctionMessages.NAME_DESCRIPTION : null;
        }
    };
    public static final @NonNull FunctionColumn SIZE = new FunctionColumn(FunctionMessages.SIZE_TITLE){

        @Override
        public Object getData(ReportRow<IInstructionCounterFunctionView> row, IInstructionCounterFunctionView function) {
            return this.getDataAsLong(row, function);
        }

        @Override
        public long getDataAsLong(ReportRow<IInstructionCounterFunctionView> row, IInstructionCounterFunctionView function) {
            return function.getFunction().isUnknown() ? -1 : function.getFunction().getSize();
        }

        @Override
        public String getDataAsText(ReportRow<IInstructionCounterFunctionView> row, IInstructionCounterFunctionView function) {
            if (function.getFunction().isUnknown()) {
                return FunctionMessages.NA;
            }
            return NumberUtils.prettyFormat((int)function.getFunction().getSize());
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            return FontInfo.get(Fonts.getNormal()).getWidth(NumberUtils.fill((int)NumberUtils.prettyFormat((int)source.getModel().getLargestFunctionSize()).length(), (char)'0'));
        }

        @Override
        public String getToolTip(IInstructionCounterFunctionView function) {
            return FunctionMessages.SIZE_DESCRIPTION;
        }
    };
    public static final @NonNull FunctionColumn STACK_USED = new FunctionColumn(FunctionMessages.STACK_USED_TITLE){

        @Override
        public ICell<EnumColumn<IInstructionCounterFunctionView>> getCell(Void data) {
            return new FunctionStackCell(this.alignment, this.compareType);
        }

        @Override
        public Object getData(ReportRow<IInstructionCounterFunctionView> row, IInstructionCounterFunctionView function) {
            return this.getDataAsLong(row, function);
        }

        @Override
        public long getDataAsLong(ReportRow<IInstructionCounterFunctionView> row, IInstructionCounterFunctionView function) {
            return function.getFunction().isUnknown() ? -1 : function.getFunction().getStackSize();
        }

        @Override
        public String getDataAsText(ReportRow<IInstructionCounterFunctionView> row, IInstructionCounterFunctionView function) {
            return NumberUtils.prettyFormat((int)(function.getFunction().hasUnknownStack() ? 0 : function.getFunction().getStackSize()));
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            return FontInfo.get(Fonts.getNormal()).getWidth(NumberUtils.fill((int)NumberUtils.prettyFormat((double)source.getModel().getMaxStack()).length(), (char)'0'));
        }

        @Override
        public String getToolTip(IInstructionCounterFunctionView function) {
            if (function == null) {
                return FunctionMessages.STACK_USED_DESCRIPTION;
            }
            return function.getFunction().hasUnknownStack() ? FunctionMessages.INDETERMINATE : FunctionMessages.STACK_USED_DESCRIPTION;
        }
    };
    protected final int alignment;
    protected final @NonNull IColumnCompareType<EnumColumn<IInstructionCounterFunctionView>> compareType;
    protected final boolean initialSortAscending;
    protected final int initialSortSequence;
    protected final @NonNull String name;

    public static @NonNull Iterable<@NonNull IFunctionColumn> aggregateColumns(@Nullable IInstructionCounterSource instructionCounterSource) {
        Stream<Object> counterColumns;
        if (instructionCounterSource != null) {
            @NonNull Stream<@Nullable IInstructionCounterColumn> nullableColumns = instructionCounterSource.getInstructionCounters().stream().map(IInstructionCounter::getFunctionColumn);
            counterColumns = StreamUtils.filterOutNull(nullableColumns).map(FunctionInstructionCounterColumn::factory).flatMap(Collection::stream);
        } else {
            counterColumns = Stream.empty();
        }
        return Stream.concat(Stream.concat(Stream.of(NAME), counterColumns), Stream.of(INSTANCES, STACK_USED, SIZE, LOCATION, IMAGE)).collect(Collectors.toList());
    }

    protected FunctionColumn(@NonNull String name) {
        this(name, true, IColumnCompareType.INTEGER());
    }

    protected FunctionColumn(@NonNull String name, boolean alignLeft) {
        this(name, alignLeft ? 16384 : 131072, true, -1, IColumnCompareType.TEXT());
    }

    protected FunctionColumn(@NonNull String name, boolean initialSortAscending, @NonNull IColumnCompareType<EnumColumn<IInstructionCounterFunctionView>> compareType) {
        this(name, initialSortAscending, -1, compareType);
    }

    protected FunctionColumn(@NonNull String name, boolean initialSortAscending, int initialSortSequence) {
        this(name, initialSortAscending, initialSortSequence, IColumnCompareType.INTEGER());
    }

    protected FunctionColumn(@NonNull String name, boolean initialSortAscending, int initialSortSequence, @NonNull IColumnCompareType<EnumColumn<IInstructionCounterFunctionView>> compareType) {
        this(name, 131072, initialSortAscending, initialSortSequence, compareType);
    }

    protected FunctionColumn(@NonNull String name, int alignment, boolean initialSortAscending, int initialSortSequence, @NonNull IColumnCompareType<EnumColumn<IInstructionCounterFunctionView>> compareType) {
        this.name = name;
        this.alignment = alignment;
        this.initialSortAscending = initialSortAscending;
        this.initialSortSequence = initialSortSequence;
        this.compareType = compareType;
    }

    @Override
    public ICell<EnumColumn<IInstructionCounterFunctionView>> getCell(Void data) {
        return new TextCell<EnumColumn<IInstructionCounterFunctionView>>(this.alignment, this.compareType);
    }

    public Object getData(ReportRow<IInstructionCounterFunctionView> row, IInstructionCounterFunctionView function) {
        return this.getDataAsText(row, function);
    }

    @Override
    public final double getDataAsDouble(ReportRow<IInstructionCounterFunctionView> row) {
        return this.getDataAsDouble(row, row.getModelObject());
    }

    public double getDataAsDouble(ReportRow<IInstructionCounterFunctionView> row, IInstructionCounterFunctionView function) {
        return 0.0;
    }

    @Override
    public final long getDataAsLong(ReportRow<IInstructionCounterFunctionView> row) {
        return this.getDataAsLong(row, row.getModelObject());
    }

    public long getDataAsLong(ReportRow<IInstructionCounterFunctionView> row, IInstructionCounterFunctionView function) {
        return 0L;
    }

    @Override
    public final @NonNull String getDataAsText(ReportRow<IInstructionCounterFunctionView> row) {
        return this.getDataAsText(row, row.getModelObject());
    }

    public abstract @NonNull String getDataAsText(ReportRow<IInstructionCounterFunctionView> var1, IInstructionCounterFunctionView var2);

    @Override
    public final @NonNull String getHeader(Void data) {
        return this.name;
    }

    @Override
    public Image getImage(ReportRow<IInstructionCounterFunctionView> row) {
        return null;
    }

    @Override
    public final int getInitialSortSequence() {
        return this.initialSortSequence;
    }

    public final @NonNull String getTitle() {
        return this.getHeader(null).replace('\n', ' ');
    }

    @Override
    public final String getToolTip(ReportRow<IInstructionCounterFunctionView> row) {
        return this.getToolTip(row.getModelObject());
    }

    @Override
    public final String getToolTip(Void data) {
        return this.getToolTip((IInstructionCounterFunctionView)null);
    }

    @Override
    public final boolean isInitialSortAscending() {
        return this.initialSortAscending;
    }

    @Override
    public final boolean isPrimary() {
        return false;
    }

    @Override
    protected abstract String getToolTip(IInstructionCounterFunctionView var1);
}

