/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.code;

import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.editortabs.code.IKeywordColorData;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.widget.Colors;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.graphics.Color;

public class CFamilyKeywordColorData
implements IKeywordColorData {
    public static final IKeywordColorData DATA = new CFamilyKeywordColorData();
    private final Set<String> mExtensionSet = new HashSet<String>();
    private final Set<String> mKeywordSet = new HashSet<String>();

    private CFamilyKeywordColorData() {
        this.mExtensionSet.add(".c");
        this.mExtensionSet.add(".c++");
        this.mExtensionSet.add(".cxx");
        this.mExtensionSet.add(".cc");
        this.mExtensionSet.add(".cpp");
        this.mExtensionSet.add(".h");
        this.mExtensionSet.add(".hh");
        this.mExtensionSet.add(".hpp");
        this.mExtensionSet.add(".hxx");
        this.mExtensionSet.add(".h++");
        this.mExtensionSet.add(".ii");
        this.mExtensionSet.add(".ixx");
        this.mExtensionSet.add(".ipp");
        this.mExtensionSet.add(".inl");
        this.mExtensionSet.add(".txx");
        this.mExtensionSet.add(".tpp");
        this.mExtensionSet.add(".tpl");
        this.mKeywordSet.add("#define");
        this.mKeywordSet.add("#elif");
        this.mKeywordSet.add("#else");
        this.mKeywordSet.add("#endif");
        this.mKeywordSet.add("#error");
        this.mKeywordSet.add("#if");
        this.mKeywordSet.add("#ifdef");
        this.mKeywordSet.add("#ifndef");
        this.mKeywordSet.add("#include");
        this.mKeywordSet.add("#include_next");
        this.mKeywordSet.add("#line");
        this.mKeywordSet.add("#pragma");
        this.mKeywordSet.add("#undef");
        this.mKeywordSet.add("NULL");
        this.mKeywordSet.add("__DATE__");
        this.mKeywordSet.add("__LINE__");
        this.mKeywordSet.add("__TIME__");
        this.mKeywordSet.add("__FILE__");
        this.mKeywordSet.add("__STDC__");
        this.mKeywordSet.add("bool");
        this.mKeywordSet.add("TRUE");
        this.mKeywordSet.add("FALSE");
        this.mKeywordSet.add("_Bool");
        this.mKeywordSet.add("_Complex");
        this.mKeywordSet.add("_Imaginary");
        this.mKeywordSet.add("alignof");
        this.mKeywordSet.add("and");
        this.mKeywordSet.add("and_eq");
        this.mKeywordSet.add("asm");
        this.mKeywordSet.add("auto");
        this.mKeywordSet.add("bitand");
        this.mKeywordSet.add("bitor");
        this.mKeywordSet.add("bool");
        this.mKeywordSet.add("break");
        this.mKeywordSet.add("case");
        this.mKeywordSet.add("cast");
        this.mKeywordSet.add("catch");
        this.mKeywordSet.add("char");
        this.mKeywordSet.add("class");
        this.mKeywordSet.add("compl");
        this.mKeywordSet.add("const");
        this.mKeywordSet.add("const_cast");
        this.mKeywordSet.add("continue");
        this.mKeywordSet.add("default");
        this.mKeywordSet.add("delete");
        this.mKeywordSet.add("do");
        this.mKeywordSet.add("double");
        this.mKeywordSet.add("dynamic_cast");
        this.mKeywordSet.add("else");
        this.mKeywordSet.add("enum");
        this.mKeywordSet.add("explicit");
        this.mKeywordSet.add("export");
        this.mKeywordSet.add("extern");
        this.mKeywordSet.add("false");
        this.mKeywordSet.add("float");
        this.mKeywordSet.add("for");
        this.mKeywordSet.add("friend");
        this.mKeywordSet.add("goto");
        this.mKeywordSet.add("if");
        this.mKeywordSet.add("inline");
        this.mKeywordSet.add("int");
        this.mKeywordSet.add("long");
        this.mKeywordSet.add("mutable");
        this.mKeywordSet.add("namespace");
        this.mKeywordSet.add("new");
        this.mKeywordSet.add("not");
        this.mKeywordSet.add("not_eq");
        this.mKeywordSet.add("operator");
        this.mKeywordSet.add("or");
        this.mKeywordSet.add("or_eq");
        this.mKeywordSet.add("private");
        this.mKeywordSet.add("protected");
        this.mKeywordSet.add("public");
        this.mKeywordSet.add("register");
        this.mKeywordSet.add("reinterpret_cast");
        this.mKeywordSet.add("restrict");
        this.mKeywordSet.add("return");
        this.mKeywordSet.add("short");
        this.mKeywordSet.add("signed");
        this.mKeywordSet.add("sizeof");
        this.mKeywordSet.add("static");
        this.mKeywordSet.add("static_cast");
        this.mKeywordSet.add("struct");
        this.mKeywordSet.add("switch");
        this.mKeywordSet.add("template");
        this.mKeywordSet.add("this");
        this.mKeywordSet.add("throw");
        this.mKeywordSet.add("true");
        this.mKeywordSet.add("try");
        this.mKeywordSet.add("typedef");
        this.mKeywordSet.add("typeid");
        this.mKeywordSet.add("typename");
        this.mKeywordSet.add("typeof");
        this.mKeywordSet.add("union");
        this.mKeywordSet.add("unsigned");
        this.mKeywordSet.add("using");
        this.mKeywordSet.add("virtual");
        this.mKeywordSet.add("void");
        this.mKeywordSet.add("volatile");
        this.mKeywordSet.add("wchar_t");
        this.mKeywordSet.add("while");
        this.mKeywordSet.add("xor");
        this.mKeywordSet.add("xor_eq");
    }

    @Override
    public final boolean canColorize(SourceFile file) {
        if (file == null) {
            return false;
        }
        String extension = FilePath.getExtension((String)file.getName());
        return extension.isEmpty() || this.mExtensionSet.contains(extension.toLowerCase());
    }

    @Override
    public final Color getCommentColor() {
        return Colors.getSourceComments();
    }

    @Override
    public final Color getKeywordColor() {
        return Colors.getSourceKeywords();
    }

    @Override
    public final Color getQuoteColor() {
        return Colors.getSourceStrings();
    }

    @Override
    public final boolean isKeyword(String text) {
        return this.mKeywordSet.contains(text);
    }
}

