/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.callpath;

import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.report.model.icounters.HistogramDataPoint;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;

public class Utilities {
    private static final int MIN_WIDTH_HEATBAR = 50;
    public static final String TAB_SPACE = "\t";
    public static final int MAX_HISTOGRAM_WIDTH = 256;

    public static int getPercentPreferredWidth() {
        return FontInfo.get(Fonts.getNormal()).getWidth("> 99.99%") + 50;
    }

    public static int getValuePreferredWidth(long maxValue) {
        return FontInfo.get(Fonts.getNormal()).getWidth(NumberUtils.fill((int)NumberUtils.prettyFormat((long)maxValue).length(), (char)'0'));
    }

    public static int getValuePreferredWidth(double maxValue) {
        return FontInfo.get(Fonts.getNormal()).getWidth(NumberUtils.fill((int)NumberUtils.prettyFormat((double)maxValue).length(), (char)'0'));
    }

    public static int getValueAndPercentagePreferredWidth(long maxValue) {
        return Utilities.getValuePreferredWidth(maxValue) + FontInfo.get(Fonts.getNormal()).getWidth(TAB_SPACE) + Utilities.getPercentPreferredWidth();
    }

    public static int getValuePreferredWidth(@NonNull IInstructionCounterSource source) {
        return Utilities.getValuePreferredWidth(source.getTotalFunctionSamples());
    }

    public static int getValueAndPercentagePreferredWidth(@NonNull IInstructionCounterSource source) {
        return Utilities.getValueAndPercentagePreferredWidth(source.getTotalFunctionSamples());
    }

    public static int getRatioPreferredWidth(long @NonNull [] maxValues) {
        String maxString = Arrays.stream(maxValues).mapToObj(maxValue -> NumberUtils.fill((int)NumberUtils.prettyFormat((long)maxValue).length(), (char)'0')).collect(Collectors.joining(":"));
        return FontInfo.get(Fonts.getNormal()).getWidth(maxString);
    }

    public static int getHistogramPreferredWidth(@NonNull HistogramDataPoint @NonNull [] datapoints, long @NonNull [] maxValues) {
        long @NonNull [] datapointBase = HistogramDataPoint.calculateAbsoluteBaseValues((HistogramDataPoint[])datapoints);
        long smallestDataPoint = datapointBase.length > 0 ? datapointBase[0] : 0L;
        long largestDataPoint = datapointBase.length > 0 ? datapointBase[datapointBase.length - 1] + (long)datapoints[datapoints.length - 1].width - 1L : 0L;
        long numberOfDataPoints = largestDataPoint - smallestDataPoint + 1L;
        int pixelsPerDatapoint = Math.max((int)(256L / numberOfDataPoints), 1);
        return (int)Math.min(256L, (long)pixelsPerDatapoint * numberOfDataPoints);
    }
}

