/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.callpath;

import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.callpath.CallPathFunctionRow;
import com.arm.streamline.editortabs.callpath.CallPathMessages;
import com.arm.streamline.editortabs.callpath.CallPathTab;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.ICallPathFunction;
import com.arm.streamline.widget.WidgetUtils;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.contextmenu.IContextMenuContributor;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.OutlineModel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MenuItem;

public class CallPathFunctionContributor
implements IContextMenuContributor {
    private static final String CMD = "CallPathFunctionLink";
    private static final int MAX = 10;
    private final @NonNull Supplier<@NonNull List<@NonNull ICallPathFunctionContributorSortProperties>> columnPropertiesSupplier;

    private static String getValue(long total, long selfTime) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(NumberUtils.prettyFormat((long)selfTime));
        buffer.append(" (");
        buffer.append(NumberUtils.formatPercentage((double)(total > 0L ? (double)selfTime * 100.0 / (double)total : 0.0), (boolean)false));
        buffer.append(")");
        return buffer.toString();
    }

    public CallPathFunctionContributor(@NonNull Supplier<@NonNull List<@NonNull ICallPathFunctionContributorSortProperties>> columnPropertiesSupplier) {
        this.columnPropertiesSupplier = columnPropertiesSupplier;
    }

    @Override
    public void cleanup(ContextMenu cm) {
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void handleCommand(ContextMenu cm, MenuItem menuItem, String menuID, String commandID) {
        if (CMD.equals(commandID)) {
            CallPathTab tab = (CallPathTab)WidgetUtils.getAncestorOfType(cm.getClickControl(), CallPathTab.class);
            tab.requireEditor().select(EditorTabID.CALL_PATH, (ISelection)new StructuredSelection(menuItem.getData()));
        }
    }

    @Override
    public void prepareMenu(ContextMenu cm) {
        OutlineModel model;
        Control control = cm.getClickControl();
        if (control instanceof Outline && (model = ((Outline)control).getModel()).getSelectionCount() == 1) {
            CallPathFunctionRow cpfRow = (CallPathFunctionRow)model.getSelectionAsList().get(0);
            ICallPathFunction cpf = (ICallPathFunction)cpfRow.getModelObject();
            ArrayList<@NonNull ICallPath> callPaths = new ArrayList<ICallPath>(cpf.getCallPaths());
            @NonNull List<@NonNull ICallPathFunctionContributorSortProperties> columnPropertiesList = this.columnPropertiesSupplier.get();
            if (!callPaths.isEmpty() && !columnPropertiesList.isEmpty()) {
                for (ICallPathFunctionContributorSortProperties columnProperties : columnPropertiesList) {
                    this.createMenuFor(cm, cpf, callPaths, columnProperties);
                }
            }
        }
    }

    private void createMenuFor(@NonNull ContextMenu cm, @NonNull ICallPathFunction cpf, @NonNull List<@NonNull ICallPath> callPaths, @NonNull ICallPathFunctionContributorSortProperties columnProperties) {
        boolean needRemainder;
        int max;
        Collections.sort(callPaths, columnProperties);
        cm.createConditionalSeparator();
        cm.createCascadeMenu(columnProperties.getName(), CMD, true);
        long total = columnProperties.getTotalCount(cpf);
        if (callPaths.size() > 11) {
            max = 11;
            needRemainder = true;
        } else {
            max = callPaths.size() + 1;
            needRemainder = false;
        }
        long remainderTime = 0L;
        int count = 0;
        for (ICallPath callPath : callPaths) {
            long selfTime = columnProperties.getItemCount(callPath);
            if (++count < max) {
                MenuItem item = cm.createCascadeMenuItem(this, CMD, CallPathFunctionContributor.getValue(total, selfTime), CMD, true);
                item.setData((Object)callPath);
                continue;
            }
            remainderTime += selfTime;
        }
        if (needRemainder) {
            String value = CallPathFunctionContributor.getValue(total, remainderTime);
            cm.createCascadeMenuItem(this, CMD, MessageFormat.format(CallPathMessages.REMAINDER, value, NumberUtils.format((long)(count - 10))), CMD, false);
        }
    }

    public static interface ICallPathFunctionContributorSortProperties
    extends Comparator<ICallPath> {
        @Override
        default public int compare(ICallPath o1, ICallPath o2) {
            long t2;
            long t1 = this.getItemCount(o1);
            if (t1 < (t2 = this.getItemCount(o2))) {
                return 1;
            }
            if (t1 > t2) {
                return -1;
            }
            return o1.compareTo((Object)o2);
        }

        public long getItemCount(@NonNull ICallPath var1);

        public @NonNull String getName();

        public long getTotalCount(@NonNull ICallPathFunction var1);
    }
}

