/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.callpath;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.FunctionColumnUtils;
import com.arm.streamline.editortabs.callpath.CallPathFunctionInstructionCounterColumn;
import com.arm.streamline.editortabs.callpath.CallPathMessages;
import com.arm.streamline.editortabs.callpath.ICallPathFunctionColumn;
import com.arm.streamline.editortabs.function.FunctionNameCell;
import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.report.model.ICallPathFunction;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.ISourceReference;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.IInstructionCounter;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.IColumnCompareType;
import com.arm.streamline.widget.outline.TextCell;
import com.arm.utils.NullChecking;
import com.arm.utils.StreamUtils;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Image;

public abstract class CallPathFunctionColumn
implements ICallPathFunctionColumn {
    public static final @NonNull CallPathFunctionColumn INSTANCES = new CallPathFunctionColumn(){

        @Override
        public IColumnCompareType<EnumColumn<ICallPathFunction>> getCompareType() {
            return IColumnCompareType.INTEGER();
        }

        @Override
        public Object getData(ICallPathFunction cpf) {
            return this.getDataAsLong(cpf);
        }

        @Override
        public long getDataAsLong(ICallPathFunction cpf) {
            return cpf.getInstanceCount();
        }

        @Override
        public String getDataAsText(ICallPathFunction cpf) {
            return NumberUtils.format((long)this.getDataAsLong(cpf));
        }

        @Override
        public String getHeader(Void data) {
            return CallPathMessages.INSTANCES_TITLE;
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            return FontInfo.get(Fonts.getNormal()).getWidth(NumberUtils.fill((int)NumberUtils.prettyFormat((int)source.getModel().getLargestFunctionCallPathCount()).length(), (char)'0'));
        }

        @Override
        public String getToolTip(ICallPathFunction cpf) {
            return cpf == null ? CallPathMessages.INSTANCES_DESCRIPTION : null;
        }
    };
    public static final @NonNull CallPathFunctionColumn LOCATION = new CallPathFunctionColumn(){

        @Override
        public int getAlignment() {
            return 16384;
        }

        @Override
        public String getDataAsText(ICallPathFunction cpf) {
            if (cpf.isUnknown()) {
                return CallPathMessages.NA;
            }
            return cpf.getSourceFile().getName() + SourceFile.getLineColumnDescription((ISourceReference)cpf.getFunction());
        }

        @Override
        public String getHeader(Void data) {
            return CallPathMessages.LOCATION_TITLE;
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            return FunctionColumnUtils.getPreferredWidth(source);
        }

        @Override
        public String getToolTip(ICallPathFunction cpf) {
            if (cpf == null || cpf.isUnknown()) {
                return CallPathMessages.LOCATION_DESCRIPTION;
            }
            return FilePath.getPathForPlatform((String)cpf.getSourceFile().getFullPath());
        }
    };
    public static final @NonNull CallPathFunctionColumn NAME = new CallPathFunctionColumn(){

        @Override
        public int getAlignment() {
            return 16384;
        }

        @Override
        public ICell<EnumColumn<ICallPathFunction>> getCell(Void data) {
            return new FunctionNameCell<ICallPathFunction>();
        }

        @Override
        public String getDataAsText(ICallPathFunction cpf) {
            return cpf.getName();
        }

        @Override
        public String getHeader(Void data) {
            return CallPathMessages.FUNCTION_NAME_TITLE;
        }

        @Override
        public @Nullable Image getImage(ReportRow<ICallPathFunction> row) {
            return CallPathFunctionColumn.getCallPathFunctionImage((IFunction)NullChecking.neverNull((Object)row.getModelObject().getFunction()));
        }

        @Override
        public int getInitialSortSequence() {
            return 1;
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            int one = FontInfo.get(Fonts.getNormal()).getWidth("aw") / 2;
            return one * source.getModel().getLargestFunctionName().length();
        }

        @Override
        public String getToolTip(ICallPathFunction cpf) {
            return cpf == null ? CallPathMessages.FUNCTION_NAME_DESCRIPTION : null;
        }
    };

    public static @NonNull Iterable<@NonNull ICallPathFunctionColumn> aggregateColumns(@Nullable IInstructionCounterSource instructionCounterSource) {
        Stream<Object> counterColumns;
        if (instructionCounterSource != null) {
            @NonNull Stream<@Nullable IInstructionCounterColumn> nullableColumns = instructionCounterSource.getInstructionCounters().stream().map(IInstructionCounter::getCallPathFunctionColumn);
            counterColumns = StreamUtils.filterOutNull(nullableColumns).map(CallPathFunctionInstructionCounterColumn::factory).flatMap(Collection::stream);
        } else {
            counterColumns = Stream.empty();
        }
        return Stream.concat(Stream.concat(Stream.of(NAME), counterColumns), Stream.of(INSTANCES, LOCATION)).collect(Collectors.toList());
    }

    public static Image getCallPathFunctionImage(@NonNull IFunction function) {
        if (function.isUnknown()) {
            return StreamlinePlugin.getImage("WarningSmall.png");
        }
        return StreamlinePlugin.getImage("Function.png");
    }

    public int getAlignment() {
        return 131072;
    }

    @Override
    public ICell<EnumColumn<ICallPathFunction>> getCell(Void data) {
        return new TextCell<EnumColumn<ICallPathFunction>>(this.getAlignment());
    }

    public IColumnCompareType<EnumColumn<ICallPathFunction>> getCompareType() {
        return IColumnCompareType.TEXT();
    }

    public Object getData(ICallPathFunction cpf) {
        return this.getDataAsText(cpf);
    }

    public double getDataAsDouble(ICallPathFunction cpf) {
        return 0.0;
    }

    @Override
    public final double getDataAsDouble(ReportRow<ICallPathFunction> row) {
        return this.getDataAsDouble(row.getModelObject());
    }

    public long getDataAsLong(ICallPathFunction cpf) {
        return 0L;
    }

    @Override
    public final long getDataAsLong(ReportRow<ICallPathFunction> row) {
        return this.getDataAsLong(row.getModelObject());
    }

    public abstract @NonNull String getDataAsText(ICallPathFunction var1);

    @Override
    public final @NonNull String getDataAsText(ReportRow<ICallPathFunction> row) {
        return this.getDataAsText(row.getModelObject());
    }

    @Override
    public Image getImage(ReportRow<ICallPathFunction> row) {
        return null;
    }

    @Override
    public int getInitialSortSequence() {
        return -1;
    }

    public String getTitle() {
        return this.getHeader(null).replace('\n', ' ');
    }

    @Override
    public abstract String getToolTip(ICallPathFunction var1);

    @Override
    public final String getToolTip(ReportRow<ICallPathFunction> row) {
        return this.getToolTip(row.getModelObject());
    }

    @Override
    public final String getToolTip(Void data) {
        return this.getToolTip((ICallPathFunction)null);
    }

    @Override
    public boolean isInitialSortAscending() {
        return true;
    }

    @Override
    public boolean isPrimary() {
        return false;
    }
}

