/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs.callpath;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.FunctionColumnUtils;
import com.arm.streamline.editortabs.callpath.CallPathFunctionColumn;
import com.arm.streamline.editortabs.callpath.CallPathInstructionCounterColumn;
import com.arm.streamline.editortabs.callpath.CallPathMessages;
import com.arm.streamline.editortabs.callpath.CallPathStackCell;
import com.arm.streamline.editortabs.callpath.ICallPathColumn;
import com.arm.streamline.editortabs.function.FunctionNameCell;
import com.arm.streamline.editortabs.report.ReportRow;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.ISourceReference;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.IInstructionCounter;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.ICell;
import com.arm.streamline.widget.outline.IColumnCompareType;
import com.arm.streamline.widget.outline.TextCell;
import com.arm.utils.NullChecking;
import com.arm.utils.StreamUtils;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Image;

public abstract class CallPathColumn
implements ICallPathColumn {
    public static final @NonNull CallPathColumn LOCATION = new CallPathColumn(CallPathMessages.LOCATION_TITLE, true){

        @Override
        public String getDataAsText(ReportRow<ICallPath> row, ICallPath link) {
            IFunction function;
            @Nullable IInstructionCounterFunctionView functionView = link != null ? link.getFunction() : null;
            IFunction iFunction = function = functionView != null ? functionView.getFunction() : null;
            if (function != null && !function.isUnknown()) {
                @NonNull SourceFile file = function.getSourceFile();
                if (row != null && row.getOwner().isExporting()) {
                    return FilePath.getPathForPlatform((String)file.getFullPath()) + SourceFile.getLineColumnDescription((ISourceReference)function);
                }
                return file.getName() + SourceFile.getLineColumnDescription((ISourceReference)function);
            }
            return CallPathMessages.NA;
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            return FunctionColumnUtils.getPreferredWidth(source);
        }

        @Override
        public String getToolTip(ICallPath link) {
            IFunction function;
            @Nullable IInstructionCounterFunctionView functionView = link != null ? link.getFunction() : null;
            IFunction iFunction = function = functionView != null ? functionView.getFunction() : null;
            if (function != null && !function.isUnknown()) {
                @NonNull SourceFile file = function.getSourceFile();
                return FilePath.getPathForPlatform((String)file.getFullPath());
            }
            return CallPathMessages.LOCATION_DESCRIPTION;
        }
    };
    public static final @NonNull CallPathColumn NAME = new CallPathColumn(CallPathMessages.CALL_PATH_NAME_TITLE, 16384, true, 1, IColumnCompareType.TEXT()){

        @Override
        public ICell<EnumColumn<ICallPath>> getCell(Void data) {
            FunctionNameCell<ICallPath> cell = new FunctionNameCell<ICallPath>();
            cell.setIconHAlignment(16384);
            return cell;
        }

        @Override
        public String getDataAsText(ReportRow<ICallPath> row, ICallPath link) {
            return link.getName();
        }

        @Override
        public Image getImage(ReportRow<ICallPath> row) {
            @NonNull ICallPath modelObject = row.getModelObject();
            return 2.getCallPathImage(modelObject);
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            int one = FontInfo.get(Fonts.getNormal()).getWidth("aw") / 2;
            return one * source.getModel().getLargestCallPathName().length();
        }

        @Override
        public @Nullable String getToolTip(ICallPath link) {
            return link == null ? CallPathMessages.CALL_PATH_NAME_DESCRIPTION : null;
        }

        @Override
        public boolean isPrimary() {
            return true;
        }
    };
    public static final @NonNull CallPathColumn STACK_USED = new CallPathColumn(CallPathMessages.STACK_USED_TITLE){

        @Override
        public ICell<EnumColumn<ICallPath>> getCell(Void data) {
            return new CallPathStackCell(this.getAlignment(), this.getCompareType());
        }

        @Override
        public Object getData(ReportRow<ICallPath> row, ICallPath link) {
            return this.getDataAsLong(row, link);
        }

        @Override
        public long getDataAsLong(ReportRow<ICallPath> row, ICallPath link) {
            return link.getStackSize();
        }

        @Override
        public String getDataAsText(ReportRow<ICallPath> row, ICallPath link) {
            int stackSize;
            if (!link.isStructureOnlyNode() && (stackSize = link.getStackSize()) >= 0) {
                return NumberUtils.prettyFormat((int)stackSize);
            }
            return "";
        }

        @Override
        public int getPreferredWidth(@NonNull IInstructionCounterSource source) {
            return FontInfo.get(Fonts.getNormal()).getWidth(NumberUtils.fill((int)NumberUtils.prettyFormat((double)source.getModel().getMaxStack()).length(), (char)'0'));
        }

        @Override
        public String getToolTip(ICallPath link) {
            if (link == null) {
                return CallPathMessages.STACK_USED_DESCRIPTION;
            }
            return link.hasUnknownStack() ? CallPathMessages.INDETERMINATE : null;
        }
    };
    protected final int alignment;
    protected final @NonNull IColumnCompareType<EnumColumn<ICallPath>> compareType;
    protected final boolean initialSortAscending;
    protected final int initialSortSequence;
    protected final @NonNull String name;

    public static @NonNull Iterable<@NonNull ICallPathColumn> aggregateColumns(@Nullable IInstructionCounterSource instructionCounterSource) {
        Stream<Object> counterColumns;
        if (instructionCounterSource != null) {
            @NonNull Stream<@Nullable IInstructionCounterColumn> nullableColumns = instructionCounterSource.getInstructionCounters().stream().map(IInstructionCounter::getCallPathColumn);
            counterColumns = StreamUtils.filterOutNull(nullableColumns).map(CallPathInstructionCounterColumn::factory).flatMap(Collection::stream);
        } else {
            counterColumns = Stream.empty();
        }
        return Stream.concat(Stream.concat(Stream.of(NAME), counterColumns), Stream.of(STACK_USED, LOCATION)).collect(Collectors.toList());
    }

    public static Image getCallPathImage(@NonNull ICallPath modelObject) {
        switch (modelObject.getType()) {
            case FUNCTION: {
                @NonNull IInstructionCounterFunctionView functionView = (IInstructionCounterFunctionView)NullChecking.neverNull((Object)modelObject.getFunction());
                return CallPathFunctionColumn.getCallPathFunctionImage(functionView.getFunction());
            }
            case UID: {
                if (modelObject.isProcessUID()) {
                    return StreamlinePlugin.getImage("Process.png");
                }
                return StreamlinePlugin.getImage("Thread.gif");
            }
            case VMUID: {
                return StreamlinePlugin.getImage("VirtualMachine.png");
            }
        }
        throw new AssertionError(modelObject.getType());
    }

    protected CallPathColumn(@NonNull String name) {
        this(name, true, IColumnCompareType.INTEGER());
    }

    protected CallPathColumn(@NonNull String name, boolean alignLeft) {
        this(name, alignLeft ? 16384 : 131072, true, -1, IColumnCompareType.TEXT());
    }

    protected CallPathColumn(@NonNull String name, boolean initialSortAscending, @NonNull IColumnCompareType<EnumColumn<ICallPath>> compareType) {
        this(name, initialSortAscending, -1, compareType);
    }

    protected CallPathColumn(@NonNull String name, boolean initialSortAscending, int initialSortSequence) {
        this(name, initialSortAscending, initialSortSequence, IColumnCompareType.INTEGER());
    }

    protected CallPathColumn(@NonNull String name, boolean initialSortAscending, int initialSortSequence, @NonNull IColumnCompareType<EnumColumn<ICallPath>> compareType) {
        this(name, 131072, initialSortAscending, initialSortSequence, compareType);
    }

    protected CallPathColumn(@NonNull String name, int alignment, boolean initialSortAscending, int initialSortSequence, @NonNull IColumnCompareType<EnumColumn<ICallPath>> compareType) {
        this.name = name;
        this.alignment = alignment;
        this.initialSortAscending = initialSortAscending;
        this.initialSortSequence = initialSortSequence;
        this.compareType = compareType;
    }

    @Override
    public ICell<EnumColumn<ICallPath>> getCell(Void data) {
        return new TextCell<EnumColumn<ICallPath>>(this.getAlignment(), this.getCompareType());
    }

    public Object getData(ReportRow<ICallPath> row, ICallPath link) {
        return this.getDataAsText(row, link);
    }

    @Override
    public final double getDataAsDouble(ReportRow<ICallPath> row) {
        return this.getDataAsDouble(row, row.getModelObject());
    }

    public double getDataAsDouble(ReportRow<ICallPath> row, ICallPath link) {
        return 0.0;
    }

    @Override
    public final long getDataAsLong(ReportRow<ICallPath> row) {
        return this.getDataAsLong(row, row.getModelObject());
    }

    public long getDataAsLong(ReportRow<ICallPath> row, ICallPath link) {
        return 0L;
    }

    @Override
    public final @NonNull String getDataAsText(ReportRow<ICallPath> row) {
        return this.getDataAsText(row, row.getModelObject());
    }

    public abstract @NonNull String getDataAsText(ReportRow<ICallPath> var1, ICallPath var2);

    @Override
    public final @NonNull String getHeader(Void data) {
        return this.name;
    }

    public Image getImage(ICallPath link) {
        return null;
    }

    @Override
    public Image getImage(ReportRow<ICallPath> row) {
        if (row != null) {
            return this.getImage(row.getModelObject());
        }
        return null;
    }

    @Override
    public final int getInitialSortSequence() {
        return this.initialSortSequence;
    }

    @Override
    public abstract @Nullable String getToolTip(ICallPath var1);

    @Override
    public final String getToolTip(ReportRow<ICallPath> row) {
        return this.getToolTip(row.getModelObject());
    }

    @Override
    public final @Nullable String getToolTip(Void data) {
        return this.getToolTip((ICallPath)null);
    }

    @Override
    public final boolean isInitialSortAscending() {
        return this.initialSortAscending;
    }

    @Override
    public boolean isPrimary() {
        return false;
    }

    protected final int getAlignment() {
        return this.alignment;
    }

    protected final @NonNull IColumnCompareType<EnumColumn<ICallPath>> getCompareType() {
        return this.compareType;
    }
}

