/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.application.PluginMessages;
import com.arm.streamline.editortabs.AnalysisEditor;
import com.arm.streamline.editortabs.EditorTabID;
import com.arm.streamline.editortabs.log.LogOutline;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.IAnalysisProvider;
import com.arm.streamline.model.iterable.AnalysisProviderSelectionIterator;
import com.arm.streamline.widget.contextmenu.ContextMenu;
import com.arm.streamline.widget.contextmenu.IContextMenuContributor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.MenuItem;

public class SelectInContributor
implements IContextMenuContributor {
    private static final String SELECT_TIME_INDEX_CMD = "SelectTimeIndex";
    private HashSet<EditorTabID> mExclude = new HashSet();

    private static Analysis getAnalysis(ContextMenu cm) {
        AnalysisProviderSelectionIterator iterable;
        Analysis analysis = null;
        if (cm.getHandlerControl() instanceof IAnalysisProvider) {
            analysis = ((IAnalysisProvider)cm.getHandlerControl()).getAnalysis();
        }
        if (analysis == null && (iterable = new AnalysisProviderSelectionIterator(cm.getSelection())).iterator().hasNext()) {
            analysis = ((IAnalysisProvider)iterable.iterator().next()).getAnalysis();
        }
        return analysis;
    }

    public SelectInContributor(AnalysisEditor editor, EditorTabID ... exclude) {
        EditorTabID part;
        EditorTabID[] editorTabIDArray = exclude;
        int n = exclude.length;
        int n2 = 0;
        while (n2 < n) {
            part = editorTabIDArray[n2];
            this.mExclude.add(part);
            ++n2;
        }
        editorTabIDArray = EditorTabID.values();
        n = editorTabIDArray.length;
        n2 = 0;
        while (n2 < n) {
            part = editorTabIDArray[n2];
            if (!part.okToAdd(editor)) {
                this.mExclude.add(part);
            }
            ++n2;
        }
    }

    @Override
    public void cleanup(ContextMenu cm) {
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    @Override
    public void handleCommand(ContextMenu cm, MenuItem menuItem, String menuID, String commandID) {
        AnalysisEditor editor;
        Analysis analysis = SelectInContributor.getAnalysis(cm);
        if (analysis != null && (editor = AnalysisEditor.locate(analysis)) != null) {
            if (SELECT_TIME_INDEX_CMD.equals(commandID)) {
                editor.select(EditorTabID.TIMELINE, cm.getSelection());
            } else {
                EditorTabID[] editorTabIDArray = EditorTabID.values();
                int n = editorTabIDArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EditorTabID page = editorTabIDArray[n2];
                    if (page.name().equals(commandID)) {
                        ArrayList list = new ArrayList();
                        for (Object one : page.getIterable(cm.getSelection())) {
                            list.add(one);
                        }
                        editor.select(page, (ISelection)new StructuredSelection(list));
                        break;
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public void prepareMenu(ContextMenu cm) {
        if (SelectInContributor.getAnalysis(cm) != null) {
            ArrayList<EditorTabID> pages = new ArrayList<EditorTabID>();
            ISelection selection = cm.getSelection();
            EditorTabID[] editorTabIDArray = EditorTabID.values();
            int n = editorTabIDArray.length;
            int n2 = 0;
            while (n2 < n) {
                EditorTabID page = editorTabIDArray[n2];
                if (!this.mExclude.contains((Object)page) && page.getIterable(selection).iterator().hasNext()) {
                    pages.add(page);
                }
                ++n2;
            }
            if (!pages.isEmpty()) {
                cm.createConditionalSeparator();
                if (cm.getClickControl() instanceof LogOutline) {
                    cm.createMenuItem((IContextMenuContributor)this, PluginMessages.SELECT_TIME_INDEX, EditorTabID.TIMELINE.getImage(), SELECT_TIME_INDEX_CMD, true);
                }
                for (EditorTabID page : pages) {
                    cm.createMenuItem((IContextMenuContributor)this, MessageFormat.format(page == EditorTabID.TIMELINE ? PluginMessages.SELECT_PROCESS_THREAD_IN_FORMAT : PluginMessages.SELECT_IN_FORMAT, new Object[]{page}), page.getImage(), page.name(), true);
                }
            }
        }
    }
}

