/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.ICallPathFunction;
import com.arm.streamline.report.model.icounters.IInstructionCounter;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionView;
import com.arm.streamline.report.model.icounters.IInstructionCounterModel;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.utils.StreamUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.databinding.observable.list.ComputedList;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class InstructionCountersViewModel {
    protected final @NonNull IObservableList<@NonNull IInstructionCounterSource> allAvailableSources;
    protected final @NonNull IObservableList<@NonNull IInstructionCounterColumn<ICallPath>> currentCallPathCounters;
    protected final @NonNull IObservableList<@NonNull IInstructionCounterColumn<ICallPathFunction>> currentCallPathFunctionCounters;
    protected final @NonNull IObservableList<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IInstructionCounter.InstructionCounterCodeColumns> currentCodeCounters;
    protected final @NonNull IObservableList<@NonNull IInstructionCounterColumn<IInstructionCounterFunctionView>> currentFunctionCounters;
    protected final @NonNull IObservableValue<@Nullable IInstructionCounterSource> currentSelectedSource;
    protected final @NonNull IObservableValue<@NonNull Boolean> hasMultipleSources;

    public InstructionCountersViewModel(@NonNull IInstructionCounterModel instructionCounterModel) {
        this.allAvailableSources = new WritableList(instructionCounterModel.getInstructionCounterSources(), IInstructionCounterSource.class);
        this.currentSelectedSource = new WritableValue(this.allAvailableSources.isEmpty() ? null : (IInstructionCounterSource)this.allAvailableSources.get(0), IInstructionCounterSource.class);
        this.hasMultipleSources = ComputedValue.create(() -> this.allAvailableSources.size() > 1);
        this.currentCallPathCounters = new ComputedList<IInstructionCounterColumn<ICallPath>>(IInstructionCounterColumn.class){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            protected @NonNull List<@NonNull IInstructionCounterColumn<ICallPath>> calculate() {
                @Nullable IInstructionCounterSource currentSource = (IInstructionCounterSource)InstructionCountersViewModel.this.currentSelectedSource.getValue();
                if (currentSource == null) {
                    return Collections.emptyList();
                }
                @NonNull @NonNull Collection instructionCounters = currentSource.getInstructionCounters();
                @NonNull @NonNull Stream nonNullColumns = StreamUtils.filterOutNull(instructionCounters.stream().map(IInstructionCounter::getCallPathColumn));
                return nonNullColumns.collect(Collectors.toList());
            }
        };
        this.currentCallPathFunctionCounters = new ComputedList<IInstructionCounterColumn<ICallPathFunction>>(IInstructionCounterColumn.class){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            protected @NonNull List<@NonNull IInstructionCounterColumn<ICallPathFunction>> calculate() {
                @Nullable IInstructionCounterSource currentSource = (IInstructionCounterSource)InstructionCountersViewModel.this.currentSelectedSource.getValue();
                if (currentSource == null) {
                    return Collections.emptyList();
                }
                @NonNull @NonNull Collection instructionCounters = currentSource.getInstructionCounters();
                @NonNull @NonNull Stream nonNullColumns = StreamUtils.filterOutNull(instructionCounters.stream().map(IInstructionCounter::getCallPathFunctionColumn));
                return nonNullColumns.collect(Collectors.toList());
            }
        };
        this.currentCodeCounters = new ComputedList<IInstructionCounter.InstructionCounterCodeColumns>(IInstructionCounterColumn.class){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            protected @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull IInstructionCounter.InstructionCounterCodeColumns> calculate() {
                @Nullable IInstructionCounterSource currentSource = (IInstructionCounterSource)InstructionCountersViewModel.this.currentSelectedSource.getValue();
                if (currentSource == null) {
                    return Collections.emptyList();
                }
                @NonNull @NonNull Collection instructionCounters = currentSource.getInstructionCounters();
                @NonNull @NonNull Stream nonNullColumns = StreamUtils.filterOutNull(instructionCounters.stream().map(IInstructionCounter::getCodeColumns));
                return nonNullColumns.collect(Collectors.toList());
            }
        };
        this.currentFunctionCounters = new ComputedList<IInstructionCounterColumn<IInstructionCounterFunctionView>>(IInstructionCounterColumn.class){

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            protected @NonNull List<@NonNull IInstructionCounterColumn<IInstructionCounterFunctionView>> calculate() {
                @Nullable IInstructionCounterSource currentSource = (IInstructionCounterSource)InstructionCountersViewModel.this.currentSelectedSource.getValue();
                if (currentSource == null) {
                    return Collections.emptyList();
                }
                @NonNull @NonNull Collection instructionCounters = currentSource.getInstructionCounters();
                @NonNull @NonNull Stream nonNullColumns = StreamUtils.filterOutNull(instructionCounters.stream().map(IInstructionCounter::getFunctionColumn));
                return nonNullColumns.collect(Collectors.toList());
            }
        };
    }

    public void dispose() {
        this.allAvailableSources.dispose();
        this.currentSelectedSource.dispose();
    }

    public @NonNull IObservableList<@NonNull IInstructionCounterSource> propertyAllAvailableSources() {
        return this.allAvailableSources;
    }

    public @NonNull IObservableList<@NonNull IInstructionCounterColumn<ICallPath>> propertyCurrentCallPathCounters() {
        return this.currentCallPathCounters;
    }

    public @NonNull IObservableList<@NonNull IInstructionCounterColumn<ICallPathFunction>> propertyCurrentCallPathFunctionCounters() {
        return this.currentCallPathFunctionCounters;
    }

    public @NonNull IObservableList<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IInstructionCounter.InstructionCounterCodeColumns> propertyCurrentCodeCounters() {
        return this.currentCodeCounters;
    }

    public @NonNull IObservableList<@NonNull IInstructionCounterColumn<IInstructionCounterFunctionView>> propertyCurrentFunctionCounters() {
        return this.currentFunctionCounters;
    }

    public @NonNull IObservableValue<@Nullable IInstructionCounterSource> propertyCurrentSelectedSource() {
        return this.currentSelectedSource;
    }

    public @NonNull IObservableValue<@NonNull Boolean> propertyHasMultipleSources() {
        return this.hasMultipleSources;
    }
}

