/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.editortabs;

import com.arm.streamline.application.PluginMessages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.editortabs.AnalysisEditor;
import com.arm.streamline.editortabs.LoaderTab;
import com.arm.streamline.editortabs.callpath.CallPathTab;
import com.arm.streamline.editortabs.code.CodeTab;
import com.arm.streamline.editortabs.function.FunctionTab;
import com.arm.streamline.editortabs.log.LogEntryTab;
import com.arm.streamline.editortabs.timeline.TimelineTab;
import com.arm.streamline.editortabs.timeline.common.BaseTimelineContent;
import com.arm.streamline.model.iterable.CallPathSelectionIterator;
import com.arm.streamline.model.iterable.FunctionSelectionIterator;
import com.arm.streamline.report.model.ICallPath;
import com.arm.streamline.report.model.IFunction;
import java.util.ArrayList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public enum EditorTabID {
    TIMELINE{

        @Override
        public Control createControl(AnalysisEditor editor, BaseTimelineContent baseTimelineContent) {
            return new TimelineTab(editor);
        }

        @Override
        public Image getImage() {
            return StreamlinePlugin.getImage("Timeline.gif");
        }

        @Override
        public Iterable<?> getIterable(ISelection selection) {
            return new CallPathSelectionIterator(selection);
        }

        @Override
        public boolean okToShowWhileProcessing() {
            return true;
        }

        public String toString() {
            return PluginMessages.TIMELINE_TITLE;
        }
    }
    ,
    CALL_PATH{

        @Override
        public Control createControl(AnalysisEditor editor, BaseTimelineContent baseTimelineContent) {
            return new CallPathTab(editor, baseTimelineContent);
        }

        @Override
        public Image getImage() {
            return StreamlinePlugin.getImage("CallChain.gif");
        }

        public Iterable<ICallPath> getIterable(ISelection selection) {
            return new CallPathSelectionIterator(selection);
        }

        @Override
        public boolean okToAdd(AnalysisEditor editor) {
            return true;
        }

        public String toString() {
            return PluginMessages.CALL_PATH_TITLE;
        }
    }
    ,
    FUNCTIONS{

        @Override
        public Control createControl(AnalysisEditor editor, BaseTimelineContent baseTimelineContent) {
            return new FunctionTab(editor, baseTimelineContent);
        }

        @Override
        public Image getImage() {
            return StreamlinePlugin.getImage("Functions.png");
        }

        public Iterable<IFunction> getIterable(ISelection selection) {
            return new FunctionSelectionIterator(selection);
        }

        public String toString() {
            return PluginMessages.FUNCTIONS_TITLE;
        }
    }
    ,
    CODE{

        @Override
        public Control createControl(AnalysisEditor editor, BaseTimelineContent baseTimelineContent) {
            return new CodeTab(editor);
        }

        @Override
        public Image getImage() {
            return StreamlinePlugin.getImage("CodeView.gif");
        }

        public Iterable<IFunction> getIterable(ISelection selection) {
            return new FunctionSelectionIterator(selection);
        }

        @Override
        public boolean okToAdd(AnalysisEditor editor) {
            return true;
        }

        public String toString() {
            return PluginMessages.CODE_TITLE;
        }
    }
    ,
    LOG{

        @Override
        public Control createControl(AnalysisEditor editor, BaseTimelineContent baseTimelineContent) {
            return new LogEntryTab(editor);
        }

        @Override
        public Image getImage() {
            return StreamlinePlugin.getImage("Log.gif");
        }

        @Override
        public Iterable<?> getIterable(ISelection selection) {
            return new ArrayList();
        }

        @Override
        public boolean okToAdd(AnalysisEditor editor) {
            return true;
        }

        @Override
        public boolean okToShowWhileProcessing() {
            return true;
        }

        public String toString() {
            return PluginMessages.LOG_TITLE;
        }
    }
    ,
    LOADER{

        @Override
        public Control createControl(AnalysisEditor editor, BaseTimelineContent baseTimelineContent) {
            return new LoaderTab(editor);
        }

        @Override
        public Image getImage() {
            return StreamlinePlugin.getImage("Heartbeat.png");
        }

        @Override
        public Iterable<?> getIterable(ISelection selection) {
            return new ArrayList();
        }

        @Override
        public boolean okToAdd(AnalysisEditor editor) {
            return false;
        }

        @Override
        public boolean okToShowWhileProcessing() {
            return true;
        }

        public String toString() {
            return PluginMessages.LOADER_TITLE;
        }
    };


    public abstract @NonNull Control createControl(@NonNull AnalysisEditor var1, @Nullable BaseTimelineContent var2);

    public abstract Image getImage();

    public abstract Iterable<?> getIterable(ISelection var1);

    public boolean okToAdd(AnalysisEditor editor) {
        return true;
    }

    public boolean okToShowWhileProcessing() {
        return false;
    }
}

