/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser.trace_dump_import.wizard.viewmodel;

import com.arm.coresight.ds5_trace_dump.ITraceSourceStreamWrapper;
import com.arm.databinding.ObservablesHelper;
import com.arm.databinding.wizard.IBindableWizardStep;
import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.databrowser.trace_dump_import.BarmanXmlAndAgentImageConfiguration;
import com.arm.streamline.databrowser.trace_dump_import.TraceDumpImportClassification;
import com.arm.streamline.databrowser.trace_dump_import.wizard.TraceDumpImportWizardVM;
import com.arm.streamline.databrowser.trace_dump_import.wizard.viewmodel.AbstractTraceDumpImportWizardVM;
import com.arm.streamline.databrowser.trace_dump_import.wizard.viewmodel.BarmanXmlAndAgentConfigurationVM;
import com.arm.streamline.databrowser.trace_dump_import.wizard.viewmodel.GenerateDwtBarmanConfigVM;
import com.arm.streamline.dataimport.ImportJobFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SelectClassificationVM
extends AbstractTraceDumpImportWizardVM {
    private final @NonNull BarmanXmlAndAgentConfigurationVM barmanXmlAndAgentConfigurationVM;
    private final @NonNull IObservableValue<@NonNull Boolean> propertyCanMoveNext;
    private final @NonNull IObservableValue< @Nullable ImportJobFactory.ITraceDumpImportConfiguration> propertyResult;
    private final @NonNull IObservableValue<@Nullable TraceDumpImportClassification> propertySelectedClassification = new WritableValue(null, TraceDumpImportClassification.class);

    private static @NonNull ComputedValue<@NonNull Boolean> computedBoolean(final @NonNull BooleanSupplier supplier) {
        return new ComputedValue<Boolean>(Boolean.class){

            protected @NonNull Boolean calculate() {
                return supplier.getAsBoolean();
            }
        };
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public SelectClassificationVM(@NonNull TraceDumpImportWizardVM wizardModel) throws IOException {
        super(wizardModel);
        @NonNull @NonNull @Nullable WritableMap resultMap = new WritableMap();
        this.propertyResult = ObservablesHelper.observeDetailOfMapValueByKey((IObservableMap)resultMap, this.propertySelectedClassification);
        this.barmanXmlAndAgentConfigurationVM = this.createBarmanXmlAndAgentVM();
        @Nullable IObservableValue barmanXmlAndAgentConfigurationResult = ComputedValue.create(() -> {
            @Nullable TraceDumpImportClassification classification = (TraceDumpImportClassification)((Object)((Object)this.propertySelectedClassification.getValue()));
             @Nullable @NonNull @NonNull @Nullable ImportJobFactory.BarmanXmlAndAgentImage config = (ImportJobFactory.BarmanXmlAndAgentImage)this.barmanXmlAndAgentConfigurationVM.getResult().getValue();
            if (config != null && classification != null) {
                return new BarmanXmlAndAgentImageConfiguration(classification, config);
            }
            return null;
        });
        resultMap.put((Object)TraceDumpImportClassification.BARMAN_ITM, (Object)barmanXmlAndAgentConfigurationResult);
        resultMap.put((Object)TraceDumpImportClassification.BARMAN_ITM_AGENTLESS_DWT, (Object)barmanXmlAndAgentConfigurationResult);
        resultMap.put((Object)TraceDumpImportClassification.BARMAN_STM, (Object)barmanXmlAndAgentConfigurationResult);
        this.propertyCanMoveNext = ComputedValue.create(() -> this.propertySelectedClassification.getValue() != null ? Boolean.TRUE : Boolean.FALSE);
        if (wizardModel.classifications.size() == 1) {
            this.propertySelectedClassification.setValue((Object)wizardModel.classifications.keySet().iterator().next());
        }
    }

    public boolean barmanConfigIsRequired() {
        @Nullable TraceDumpImportClassification classification = (TraceDumpImportClassification)((Object)this.propertySelectedClassification.getValue());
        if (classification == null) {
            return false;
        }
        switch (classification) {
            case BARMAN_ITM_AGENTLESS_DWT: {
                return true;
            }
        }
        return false;
    }

    public boolean barmanXmlIsRequired() {
        @Nullable TraceDumpImportClassification classification = (TraceDumpImportClassification)((Object)this.propertySelectedClassification.getValue());
        if (classification == null) {
            return false;
        }
        switch (classification) {
            case BARMAN_ITM: 
            case BARMAN_STM: {
                return true;
            }
        }
        return false;
    }

    public @NonNull IObservableValue<@NonNull Boolean> canMoveToNextStep() {
        return this.propertyCanMoveNext;
    }

    public @Nullable IBindableWizardStep getNextStep() {
        @Nullable TraceDumpImportClassification classification = (TraceDumpImportClassification)((Object)this.propertySelectedClassification.getValue());
        if (classification == null) {
            return null;
        }
        switch (classification) {
            case BARMAN_ITM: 
            case BARMAN_ITM_AGENTLESS_DWT: 
            case BARMAN_STM: {
                return this.barmanXmlAndAgentConfigurationVM;
            }
        }
        throw new AssertionError((Object)classification);
    }

    public @NonNull IObservableValue< @Nullable ImportJobFactory.ITraceDumpImportConfiguration> getResult() {
        return this.propertyResult;
    }

    public @NonNull IObservableValue<@Nullable TraceDumpImportClassification> getSelectedClassification() {
        return this.propertySelectedClassification;
    }

    public @NonNull TraceDumpImportClassification @NonNull [] getSelectWhatValues() {
        @NonNull Map<TraceDumpImportClassification, Collection<@NonNull ITraceSourceStreamWrapper>> classifications = this.wizardModel.classifications;
        @NonNull TraceDumpImportClassification @NonNull [] classificationArray = classifications.keySet().toArray(new TraceDumpImportClassification[classifications.size()]);
        Arrays.sort((Object[])classificationArray);
        return classificationArray;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull BarmanXmlAndAgentConfigurationVM createBarmanXmlAndAgentVM() throws IOException {
        @NonNull @NonNull @Nullable WritableMap barmanConfig = new WritableMap();
        EnumMap<@NonNull TraceDumpImportClassification, @NonNull GenerateDwtBarmanConfigVM> barmanConfigStep = new EnumMap<TraceDumpImportClassification, GenerateDwtBarmanConfigVM>(TraceDumpImportClassification.class);
        @NonNull BarmanXmlAndAgentConfigurationVM barmanXmlAndAgentConfigurationVM = new BarmanXmlAndAgentConfigurationVM(this.wizardModel, (IObservableValue<Boolean>)SelectClassificationVM.computedBoolean(this::barmanXmlIsRequired), (IObservableValue<Boolean>)SelectClassificationVM.computedBoolean(this::barmanConfigIsRequired), (IObservableValue<BarmanConfiguration>)ObservablesHelper.observeDetailOfMapValueByKey((IObservableMap)barmanConfig, this.propertySelectedClassification), (IObservableValue<IBindableWizardStep>)ComputedValue.create(() -> (IBindableWizardStep)barmanConfigStep.get(this.propertySelectedClassification.getValue())));
        GenerateDwtBarmanConfigVM generateDwtBarmanConfigVM = new GenerateDwtBarmanConfigVM(this.wizardModel.traceDirectory.getDirectory().getName(), barmanXmlAndAgentConfigurationVM.getBarmanXmlSupplier(), barmanXmlAndAgentConfigurationVM.canFinish());
        barmanConfigStep.put(TraceDumpImportClassification.BARMAN_ITM_AGENTLESS_DWT, generateDwtBarmanConfigVM);
        barmanConfig.put((Object)TraceDumpImportClassification.BARMAN_ITM_AGENTLESS_DWT, generateDwtBarmanConfigVM.getBarmanConfig());
        return barmanXmlAndAgentConfigurationVM;
    }
}

