/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser.trace_dump_import.wizard.viewmodel;

import com.arm.databinding.wizard.BindableWizardStep;
import com.arm.streamline.barman.v1.BarmanHeaderDataV1;
import com.arm.streamline.barmancfg.BarmanGenerator;
import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.configuration.BarmanProcessorConfiguration;
import com.arm.streamline.barmancfg.configuration.DWTConfiguration;
import com.arm.streamline.barmancfg.configuration.DataStorageBackend;
import com.arm.streamline.barmancfg.configuration.DefaultConfigSettings;
import com.arm.streamline.barmancfg.xml.BarmanConfigurationXML;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.streamline.databrowser.trace_dump_import.wizard.TraceDumpImportMessages;
import com.arm.streamline.dwt.DWTUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.numbers.UnsignedLong;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GenerateDwtBarmanConfigVM
extends BindableWizardStep {
    private static final Pattern PATTERN_FREQUENCY = Pattern.compile("^[ \\t]*(\\d+)[ \\t]*(k|M|G)?[ \\t]*(Hz)?[ \\t]*$");
    private final @NonNull IObservableValue<@Nullable BarmanConfiguration> propertyBarmanConfig;
    private final @NonNull IObservableValue<@NonNull String> propertyClockFrequency;
    private final @NonNull IObservableValue<@NonNull String> propertyTargetName;
    private final @NonNull IObservableValue<@NonNull String> propertyCore;
    private final @NonNull IObservableValue<@Nullable Integer> propertyDwtSamplingInterval;
    private final @NonNull String @NonNull [] cores;
    private final @NonNull IObservableValue<@NonNull Boolean> propertyCanFinish;
    private final @NonNull IObservableValue<@NonNull Boolean> propertyCanMoveToNextStep;
    private final @NonNull IObservableValue<@NonNull IStatus> propertyClockFrequencyIsValid;
    private final @NonNull Map<@NonNull Integer, ProcessorPmu> pmusByCpuid = GenerateDwtBarmanConfigVM.getDwtProcessors();
    private final @NonNull Map<@NonNull String, ProcessorPmu> pmusByName = this.pmusByCpuid.values().stream().collect(Collectors.toMap(ProcessorPmu::getCoreName, Function.identity()));

    public static @NonNull Integer @NonNull [] getDwtValues() {
        return (Integer[])IntStream.of(DWTUtils.VALID_PC_SAMPLING_INTERVALS).boxed().toArray(Integer[]::new);
    }

    private static @NonNull Map<@NonNull Integer, ProcessorPmu> getDwtProcessors() throws IOException {
        HashSet<ProcessorPmu.ArchitectureProfile> profiles = new HashSet<ProcessorPmu.ArchitectureProfile>();
        Collections.addAll(profiles, ProcessorPmu.ArchitectureProfile.M7_CLASS, ProcessorPmu.ArchitectureProfile.M8_CLASS);
        return BarmanGenerator.getProcessorPmuConfigurations(null, null, profiles);
    }

    public GenerateDwtBarmanConfigVM(@NonNull String defaultDescription, @NonNull IObservableValue<@NonNull Supplier<@Nullable InputStream>> barmanXmlSupplier, @NonNull IObservableValue<@NonNull Boolean> canFinish) throws IOException {
        this.cores = this.pmusByName.keySet().toArray(new String[0]);
        @NonNull DefaultConfigSettings configSettings = new DefaultConfigSettings();
        this.propertyCanMoveToNextStep = new WritableValue((Object)Boolean.FALSE, Boolean.class);
        this.propertyClockFrequency = new WritableValue((Object)"", String.class);
        this.propertyDwtSamplingInterval = new WritableValue(null, Integer.class);
        this.propertyTargetName = new WritableValue((Object)defaultDescription, String.class);
        this.propertyCore = new WritableValue((Object)"", String.class);
        this.propertyClockFrequencyIsValid = ComputedValue.create(() -> {
            if (this.parseClockFrequency() > 0L) {
                return Status.OK_STATUS;
            }
            return new Status(4, "com.arm.streamline", TraceDumpImportMessages.GenerateITMBarmanConfigPage_invalidClockFrequency);
        });
        this.propertyBarmanConfig = ComputedValue.create(() -> {
            @Nullable ProcessorPmu pmu = this.pmusByName.get(this.propertyCore.getValue());
            long clockFrequency = this.parseClockFrequency();
            @Nullable Integer dwtSamplingInterval = (Integer)this.propertyDwtSamplingInterval.getValue();
            if (pmu == null || clockFrequency <= 0L || dwtSamplingInterval == null) {
                return null;
            }
            DWTConfiguration dwtConfiguration = new DWTConfiguration(dwtSamplingInterval);
            BarmanProcessorConfiguration processorConfig = new BarmanProcessorConfiguration(pmu, null, Collections.emptySet());
            List<@NonNull BarmanProcessorConfiguration> processors = Collections.singletonList(processorConfig);
            String targetName = (String)this.propertyTargetName.getValue();
            BarmanHeaderDataV1.ClockInfo clockInfo = new BarmanHeaderDataV1.ClockInfo(0L, 1000000000L, clockFrequency, 0L);
            return new BarmanConfiguration(null, null, DataStorageBackend.ITM_INTERFACE, configSettings, processors, null, null, null, dwtConfiguration, null, targetName, clockInfo);
        });
        this.propertyCanFinish = canFinish;
        barmanXmlSupplier.addValueChangeListener(e -> this.handleBarmanXmlChanged((InputStream)((Supplier)e.getObservableValue().getValue()).get()));
    }

    public @NonNull IObservableValue<@NonNull Boolean> canFinish() {
        return this.propertyCanFinish;
    }

    public @NonNull IObservableValue<@NonNull Boolean> canMoveToNextStep() {
        return this.propertyCanMoveToNextStep;
    }

    public @NonNull String @NonNull [] getCores() {
        return this.cores;
    }

    public @NonNull IObservableValue<String> getPropertyClockFrequency() {
        return this.propertyClockFrequency;
    }

    public @NonNull IObservableValue<String> getPropertyCore() {
        return this.propertyCore;
    }

    public IObservableValue<@Nullable Integer> getPropertyDwtSamplingInterval() {
        return this.propertyDwtSamplingInterval;
    }

    public @NonNull IObservableValue<String> getPropertyTargetName() {
        return this.propertyTargetName;
    }

    public @NonNull IObservableValue<@NonNull IStatus> getPropertyClockFrequencyStatus() {
        return this.propertyClockFrequencyIsValid;
    }

    private long parseClockFrequency() {
        long multiplier;
        Matcher matcher = PATTERN_FREQUENCY.matcher((CharSequence)this.propertyClockFrequency.getValue());
        if (!matcher.matches()) {
            return -1L;
        }
        @NonNull String numberString = (String)NullChecking.neverNull((Object)matcher.group(1));
        @Nullable String suffixString = matcher.group(2);
        if (suffixString == null || suffixString.equalsIgnoreCase("Hz")) {
            multiplier = 1L;
        } else if (suffixString.equals("k")) {
            multiplier = 1000L;
        } else if (suffixString.equals("M")) {
            multiplier = 1000000L;
        } else if (suffixString.equals("G")) {
            multiplier = 1000000000L;
        } else {
            return -1L;
        }
        try {
            return UnsignedLong.valueOf((String)numberString).multiply(multiplier).longValue();
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public @NonNull IObservableValue<@Nullable BarmanConfiguration> getBarmanConfig() {
        return this.propertyBarmanConfig;
    }

    private void handleBarmanXmlChanged(@Nullable InputStream xmlStream) {
        BarmanConfiguration config;
        if (xmlStream == null) {
            return;
        }
        try {
            config = BarmanConfigurationXML.parse(xmlStream, this.pmusByCpuid, null);
        }
        catch (IOException e) {
            return;
        }
        NullChecking.consumeIfNonNull((Object)config.getTargetName(), arg_0 -> this.propertyTargetName.setValue(arg_0));
        NullChecking.consumeIfNonNull((Object)config.getClockInfo(), c -> this.propertyClockFrequency.setValue((Object)String.valueOf(c.getFrequencyHz())));
        NullChecking.consumeIfNonNull((Object)config.getDWTConfiguration(), d -> this.propertyDwtSamplingInterval.setValue((Object)d.getPCSamplingPeriod()));
        Optional.ofNullable(config.getProcessors()).filter(p -> p.size() == 1).map(p -> ((BarmanProcessorConfiguration)p.get(0)).getProcessorPmu().getCoreName()).filter(this.pmusByName.keySet()::contains).ifPresent(arg_0 -> this.propertyCore.setValue(arg_0));
        try {
            xmlStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

