/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser.trace_dump_import;

import com.arm.streamline.common.utility.ClusterNameUtils;
import com.arm.streamline.common.xml.pmus.EventsAndPmusXml;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.utils.NullChecking;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TraceStreamCoreTypeClassifier {
    private static final Pattern PATTERN_V8 = Pattern.compile("^(?:.*cortex?-)([arm])(\\d+)(?:_.*)?$");

    public static boolean isCoreNameLikelyMClass(@Nullable String coreName) {
        if (coreName == null) {
            return false;
        }
        return (coreName = coreName.toLowerCase()).contains("cortex-m") || coreName.matches("^m\\d+(_\\d+)?$");
    }

    public static boolean isCoreNameLikelyV8(@Nullable String coreNameRaw) {
        if (coreNameRaw == null) {
            return false;
        }
        @NonNull String coreName = coreNameRaw.toLowerCase();
        @NonNull Optional<ProcessorPmu> optionalPmuMatchingCoreName = EventsAndPmusXml.BUILT_PMU.stream().filter(pmu -> pmu.getCoreName().equalsIgnoreCase(coreName) || pmu.getId().equalsIgnoreCase(coreName)).findFirst();
        @Nullable ProcessorPmu pmuMatchingCoreName = optionalPmuMatchingCoreName.orElse(null);
        if (pmuMatchingCoreName != null) {
            return pmuMatchingCoreName.getProfile().isV8();
        }
        Matcher matcher = PATTERN_V8.matcher(coreName);
        if (!matcher.matches()) {
            return false;
        }
        try {
            String arm = (String)NullChecking.neverNull((Object)matcher.group(1));
            int num = Integer.parseInt(matcher.group(2));
            switch (arm) {
                case "a": {
                    return num > 20;
                }
                case "r": {
                    return num > 20;
                }
                case "m": {
                    return num > 20;
                }
            }
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static @Nullable Core parseStreamCoreName(@Nullable String coreName) {
        if (coreName == null) {
            return null;
        }
        int lastUnderscoreIndex = coreName.lastIndexOf(95);
        if (lastUnderscoreIndex >= 0) {
            String typePart = coreName.substring(0, lastUnderscoreIndex);
            String numberPart = coreName.substring(lastUnderscoreIndex + 1);
            if (!numberPart.isEmpty()) {
                try {
                    int number = Integer.parseInt(numberPart);
                    return TraceStreamCoreTypeClassifier.parseStreamCoreName(typePart, number);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return TraceStreamCoreTypeClassifier.parseStreamCoreName(typePart, Integer.MIN_VALUE);
        }
        return TraceStreamCoreTypeClassifier.parseStreamCoreName(coreName, Integer.MIN_VALUE);
    }

    private static @Nullable Core parseStreamCoreName(@NonNull String typePart, int number) {
        String prettyName = ClusterNameUtils.getPrettyName((String)typePart, (boolean)false);
        if (prettyName == null) {
            prettyName = ClusterNameUtils.getPrettyName((String)typePart, (boolean)true);
        }
        if (prettyName == null && typePart.matches("^[AaMmRr]-\\d+(_.*)?$")) {
            prettyName = ClusterNameUtils.getPrettyName((String)("Cortex-" + typePart), (boolean)false);
        }
        if (prettyName == null) {
            return null;
        }
        return new Core(prettyName, number, TraceStreamCoreTypeClassifier.isCoreNameLikelyMClass(prettyName) || TraceStreamCoreTypeClassifier.isCoreNameLikelyMClass(typePart), TraceStreamCoreTypeClassifier.isCoreNameLikelyV8(prettyName) || TraceStreamCoreTypeClassifier.isCoreNameLikelyV8(typePart));
    }

    public static class Core {
        public static final int NUMBER_UNKNOWN = Integer.MIN_VALUE;
        public final boolean mProfile;
        public final int number;
        public final @NonNull String type;
        public final boolean v8;

        public Core(@NonNull String type, int number, boolean mProfile, boolean v8) {
            this.type = type;
            this.number = number;
            this.mProfile = mProfile;
            this.v8 = v8;
        }
    }
}

