/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser.browser;

import com.arm.streamline.databrowser.browser.BrowseResult;
import com.arm.streamline.databrowser.browser.ConnectionType;
import com.arm.streamline.databrowser.browser.ITargetBrowser;
import com.arm.streamline.databrowser.browser.ITargetBrowserClient;
import com.arm.streamline.databrowser.browser.UdpTargetBrowserService;
import com.arm.utils.ArrayUtils;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class StdTargetBrowser
implements ITargetBrowser {
    private final @NonNull ITargetBrowserClient client;
    private final @NonNull AtomicReference<ITargetBrowserClient> realClient = new AtomicReference();

    public StdTargetBrowser(final @NonNull ConnectionType @Nullable [] allowedTypes) {
        this.client = new ITargetBrowserClient(){

            @Override
            public void debugHardwareSearchFailed(@NonNull String reason) {
                ITargetBrowserClient realClient = StdTargetBrowser.this.realClient.get();
                if (realClient != null) {
                    realClient.debugHardwareSearchFailed(reason);
                }
            }

            @Override
            public void foundNewDebugHardware(@NonNull BrowseResult newHardware) {
                ITargetBrowserClient realClient = StdTargetBrowser.this.realClient.get();
                if (realClient != null) {
                    boolean allowed;
                    boolean bl = allowed = allowedTypes == null || ArrayUtils.indexOf((Object[])allowedTypes, (Object)((Object)newHardware.getCType())) >= 0;
                    if (allowed) {
                        realClient.foundNewDebugHardware(newHardware);
                    }
                }
            }

            @Override
            public void removeDebugHardware(@NonNull BrowseResult removeHardware) {
                ITargetBrowserClient realClient = StdTargetBrowser.this.realClient.get();
                if (realClient != null) {
                    boolean allowed;
                    boolean bl = allowed = allowedTypes == null || ArrayUtils.indexOf((Object[])allowedTypes, (Object)((Object)removeHardware.getCType())) >= 0;
                    if (allowed) {
                        realClient.removeDebugHardware(removeHardware);
                    }
                }
            }

            @Override
            public void beginBrowse(@NonNull ConnectionType connectionType) {
                ITargetBrowserClient realClient = StdTargetBrowser.this.realClient.get();
                if (realClient != null) {
                    boolean allowed;
                    boolean bl = allowed = allowedTypes == null || ArrayUtils.indexOf((Object[])allowedTypes, (Object)((Object)connectionType)) >= 0;
                    if (allowed) {
                        realClient.beginBrowse(connectionType);
                    }
                }
            }

            @Override
            public void endBrowse(@NonNull ConnectionType connectionType) {
                ITargetBrowserClient realClient = StdTargetBrowser.this.realClient.get();
                if (realClient != null) {
                    boolean allowed;
                    boolean bl = allowed = allowedTypes == null || ArrayUtils.indexOf((Object[])allowedTypes, (Object)((Object)connectionType)) >= 0;
                    if (allowed) {
                        realClient.endBrowse(connectionType);
                    }
                }
            }
        };
    }

    @Override
    public void addClient(@Nullable ITargetBrowserClient client) {
        this.realClient.set(client);
    }

    @Override
    public void closeBrowser() {
        this.stopBrowsing();
    }

    @Override
    public void startBrowsing(int pingTimeoutInSeconds, boolean pingContinuously) {
        UdpTargetBrowserService.get().addClient(this.client);
    }

    @Override
    public void stopBrowsing() {
        UdpTargetBrowserService.get().removeClient(this.client);
    }
}

