/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.deviceconn.adb.AdbDeviceRootMode;
import com.arm.streamline.deviceconn.adb.AdbSelfCleaningSession;
import com.arm.streamline.deviceconn.adb.IAdbCommandRunner;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.utility.AdbRunnerFactory;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class NotifyExecutableManager {
    private final @Nullable IAdbCommandRunner commandRunner;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAdbCommandRunner.WrapMode wrapMode = IAdbCommandRunner.WrapMode.DEFAULT;
    private @Nullable AdbSelfCleaningSession session;
    private static final @NonNull File INSTALL_DIR = CommonPlugin.getInstallDir();
    private static final @NonNull String ANDROID_BIN_DIR = "bin/android";
    private static final @NonNull String ARM64_DIR = "arm64";
    private static final @NonNull String NOTIFY_DEX_FILE = "notify.dex";
    private static final @NonNull String NOTIFY_ENV_VAR = "STREAMLINE_NOTIFY_DEX";
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable AdbSelfCleaningSession.RemoteExecutable remoteNotifyDexPath = null;

    private static @Nullable File getNotifyExecutablePath() {
        @NonNull File file = Paths.get(INSTALL_DIR.getAbsolutePath(), ANDROID_BIN_DIR, ARM64_DIR, NOTIFY_DEX_FILE).toFile();
        String envPath = System.getenv(NOTIFY_ENV_VAR);
        if (envPath != null) {
            file = new File(envPath);
        }
        return file.exists() ? file : null;
    }

    public NotifyExecutableManager(@NonNull IAdbCommandRunner commandRunner, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAdbCommandRunner.WrapMode wrapMode) {
        this.commandRunner = commandRunner;
        this.wrapMode = wrapMode;
        this.session = new AdbSelfCleaningSession(commandRunner, wrapMode, StreamlinePlugin::warning);
    }

    public NotifyExecutableManager(@NonNull IAdbProcessRunner adbProcessRunner, @NonNull TargetAddressString targetAddressString) throws IOException {
        if (targetAddressString.isAndroid()) {
            this.commandRunner = AdbRunnerFactory.SINGLETON.create(adbProcessRunner, targetAddressString.getAndroidSerialNumber());
            this.wrapMode = IAdbCommandRunner.rootWrapModeOrDefault((AdbDeviceRootMode)this.commandRunner.detectRootMode());
            this.session = new AdbSelfCleaningSession((IAdbCommandRunner)NullChecking.neverNull((Object)this.commandRunner), this.wrapMode, StreamlinePlugin::warning);
        } else {
            this.commandRunner = null;
        }
    }

    public void pushNotifyExecutableToTarget() throws IOException, AdbSelfCleaningSession.CommandFailedException {
        File notifyFile = NotifyExecutableManager.getNotifyExecutablePath();
        if (notifyFile != null && this.session != null) {
            this.remoteNotifyDexPath = this.session.pushExecutable(notifyFile);
        } else {
            StreamlinePlugin.warning(String.format("Failed to find suitable %s file. Use %s environment variable to set its path.", NOTIFY_DEX_FILE, NOTIFY_ENV_VAR));
        }
    }

    public void uninstall() {
        if (this.remoteNotifyDexPath != null && this.commandRunner != null) {
            try {
                this.commandRunner.runCommandAndGetOutput(this.wrapMode, "rm", new String[]{"-f", this.remoteNotifyDexPath.getPath()});
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

