/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.databrowser.ElfImage;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.model.session.SessionImage;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;

public interface IElfImageStore {
    public @NonNull Set<@NonNull ElfImage> getAvailableImages();

    public @NonNull ElfImage importImage(@NonNull File var1) throws IOException, InterruptedException;

    public void appendSeparateDebugFile(@NonNull ElfImage var1, @NonNull File var2) throws IOException, InterruptedException, CodecException;

    public void removeImage(@NonNull ElfImage var1);

    default public @NonNull Map<@NonNull String, @NonNull File> createImageFileMapping(IAnalysisInputSettings analysisSettings) {
        @NonNull Set<@NonNull String> enabledImageNames = analysisSettings.getImages().stream().filter(SessionImage::loadSymbols).map(SessionImage::getImageName).collect(Collectors.toSet());
        return this.createImageFileMapping(enabledImageNames);
    }

    default public @NonNull Map<@NonNull String, @NonNull File> createImageFileMapping(@NonNull Set<@NonNull String> enabledImageNames) {
        TreeMap<@NonNull String, @NonNull File> imageLoadSymbolsPaths = new TreeMap<String, File>();
        for (ElfImage elfImage : this.getAvailableImages()) {
            String name = elfImage.getName();
            if (!enabledImageNames.contains(name)) continue;
            if (imageLoadSymbolsPaths.containsKey(name)) {
                throw new AssertionError((Object)String.format(AnalysisMessages.MULTIPLE_MATCHING_NAMES, name));
            }
            imageLoadSymbolsPaths.put(name, (File)NullChecking.neverNull((Object)elfImage.getFile()));
        }
        return imageLoadSymbolsPaths;
    }
}

