/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.analysis.gator.ProtocolInfo;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.barman.BarmanCapture;
import com.arm.streamline.capture.apc.APCCapture;
import com.arm.streamline.capture.astf.ASTFCapture;
import com.arm.streamline.common.IErrorHandler;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.databrowser.IElfImageStore;
import com.arm.streamline.databrowser.IOpenable;
import com.arm.streamline.databrowser.IProgressMonitor;
import com.arm.streamline.databrowser.IProgressObserver;
import com.arm.streamline.databrowser.IStopHandler;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.model.session.SampleRate;
import java.io.File;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public interface ICapture
extends Comparable<ICapture>,
IOpenable,
IElfImageStore {
    public static @NonNull ICapture createCapture(@NonNull File file) {
        ICapture result = BarmanCapture.tryCreateFor(file);
        if (result != null) {
            return result;
        }
        Optional<ASTFCapture> astfResult = ASTFCapture.tryCreateFor(file);
        if (astfResult.isPresent()) {
            return astfResult.get();
        }
        return new APCCapture(file);
    }

    public void analyze(@NonNull IAnalysisInputSettings var1, @NonNull SessionProcessor var2, @Nullable IOpenable var3, @NonNull IProgressObserver var4, @NonNull IErrorHandler var5, boolean var6);

    public void cleanDbAndReport();

    public @NonNull IAnalysisInputSettings getAnalysisSettings();

    public @NonNull String getAnalysisPath();

    public @NonNull File getApcDirectory();

    public long getCreatedOnSeconds();

    public long getDurationInTimeUnits();

    public @Nullable TimeUnit getTimeUnit();

    public @NonNull String getHumanReadableVersion();

    public @Nullable String getInvalidReason();

    public @Nullable ProtocolInfo getProtocolInfo();

    default public @NonNull String getPrettyName() {
        return FilePath.getLeafName((String)this.getApcDirectory().getName(), (boolean)false);
    }

    public double getProgress();

    public @Nullable IProgressMonitor getProgressMonitor();

    public @Nullable ResolutionMode getResolutionMode();

    public @NonNull SampleRate getSampleRate();

    public @NonNull String getTargetDescription();

    public boolean hasBeenStopped();

    public boolean hasDb();

    public boolean hasReport(boolean var1);

    public boolean isDataMissing();

    public boolean isInProgress();

    public boolean isJitDumpProfilingSupported();

    public boolean isShouldAlwaysDeleteDB();

    public boolean isStoppable();

    public boolean isValid();

    public void setFile(@NonNull File var1);

    public void setHasBeenStopped(boolean var1);

    public void setProgress(double var1);

    public void setProgressMonitor(IProgressMonitor var1);

    public void setStopHandler(@Nullable IStopHandler var1, @NonNull IProgressObserver var2);

    public void stop(boolean var1);

    public boolean usesEBS();
}

