/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.analysis.gator.GatorCapturedRawXML;
import com.arm.streamline.analysis.gator.GatorProtocolVerifier;
import com.arm.streamline.analysis.gator.GatorProtocolVersionConstants;
import com.arm.streamline.analysis.gator.ProtocolInfo;
import com.arm.streamline.common.model.ProtocolType;
import com.arm.streamline.common.utility.io.BufferUtils;
import com.arm.streamline.common.utility.io.LittleEndianDataInputStream;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.GatorSendCommandUtility;
import com.arm.streamline.databrowser.ITarget;
import com.arm.streamline.log.IAPCGatorLogCapturer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GatorTarget
implements ITarget {
    private static final int TIMEOUT;
    private static final String TAG_REQUEST = "request";
    private static final String ATTR_TYPE = "type";
    public static final String VALUE_EVENTS = "events";
    public static final String VALUE_CONFIGURATION = "configuration";
    public static final String VALUE_COUNTERS = "counters";
    public static final String VALUE_CAPTURED = "captured";
    public static final String VALUE_DEFAULTS = "defaults";
    private static final @NonNull Runnable EMPTY_RUNNABLE;
    private Thread mTimedThread;
    private boolean mUseReadTimeout;
    private final Socket mSocket;
    private OutputStream mOut;
    protected LittleEndianDataInputStream mIn;
    private int mProtocolVersionNumber = 0;
    private @Nullable IAPCGatorLogCapturer logCapturer;
    private @NonNull Runnable mActivityStartedCallback = EMPTY_RUNNABLE;

    static {
        @Nullable String env = System.getenv("STREAMLINE_GATOR_TIMEOUT");
        int timeout = -1;
        if (env != null) {
            try {
                timeout = Integer.parseInt(env);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (timeout < 0) {
            timeout = 5000;
        }
        TIMEOUT = timeout;
        EMPTY_RUNNABLE = () -> {};
    }

    public void addLogDataCapturer(@NonNull IAPCGatorLogCapturer logCapturer) {
        this.logCapturer = logCapturer;
    }

    public GatorTarget(Socket socket, boolean useReadTimeout) throws IOException {
        this.mSocket = socket;
        this.setup(socket, useReadTimeout);
        this.magicExchange();
        try {
            @NonNull ProtocolInfo info = new ProtocolInfo(ProtocolType.PERF, this.getProtocolVersionNumber());
            GatorProtocolVerifier.verifyProtocol(info, GatorProtocolVerifier.LIVE_EXCEPTION_FACTORY);
        }
        catch (Exception e) {
            try {
                this.disconnect();
            }
            catch (Exception disconnectException) {
                e.addSuppressed(disconnectException);
            }
            throw e;
        }
    }

    @Override
    public void disconnect() throws IOException {
        if (this.mTimedThread != null) {
            this.mTimedThread.interrupt();
        }
        byte[] message = new byte[5];
        message[0] = 4;
        this.mOut.write(message);
        if (this.logCapturer != null) {
            this.logCapturer.closeOnDisconnect();
            this.logCapturer = null;
        }
    }

    @Override
    public byte @NonNull [] getCountersXML() throws IOException {
        return this.requestXML(VALUE_COUNTERS);
    }

    @Override
    public byte[] getCurrentConfiguration() throws IOException {
        byte[] header = new byte[5];
        header[0] = 7;
        this.mOut.write(header);
        GatorSendCommandUtility.ResponseStruct rs = GatorSendCommandUtility.readResponse(this.mIn);
        if (rs.control != 6) {
            throw new IOException(MessageFormat.format(DocumentsMessages.ERROR_INVALID_CONTROL_CODE, rs.control, "gator"));
        }
        return rs.data;
    }

    @Override
    public byte @NonNull [] getEventsXML() throws IOException {
        return this.requestXML(VALUE_EVENTS);
    }

    public byte @NonNull [] getConfigurationXml() throws IOException {
        return this.requestXML(VALUE_CONFIGURATION);
    }

    public byte @NonNull [] getDefaultsXml() throws IOException {
        return this.requestXML(VALUE_DEFAULTS);
    }

    @Override
    public GatorCapturedRawXML getGatorCapturedRawXML() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XMLParser in = new XMLParser((InputStream)new ByteArrayInputStream(this.requestXML(VALUE_CAPTURED)));){
            return GatorCapturedRawXML.read(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public int getProtocolVersionNumber() {
        return this.mProtocolVersionNumber;
    }

    public byte @Nullable [] nextFrame() throws IOException {
        GatorSendCommandUtility.ResponseStruct rs;
        boolean pingRequested = false;
        block8: while (true) {
            try {
                rs = GatorSendCommandUtility.readResponse(this.mIn);
                pingRequested = false;
            }
            catch (SocketTimeoutException e) {
                if (pingRequested) {
                    throw e;
                }
                this.ping();
                pingRequested = true;
                continue;
            }
            switch (rs.control) {
                case 3: {
                    if (rs.data.length > 0) {
                        return rs.data;
                    }
                    return null;
                }
                case 4: {
                    pingRequested = false;
                    continue block8;
                }
                case 7: {
                    if (this.logCapturer == null) continue block8;
                    this.logCapturer.consumeGatorLogMessage(rs.data);
                    continue block8;
                }
                case 8: {
                    this.mActivityStartedCallback.run();
                    continue block8;
                }
            }
            break;
        }
        throw new IOException(MessageFormat.format(DocumentsMessages.ERROR_INVALID_CONTROL_CODE, rs.control, "gator"));
    }

    public void pingCheck() throws IOException {
        int oldTimeout = this.mSocket.getSoTimeout();
        this.mSocket.setSoTimeout(TIMEOUT);
        this.ping();
        boolean done = false;
        try {
            GatorSendCommandUtility.ResponseStruct rs = GatorSendCommandUtility.readResponse(this.mIn);
            if (rs.control != 4) {
                throw new IOException(MessageFormat.format(DocumentsMessages.ERROR_INVALID_CONTROL_CODE, rs.control, "gator"));
            }
            done = true;
        }
        finally {
            block9: {
                try {
                    this.mSocket.setSoTimeout(oldTimeout);
                }
                catch (SocketException e) {
                    if (!done) break block9;
                    throw e;
                }
            }
        }
    }

    public byte @NonNull [] requestXML(String attributeValue) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var4_5 = null;
        try (XMLGenerator xml = new XMLGenerator((OutputStream)buffer);){
            xml.startDocument();
            xml.startEmptyTag(TAG_REQUEST);
            xml.addAttribute(ATTR_TYPE, attributeValue);
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        byte[] header = new byte[5];
        header[0] = 0;
        BufferUtils.writeLEInt((byte[])header, (int)1, (int)buffer.size());
        this.mOut.write(header);
        buffer.writeTo(this.mOut);
        GatorSendCommandUtility.ResponseStruct rs = GatorSendCommandUtility.readResponse(this.mIn);
        if (rs.control != 1) {
            throw new IOException(MessageFormat.format(DocumentsMessages.ERROR_INVALID_CONTROL_CODE, rs.control, "gator"));
        }
        return rs.data;
    }

    public boolean sendXML(byte[] data) throws IOException {
        return this.sendData((byte)1, data);
    }

    @Override
    public void start() throws IOException {
        byte[] message = new byte[5];
        message[0] = 2;
        this.mOut.write(message);
    }

    @Override
    public void stop() throws IOException {
        byte[] message = new byte[5];
        message[0] = 3;
        this.mOut.write(message);
        if (!this.mUseReadTimeout) {
            this.timedStop();
        }
    }

    private void checkMagic(String expected, String magicIn) throws IOException {
        String string = magicIn.trim().toLowerCase();
        if (!string.startsWith(expected)) {
            throw new IOException(MessageFormat.format(DocumentsMessages.ERROR_MAGIC_SEQUENCE, magicIn, expected));
        }
        if (string.length() > expected.length()) {
            this.mProtocolVersionNumber = Integer.parseInt(string.substring(expected.length()).trim());
        }
    }

    private void magicExchange() throws IOException {
        this.mOut.write(MessageFormat.format("VERSION {0}\n", Integer.toString(GatorProtocolVersionConstants.CURRENT_RELEASED_VERSION.getVersionNumber())).getBytes());
        this.mOut.write("STREAMLINE\n".getBytes());
        String magicIn = GatorSendCommandUtility.readLine(this.mIn);
        if (magicIn == null) {
            throw new IOException(DocumentsMessages.ERROR_COMMUNICATION_GATOR);
        }
        this.checkMagic("gator", magicIn);
    }

    private void ping() throws IOException {
        byte[] message = new byte[5];
        message[0] = 5;
        this.mOut.write(message);
    }

    private boolean sendData(byte type, byte[] data) throws IOException {
        GatorSendCommandUtility.ResponseStruct rs;
        byte[] header = new byte[5];
        header[0] = type;
        BufferUtils.writeLEInt((byte[])header, (int)1, (int)data.length);
        this.mOut.write(header);
        this.mOut.write(data);
        while (true) {
            rs = GatorSendCommandUtility.readResponse(this.mIn);
            if (rs.control == 7) {
                if (this.logCapturer == null) continue;
                this.logCapturer.consumeGatorLogMessage(rs.data);
                continue;
            }
            if (rs.control != 3 || rs.data.length != 0) break;
        }
        if (rs.control == 4) {
            return true;
        }
        if (rs.control == 5) {
            return false;
        }
        throw new IOException(MessageFormat.format(DocumentsMessages.ERROR_INVALID_CONTROL_CODE, rs.control, "gator"));
    }

    private void setup(Socket socket, boolean useReadTimeout) throws IOException {
        this.mOut = socket.getOutputStream();
        this.mIn = new LittleEndianDataInputStream(socket.getInputStream());
        this.mUseReadTimeout = useReadTimeout;
        if (useReadTimeout) {
            socket.setSoTimeout(TIMEOUT);
        }
    }

    private void timedStop() {
        this.mTimedThread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(TIMEOUT);
                    if (GatorTarget.this.mIn != null) {
                        GatorTarget.this.mIn.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.mTimedThread.setName("TimedStop");
        this.mTimedThread.start();
    }

    @Override
    public void sendExitOk() throws IOException {
        byte[] message = new byte[5];
        message[0] = 6;
        this.mOut.write(message);
    }

    public void setOnActivityStartedCallback(@NonNull Runnable callback) {
        this.mActivityStartedCallback = callback;
    }

    public static class SessionInProgressException
    extends IOException {
        public SessionInProgressException(String message) {
            super(message);
        }
    }
}

