/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.application.preferences.IPreferences;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.common.preferences.AndroidDevicePreference;
import com.arm.streamline.common.preferences.CommonPreferences;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.common.utility.PathChoice;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.counterconfig.CountersDialog;
import com.arm.streamline.databrowser.AndroidDeviceGatordManager;
import com.arm.streamline.databrowser.CaptureControlView;
import com.arm.streamline.databrowser.CaptureStateProxy;
import com.arm.streamline.databrowser.ConfigureTargetHandler;
import com.arm.streamline.databrowser.ICaptureProxy;
import com.arm.streamline.databrowser.IConfigurer;
import com.arm.streamline.databrowser.IDeviceConnectionModel;
import com.arm.streamline.databrowser.ILiveCapture;
import com.arm.streamline.databrowser.NotifyExecutableManager;
import com.arm.streamline.databrowser.NullConfigurer;
import com.arm.streamline.databrowser.OptionsDialog;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.databrowser.TargetLauncher;
import com.arm.streamline.deviceconn.adb.AdbDeviceRootMode;
import com.arm.streamline.deviceconn.adb.AdbSelfCleaningSession;
import com.arm.streamline.deviceconn.adb.IAdbCommandRunner;
import com.arm.streamline.live.LiveEditor;
import com.arm.streamline.model.live.CaptureInput;
import com.arm.streamline.model.live.LiveCaptureDataProvider;
import com.arm.streamline.model.session.ExcludeKernel;
import com.arm.streamline.model.session.Session;
import com.arm.streamline.ui.vm.IAndroidPackage;
import com.arm.streamline.ui.vm.IAndroidTargetDevice;
import com.arm.streamline.ui.vm.IAndroidTargetLauncher;
import com.arm.streamline.ui.vm.ITargetLauncher;
import com.arm.streamline.ui.vm.ITcpTargetLauncher;
import com.arm.streamline.utility.AdbRunnerFactory;
import com.arm.streamline.utility.IAdbRunnerFactory;
import com.arm.streamline.widget.Error;
import com.arm.streamline.widget.WidgetUtils;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class DeviceConnectionModel
implements IDeviceConnectionModel,
ICaptureProxy {
    private static final @NonNull Runnable EMPTY_RUNNABLE = () -> {};
    private static final @NonNull DeviceConnectionModel INSTANCE = new DeviceConnectionModel(StreamlinePreferences.getApplicationPreferences(), AdbRunnerFactory.SINGLETON);
    private final @NonNull AtomicReference<@NonNull Runnable> cleanUpTask = new AtomicReference<Runnable>(EMPTY_RUNNABLE);
    private final @NonNull SimpleObjectProperty<@Nullable TargetAddressString> activeCaptureAddress = new SimpleObjectProperty(null);
    private final @NonNull IPreferences appSettings;
    private final @NonNull CaptureStateProxy capStateProxies = new CaptureStateProxy();
    private final @NonNull Session defaultSessionForAdvancedSettings;
    private final @NonNull IAdbRunnerFactory adbRunnerFactory;
    private List<@NonNull String> argHistory;
    private @NonNull Runnable refreshCallback = EMPTY_RUNNABLE;

    public static @NonNull IDeviceConnectionModel get() {
        return INSTANCE;
    }

    public static void save() {
        StreamlinePreferences.setSession(DeviceConnectionModel.INSTANCE.defaultSessionForAdvancedSettings.toString());
    }

    private static @Nullable Shell getShell() {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            return null;
        }
        IWorkbenchWindow aww = wb.getActiveWorkbenchWindow();
        if (aww == null) {
            return null;
        }
        return aww.getShell();
    }

    private DeviceConnectionModel(@NonNull IPreferences appSettings, @NonNull IAdbRunnerFactory adbRunnerFactory) {
        this.appSettings = appSettings;
        this.adbRunnerFactory = adbRunnerFactory;
        this.defaultSessionForAdvancedSettings = DeviceConnectionModel.loadSession();
        this.capStateProxies.addCaptureStateListener(this);
    }

    private static @NonNull Session loadSession() {
        Session session;
        try {
            String value = StreamlinePreferences.getSession();
            session = new Session(value != null ? value : "");
        }
        catch (Exception exception) {
            session = new Session();
        }
        return session;
    }

    @Override
    public @NonNull ObservableBooleanValue hasActiveConnectionProperty() {
        return this.activeCaptureAddress.isNotNull();
    }

    @Override
    public void addCaptureStateProxy(@NonNull ICaptureProxy captureProxy) {
        this.capStateProxies.addCaptureStateListener(captureProxy);
    }

    @Override
    public void captureError(String msg) {
        this.clearActiveCapture();
    }

    @Override
    public void captureError(@NonNull Throwable t) {
        this.clearActiveCapture();
    }

    @Override
    public void captureFinished(boolean isDiscarded) {
        this.clearActiveCapture();
    }

    @Override
    public void captureStarted(@NonNull ILiveCapture doc, @Nullable LiveCaptureDataProvider live, @NonNull IPreferences settings, boolean discard) {
        if (live != null) {
            TargetAddressString targetAddress = live.getCaptureSettings().getTargetAddress();
            this.setActiveCapture(targetAddress);
        }
    }

    @Override
    public void captureStopped(@NonNull ILiveCapture doc, boolean discard) {
    }

    @Override
    public void liveError(String msg) {
    }

    @Override
    public void liveWarning(@NonNull WarningItem msg) {
    }

    @Override
    public void removeCaptureStateProxy(@NonNull ICaptureProxy captureProxy) {
        this.capStateProxies.removeCaptureStateListener(captureProxy);
    }

    @Override
    public void showAdvancedSettings() {
        OptionsDialog dialog;
        if (!WidgetUtils.isModalDialogShowing() && (dialog = new OptionsDialog(DeviceConnectionModel.getShell(), new Session(this.defaultSessionForAdvancedSettings))).open() != 1) {
            dialog.saveChanges();
            this.defaultSessionForAdvancedSettings.copyFrom(dialog.getSession());
        }
    }

    @Override
    public boolean isAdvancedConfigModePreferred() {
        return CommonPreferences.isAdvancedConfigModePreferred();
    }

    @Override
    public void setAdvancedConfigModePreference(boolean useAdvanced) {
        CommonPreferences.setAdvancedConfigModePreference((boolean)useAdvanced);
    }

    @Override
    public void showCounterConfiguration(@NonNull ITargetLauncher activeTarget) {
        if (!WidgetUtils.isModalDialogShowing()) {
            activeTarget.accept(new ITargetLauncher.IVisitor(){

                public void visitAndroidTargetLauncher(@NonNull IAndroidTargetLauncher targetLauncher) {
                    DeviceConnectionModel.this.androidCounterConfiguration(targetLauncher);
                }

                public void visitTcpTargetLauncher(@NonNull ITcpTargetLauncher targetLauncher) {
                    DeviceConnectionModel.this.tcpCounterConfiguration(targetLauncher);
                }
            });
        }
    }

    private void androidCounterConfiguration(@NonNull IAndroidTargetLauncher targetLauncher) {
        try {
            this.prepareAdbCommandThen(targetLauncher, (target, cmdRunner) -> {
                AndroidDeviceGatordManager.IInstallUninstall installUninstall;
                TargetAddressString targetAddress = new TargetAddressString(target.getTargetAddress());
                this.setActiveCapture(targetAddress);
                this.cleanUpTask.set(EMPTY_RUNNABLE);
                IAdbCommandRunner.WrapMode wrapmode = IAdbCommandRunner.rootWrapModeOrDefault((AdbDeviceRootMode)target.getDeviceRootMode());
                NotifyExecutableManager notifyExecutableManager = new NotifyExecutableManager((IAdbCommandRunner)cmdRunner, wrapmode);
                try {
                    installUninstall = DeviceConnectionModel.prepareCopyGatorTask(target.getDebuggablePackage().getPackageName(), null, null, cmdRunner, false, wrapmode, new NullConfigurer());
                    notifyExecutableManager.pushNotifyExecutableToTarget();
                }
                catch (AndroidDeviceGatordManager.AndroidDeviceException | AdbSelfCleaningSession.CommandFailedException | IOException e) {
                    Error.show(e);
                    return;
                }
                this.cleanUpTask.set(() -> {
                    DeviceConnectionModel.cleanUpOnAndroid(installUninstall);
                    notifyExecutableManager.uninstall();
                });
                if (DeviceConnectionModel.installThenStartGator(installUninstall.getInstaller())) {
                    CountersDialog.configureCounters(DeviceConnectionModel.getShell(), targetAddress);
                }
            });
        }
        finally {
            this.clearActiveCapture();
        }
    }

    private void tcpCounterConfiguration(@NonNull ITcpTargetLauncher activeTarget) {
        try {
            TargetAddressString targetAddress = new TargetAddressString(activeTarget.getTargetAddress());
            this.setActiveCapture(targetAddress);
            this.cleanUpTask.set(EMPTY_RUNNABLE);
            CountersDialog.configureCounters(DeviceConnectionModel.getShell(), targetAddress);
        }
        finally {
            this.clearActiveCapture();
        }
    }

    @Override
    public void showStartCapture(@NonNull ITargetLauncher activeTarget) {
        if (!WidgetUtils.isModalDialogShowing()) {
            activeTarget.accept(new ITargetLauncher.IVisitor(){

                public void visitTcpTargetLauncher(@NonNull ITcpTargetLauncher tcpTargetLauncher) {
                    TargetLauncher targetLauncher = DeviceConnectionModel.this.doStartCapture(tcpTargetLauncher);
                    if (targetLauncher == null) {
                        DeviceConnectionModel.this.clearActiveCapture();
                    }
                }

                public void visitAndroidTargetLauncher(@NonNull IAndroidTargetLauncher activeTarget) {
                    AtomicReference<@Nullable Object> wrapper = new AtomicReference<Object>(null);
                    DeviceConnectionModel.this.prepareAdbCommandThen(activeTarget, (target, cmdRunner) -> wrapper.set(DeviceConnectionModel.this.androidCaptureWithAdb((IAndroidTargetLauncher)target, (IAdbCommandRunner)cmdRunner, IAdbCommandRunner.rootWrapModeOrDefault((AdbDeviceRootMode)activeTarget.getDeviceRootMode()))));
                    if (wrapper.get() == null) {
                        DeviceConnectionModel.this.clearActiveCapture();
                    }
                }
            });
        }
    }

    private void prepareAdbCommandThen(@NonNull IAndroidTargetLauncher targetLauncher, @NonNull BiConsumer<@NonNull IAndroidTargetLauncher, @NonNull IAdbCommandRunner> next) {
        IAdbCommandRunner adbCommandRunner;
        File maybeAdb = StreamlinePreferences.getApplicationPreferences().getAdbPathOrDefault();
        if (maybeAdb == null) {
            Error.show("adb path is not configured");
            return;
        }
        try {
            adbCommandRunner = this.adbRunnerFactory.create(this.adbRunnerFactory.create(maybeAdb), targetLauncher.getDeviceSerialNumber());
        }
        catch (IOException ex) {
            Error.show(ex);
            return;
        }
        next.accept(targetLauncher, adbCommandRunner);
    }

    private static @NonNull AndroidDeviceGatordManager.IInstallUninstall prepareCopyGatorTask(@NonNull String packageName, @Nullable String activityName, @Nullable String activityArguments, @NonNull IAdbCommandRunner adbCommandRunner, boolean captureLog, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAdbCommandRunner.WrapMode wrapMode, @NonNull IConfigurer configurer) throws IOException, AndroidDeviceGatordManager.AndroidDeviceException {
        AndroidDeviceGatordManager gatorManager = new AndroidDeviceGatordManager(adbCommandRunner, wrapMode);
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(List.of("--android-pkg", packageName, "-p", "uds"));
        if (activityName != null) {
            args.add("--android-activity");
            args.add(activityName);
        }
        if (activityArguments != null && !activityArguments.isBlank()) {
            args.add("--activity-args");
            args.add(activityArguments);
        }
        if (captureLog) {
            args.add("--capture-log");
        }
        return gatorManager.getGatordInstallUninstall(configurer, (String[])args.toArray(String[]::new));
    }

    private TargetLauncher androidCaptureWithAdb(IAndroidTargetLauncher activeAndroidTarget, @NonNull IAdbCommandRunner adbCommandRunner, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IAdbCommandRunner.WrapMode wrapMode) {
        AndroidDeviceGatordManager.IInstallUninstall installUninstall;
        String path;
        TargetAddressString targetAddress = new TargetAddressString(activeAndroidTarget.getTargetAddress());
        Session session = CommonPreferences.isAdvancedConfigModePreferred() ? new Session(this.defaultSessionForAdvancedSettings) : DeviceConnectionModel.createSessionForBasicMode(targetAddress);
        session.setTargetAddress(targetAddress);
        session.setStopGator(true);
        if (!session.getTargetAddress().isValid()) {
            return null;
        }
        this.setActiveCapture(targetAddress);
        CaptureControlView.makeVisible();
        if (session.isDiscardEnabled()) {
            File parent = new File(CommonPreferences.getLastSavePath());
            path = new File(parent, CommonPreferences.chooseUniqueName((File)parent, (String)(CommonPreferences.getLastCaptureName() + ".apc"))).getAbsolutePath();
        } else {
            path = PathChoice.chooseCaptureSavePath();
        }
        if (path == null) {
            return null;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        NotifyExecutableManager notifyExecutableManager = new NotifyExecutableManager(adbCommandRunner, wrapMode);
        try {
            IAndroidPackage pkg = activeAndroidTarget.getDebuggablePackage();
            @NonNull IConfigurer configurer = !CommonPreferences.isAdvancedConfigModePreferred() ? new ConfigureTargetHandler(targetAddress) : new NullConfigurer();
            String selectedActivityName = pkg.shouldOverrideActivityName() ? pkg.getOverrideActivityName() : pkg.getActivityName();
            installUninstall = DeviceConnectionModel.prepareCopyGatorTask(pkg.getPackageName(), selectedActivityName, pkg.getActivityArguments(), adbCommandRunner, session.isCaptureLogFileEnabled(), wrapMode, configurer);
            notifyExecutableManager.pushNotifyExecutableToTarget();
        }
        catch (AndroidDeviceGatordManager.AndroidDeviceException | AdbSelfCleaningSession.CommandFailedException | IOException e) {
            Error.show(e);
            return null;
        }
        this.cleanUpTask.set(() -> {
            DeviceConnectionModel.cleanUpOnAndroid(installUninstall);
            notifyExecutableManager.uninstall();
        });
        if (DeviceConnectionModel.installThenStartGator(installUninstall.getInstaller())) {
            Runnable onActivityStartedCallback = () -> {
                this.saveApplicationArgumentsHistory();
                this.refreshCallback.run();
            };
            TargetLauncher returnVal = this.connectToGatorThenCapture(session, path, page, onActivityStartedCallback);
            return returnVal;
        }
        return null;
    }

    private static @NonNull Session createSessionForBasicMode(@NonNull TargetAddressString targetAddress) {
        @NonNull Session session = new Session();
        session.setResolutionMode(DeviceConnectionModel.getResolutionMode(targetAddress.getAndroidSerialNumber()));
        session.setExcludeKernelEvents(ExcludeKernel.AUTO);
        return session;
    }

    private static boolean installThenStartGator(IRunnableWithProgress installer) {
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(installer);
            return true;
        }
        catch (InterruptedException ex) {
            return false;
        }
        catch (InvocationTargetException ex) {
            Error.show(ex.getCause());
            return false;
        }
    }

    private @Nullable TargetLauncher connectToGatorThenCapture(@NonNull Session session, @NonNull String captureSavePath, IWorkbenchPage page, @NonNull Runnable callback) {
        try {
            @NonNull TargetLauncher currentCapture = new TargetLauncher(session, captureSavePath, this.appSettings, callback);
            Path mgdExecutable = this.appSettings.getMgdExecutable();
            boolean keepTracing = this.appSettings.getMgdKeepTracing();
            IEditorPart editor = (IEditorPart)NullChecking.neverNull((Object)page.openEditor((IEditorInput)new CaptureInput(mgdExecutable, keepTracing, currentCapture), "com.arm.streamline.live"));
            if (editor instanceof LiveEditor) {
                Task.callOnAnotherThread((Runnable)currentCapture.getRunnableWith(this.capStateProxies));
                return currentCapture;
            }
        }
        catch (Exception exception) {
            this.capStateProxies.captureError(exception);
            Error.show(exception);
        }
        return null;
    }

    @Override
    public void stopLiveRequestSend() {
    }

    private void clearActiveCapture() {
        this.runCleanUpTask();
        this.activeCaptureAddress.set(null);
    }

    private void runCleanUpTask() {
        Runnable runnable = this.cleanUpTask.getAndSet(EMPTY_RUNNABLE);
        runnable.run();
    }

    private @Nullable TargetLauncher doStartCapture(@NonNull ITcpTargetLauncher activeTcpTarget) {
        String path;
        TargetAddressString targetAddress = new TargetAddressString(activeTcpTarget.getTargetAddress());
        Session session = new Session(this.defaultSessionForAdvancedSettings);
        session.setTargetAddress(targetAddress);
        session.setCaptureCommand(activeTcpTarget.getCommandPath());
        session.setCaptureWorkingDir(activeTcpTarget.getCommandWorkingDir());
        session.setCaptureUser(activeTcpTarget.getCommandUsername());
        session.setStopGator(activeTcpTarget.isCommandStopOnExit());
        if (!session.getTargetAddress().isValid()) {
            return null;
        }
        this.setActiveCapture(targetAddress);
        this.cleanUpTask.set(EMPTY_RUNNABLE);
        CaptureControlView.makeVisible();
        if (session.isDiscardEnabled()) {
            File parent = new File(CommonPreferences.getLastSavePath());
            path = new File(parent, CommonPreferences.chooseUniqueName((File)parent, (String)(CommonPreferences.getLastCaptureName() + ".apc"))).getAbsolutePath();
        } else {
            path = PathChoice.chooseCaptureSavePath();
        }
        if (path == null) {
            return null;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        return this.connectToGatorThenCapture(session, path, page, EMPTY_RUNNABLE);
    }

    private void setActiveCapture(@NonNull TargetAddressString targetAddress) {
        this.activeCaptureAddress.set((Object)targetAddress);
    }

    private static void cleanUpOnAndroid(final @NonNull AndroidDeviceGatordManager.IInstallUninstall installUninstallTask) {
        Job uninstallJob = new Job("Remove gatord from device"){

            protected IStatus run(@NonNull IProgressMonitor monitor) {
                try {
                    installUninstallTask.getUninstaller().run(monitor);
                }
                catch (InterruptedException ex) {
                    return Status.CANCEL_STATUS;
                }
                catch (InvocationTargetException e) {
                    Error.show(e.getCause());
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        uninstallJob.schedule();
    }

    @Override
    public void setProfileWithMaliCounters(@NonNull IAndroidTargetDevice selectedDevice, boolean checkedState) {
        AndroidDevicePreference.setProfileWithMaliCounters((String)selectedDevice.getSerialNumber(), (boolean)checkedState);
    }

    @Override
    public boolean getProfileWithMaliCounters(@NonNull IAndroidTargetDevice selectedDevice) {
        return AndroidDevicePreference.getProfileWithMaliCounters((String)selectedDevice.getSerialNumber());
    }

    @Override
    public boolean isProfileWithMaliCountersAddedForDevice(@NonNull IAndroidTargetDevice selectedDevice) {
        return AndroidDevicePreference.isProfileWithMaliCountersAddedForDevice((String)selectedDevice.getSerialNumber());
    }

    @Override
    public void setResolutionMode(@NonNull IAndroidTargetDevice selectedDevice, @NonNull ResolutionMode resolutionMode) {
        AndroidDevicePreference.setResolutionMode((String)selectedDevice.getSerialNumber(), (String)resolutionMode.getStringValue());
    }

    @Override
    public @NonNull ResolutionMode getResolutionMode(@NonNull IAndroidTargetDevice selectedDevice) {
        return DeviceConnectionModel.getResolutionMode(selectedDevice.getSerialNumber());
    }

    private static @NonNull ResolutionMode getResolutionMode(@NonNull String androidSerialNumber) {
        ResolutionMode resolutionMode;
        try {
            String resolutionModePersisted = AndroidDevicePreference.getResolutionMode((String)androidSerialNumber);
            resolutionMode = resolutionModePersisted.trim().isEmpty() ? ResolutionMode.NORMAL : ResolutionMode.fromStringValue((String)resolutionModePersisted);
        }
        catch (IllegalArgumentException e) {
            resolutionMode = ResolutionMode.NORMAL;
            AndroidDevicePreference.setResolutionMode((String)androidSerialNumber, (String)resolutionMode.getStringValue());
        }
        return resolutionMode;
    }

    @Override
    public void setApplicationArgumentsHistory(@NonNull List<@NonNull String> history) {
        this.argHistory = history;
    }

    @Override
    public void setApplicationArgumentsHistoryRefreshCallback(@NonNull Runnable refreshCallback) {
        this.refreshCallback = refreshCallback;
    }

    private void saveApplicationArgumentsHistory() {
        if (this.argHistory != null) {
            CommonPreferences.setApplicationArgumentsHistory(this.argHistory);
        }
    }

    @Override
    public @NonNull List<@NonNull String> getApplicationArgumentsHistory() {
        return CommonPreferences.getApplicationArgumentsHistory();
    }
}

