/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.streamline.counterconfig.CountersMessages;
import com.arm.streamline.counterconfig.model.Configurations;
import com.arm.streamline.counterconfig.model.CounterConfiguration;
import com.arm.streamline.counterconfig.outline.CountersOutline;
import com.arm.streamline.widget.outline.IOutlineListener;
import com.arm.streamline.widget.outline.Outline;
import com.arm.streamline.widget.outline.SimpleColumn;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class CountersPanelButtons
implements Configurations.IListener {
    public final @NonNull ToolBar toolBar;
    private final @NonNull Configurations configurations;
    private final @NonNull ToolItem add;
    private final @NonNull ToolItem remove;
    private @NonNull CountersOutline countersOutline;

    public CountersPanelButtons(@NonNull Composite parent, @NonNull CounterConfiguration config, final @NonNull CountersOutline countersOutline) {
        this.configurations = config.getConfigurations();
        this.countersOutline = countersOutline;
        this.toolBar = new ToolBar(parent, 512);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)this.toolBar);
        this.add = new ToolItem(this.toolBar, 8);
        this.add.setImage(StreamlinePlugin.getImage("AddObj.gif"));
        this.add.setToolTipText(CountersMessages.ADD_SELECTED_EVENTS);
        this.add.setEnabled(false);
        this.remove = new ToolItem(this.toolBar, 8);
        this.remove.setImage(StreamlinePlugin.getImage("DeleteObj.gif"));
        this.remove.setToolTipText(CountersMessages.REMOVE_SELECTED_EVENTS);
        this.remove.setEnabled(false);
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                @NonNull List<@NonNull StockCounter> selectedStockCounters = countersOutline.getSelectedStockCounters().stream().collect(Collectors.toList());
                @NonNull List<@NonNull SpeTargetDescription> selectedSpeTargets = countersOutline.getSelectedSpeEvents().stream().collect(Collectors.toList());
                CountersPanelButtons.this.configurations.addEvents(selectedSpeTargets, selectedStockCounters);
            }
        });
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                @NonNull Collection<@NonNull SpeTargetDescription> selectedSpeEvents = countersOutline.getSelectedSpeEvents();
                @NonNull Collection<@NonNull StockCounter> selectedStockCounters = countersOutline.getSelectedStockCounters();
                CountersPanelButtons.this.configurations.removeSelectedEvents(selectedSpeEvents, selectedStockCounters);
                countersOutline.getModel().deselect();
            }
        });
        this.configurations.addListener(this);
        countersOutline.addOutlineListener(new IOutlineListener<SimpleColumn>(){

            @Override
            public void deleteSelectionRequested(Outline<SimpleColumn> outline) {
            }

            @Override
            public void editorChanged(Outline<SimpleColumn> outline) {
            }

            @Override
            public void openSelectionRequested(Outline<SimpleColumn> outline) {
            }

            @Override
            public void selectionChanged(Outline<SimpleColumn> outline) {
                CountersPanelButtons.this.updateButtonStatus(countersOutline, CountersPanelButtons.this.add, CountersPanelButtons.this.remove);
            }
        });
    }

    private void updateButtonStatus(@NonNull CountersOutline countersOutline, @NonNull ToolItem add, @NonNull ToolItem remove) {
        boolean canAdd = false;
        boolean canRemove = false;
        for (StockCounter counter : countersOutline.getSelectedStockCounters()) {
            if (this.configurations.isInUse(counter, null, null)) {
                canRemove = true;
            }
            if (!this.configurations.atLeastOneCombinationIsntEnabledAndCanBe(counter)) continue;
            canAdd = true;
        }
        for (SpeTargetDescription spe : countersOutline.getSelectedSpeEvents()) {
            if (this.configurations.isAlreadyAddedToCollectEvents(spe)) {
                canRemove = true;
                continue;
            }
            canAdd = true;
        }
        if (!add.isDisposed()) {
            add.setEnabled(canAdd);
        }
        if (!remove.isDisposed()) {
            remove.setEnabled(canRemove);
        }
    }

    @Override
    public void handleReload() {
        this.updateButtonStatus(this.countersOutline, this.add, this.remove);
    }

    public void dispose() {
        this.configurations.removeListener(this);
    }
}

