/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.application.preferences.IPreferences;
import com.arm.streamline.common.model.warnings.WarningItem;
import com.arm.streamline.databrowser.ICaptureProxy;
import com.arm.streamline.databrowser.ILiveCapture;
import com.arm.streamline.model.live.LiveCaptureDataProvider;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jdt.annotation.NonNull;

public class CaptureStateProxy
implements ICaptureProxy {
    private final @NonNull List<@NonNull ICaptureProxy> captureStateProxies = new CopyOnWriteArrayList<ICaptureProxy>();

    @Override
    public void captureError(String msg) {
        this.captureStateProxies.forEach(c -> c.captureError(msg));
    }

    @Override
    public void captureError(@NonNull Throwable t) {
        this.captureStateProxies.forEach(c -> c.captureError(t));
    }

    @Override
    public void captureFinished(boolean isDiscarded) {
        this.captureStateProxies.forEach(c -> c.captureFinished(isDiscarded));
    }

    @Override
    public void captureStarted(ILiveCapture doc, LiveCaptureDataProvider live, IPreferences settings, boolean discard) {
        this.captureStateProxies.forEach(c -> c.captureStarted(doc, live, settings, discard));
    }

    @Override
    public void captureStopped(@NonNull ILiveCapture doc, boolean discard) {
        this.captureStateProxies.forEach(c -> c.captureStopped(doc, discard));
    }

    @Override
    public void liveError(String msg) {
        this.captureStateProxies.forEach(c -> c.liveError(msg));
    }

    @Override
    public void liveWarning(@NonNull WarningItem msg) {
        this.captureStateProxies.forEach(c -> c.liveWarning(msg));
    }

    public boolean addCaptureStateListener(@NonNull ICaptureProxy capProxy) {
        return this.captureStateProxies.add(capProxy);
    }

    public boolean removeCaptureStateListener(@NonNull ICaptureProxy capProxy) {
        return this.captureStateProxies.remove(capProxy);
    }

    @Override
    public void stopLiveRequestSend() {
        this.captureStateProxies.forEach(c -> c.stopLiveRequestSend());
    }
}

