/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.StdLog;
import com.arm.utils.function.IBooleanConsumer;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class CaptureDirectoryScannerThread {
    public static final @NonNull FileFilter CAPTURE_FILTER = file -> file.isDirectory() && file.getName().toLowerCase().endsWith(".apc");
    public static final long SCAN_PAUSE_MILLISECONDS = 10000L;
    private final @NonNull IBooleanConsumer busyEventConsumer;
    private final @NonNull Consumer<@NonNull Set<@NonNull File>> captureFilesConsumer;
    private final @NonNull AtomicReference<@NonNull File[]> directoriesArrayRef = new AtomicReference();
    private final @NonNull Object notificationObject = new Object();
    private final @NonNull AtomicBoolean rescan = new AtomicBoolean(false);
    private final @NonNull AtomicBoolean terminated = new AtomicBoolean(false);
    private final @NonNull Thread thread;

    private static @Nullable Set<@NonNull File> scanForAllFiles(@NonNull File @Nullable [] directories, @NonNull BooleanSupplier interruptedSupplier) {
        if (directories == null) {
            return null;
        }
        @NonNull HashSet<@NonNull E> uniqueFiles = new HashSet();
        File[] fileArray = directories;
        int n = directories.length;
        int n2 = 0;
        while (n2 < n) {
            File directory = fileArray[n2];
            if (!CommonFileUtils.scanFiles((File)directory, (FileFilter)CAPTURE_FILTER, uniqueFiles::add, (BooleanSupplier)interruptedSupplier)) {
                return null;
            }
            ++n2;
        }
        return Collections.unmodifiableSet(uniqueFiles);
    }

    public CaptureDirectoryScannerThread(@NonNull File @Nullable [] scanDirectories, @NonNull Consumer<@NonNull Set<@NonNull File>> captureFilesConsumer, @NonNull IBooleanConsumer busyEventConsumer) {
        this.captureFilesConsumer = captureFilesConsumer;
        this.busyEventConsumer = busyEventConsumer;
        this.directoriesArrayRef.set(scanDirectories);
        this.thread = new Thread(this::run, CaptureDirectoryScannerThread.class.getSimpleName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public boolean interrupted() {
        return this.rescan.get() || this.terminated.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescan() {
        Object object = this.notificationObject;
        synchronized (object) {
            this.rescan.set(true);
            this.notificationObject.notifyAll();
        }
    }

    public void setScanDirectories(@NonNull File @NonNull [] directories) {
        this.directoriesArrayRef.set(directories);
        this.rescan();
    }

    public void stop() {
        this.terminated.set(true);
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void busy() {
        this.busyEventConsumer.accept(true);
    }

    private void notBusy() {
        this.busyEventConsumer.accept(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        while (!this.terminated.get()) {
            this.busy();
            @NonNull File @Nullable [] directoriesArray = this.directoriesArrayRef.get();
            @Nullable Set<@NonNull File> captureFiles = CaptureDirectoryScannerThread.scanForAllFiles(directoriesArray, this::interrupted);
            if (captureFiles != null) {
                try {
                    this.captureFilesConsumer.accept(captureFiles);
                }
                catch (Throwable t) {
                    StdLog.warning((Plugin)StreamlinePlugin.getInstance(), (String)"Failure consuming capture list in capture scanner", (Throwable)t);
                }
            }
            if (this.terminated.get()) continue;
            Object object = this.notificationObject;
            synchronized (object) {
                if (!this.rescan.getAndSet(false)) {
                    try {
                        this.notBusy();
                        this.notificationObject.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        this.notBusy();
    }
}

