/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig;

import com.arm.databinding.NotListenableWidgetProperties;
import com.arm.streamline.common.xml.counters.IConfiguredEvent;
import com.arm.streamline.common.xml.spe.SpeFilterConfiguration;
import com.arm.streamline.common.xml.spe.SpeFilterEventProperties;
import com.arm.streamline.counterconfig.CountersMessages;
import com.arm.streamline.counterconfig.EventsEditorComposite;
import com.arm.streamline.counterconfig.viewmodel.SpeFilterViewModel;
import com.arm.streamline.utility.SWTUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.function.IBooleanConsumer;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableSet;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SpeEditorComposite {
    @Nullable
    private DataBindingContext m_bindingContext;
    private @NonNull Composite parent;
    private Text minLatency_text;
    private final @NonNull List<@NonNull IBooleanConsumer> validityListeners = new ArrayList<IBooleanConsumer>();
    @Nullable
    protected Group speGroup;
    @Nullable
    protected Composite invertEventFilterComposite;
    @Nullable
    protected Button branch_button;
    @Nullable
    protected Button store_button;
    @Nullable
    protected Button load_button;
    @Nullable
    protected Button invert_event_filter_button;
    @Nullable
    protected SpeFilterViewModel speViewModel;
    @Nullable
    protected CheckboxTableViewer eventTable;
    @Nullable
    private ControlDecorationSupport decorator;
    private final @NonNull EventsEditorComposite eventHandler;
    @Nullable
    private StyledText filterEventInfoText;
    @Nullable
    private StyledText oprTypeInfoText;
    @Nullable
    private ControlDecorationSupport filterWarning;

    public SpeEditorComposite(@NonNull Composite parent, @NonNull EventsEditorComposite eventHandler) {
        this.parent = parent;
        this.eventHandler = eventHandler;
    }

    public void createSpeEditor() {
        this.speGroup = new Group(this.parent, 768);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.speGroup);
        this.speGroup.setText(CountersMessages.CONFIG_SPE_PROPS);
        GridLayoutFactory.swtDefaults().applyTo((Composite)this.speGroup);
        this.createOperationTypeGroup();
        this.createFilterEventTable();
        this.createMinLatencyGroup();
        this.setInput();
        this.m_bindingContext = this.setDataBindings();
    }

    private void createMinLatencyGroup() {
        Composite minLatencyComposite = new Composite((Composite)this.speGroup, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).margins(0, 0).applyTo(minLatencyComposite);
        Label label_min_latency = new Label(minLatencyComposite, 0);
        label_min_latency.setText(CountersMessages.MIN_LATENCY);
        label_min_latency.setToolTipText(CountersMessages.MIN_LATENCY_TOOLTP);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).applyTo((Control)label_min_latency);
        this.minLatency_text = new Text(minLatencyComposite, 2048);
        this.minLatency_text.setTextLimit(9);
        GridDataFactory.fillDefaults().hint(60, -1).grab(true, false).align(4, 0x1000000).applyTo((Control)this.minLatency_text);
    }

    private void createOperationTypeGroup() {
        Group instrFilterTypeGroup = new Group((Composite)this.speGroup, 0);
        instrFilterTypeGroup.setText(CountersMessages.OP_TYPES);
        instrFilterTypeGroup.setToolTipText(CountersMessages.OP_TYPES_TOOLTIP);
        GridLayoutFactory.swtDefaults().numColumns(3).equalWidth(false).applyTo((Composite)instrFilterTypeGroup);
        this.load_button = new Button((Composite)instrFilterTypeGroup, 32);
        this.load_button.setText(CountersMessages.LOAD_OP_TYPES);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.load_button);
        this.store_button = new Button((Composite)instrFilterTypeGroup, 32);
        this.store_button.setText(CountersMessages.STORE_OP_TYPES);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.store_button);
        this.branch_button = new Button((Composite)instrFilterTypeGroup, 32);
        this.branch_button.setText(CountersMessages.BRANCH_OP_TYPES);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.branch_button);
        this.oprTypeInfoText = new StyledText((Composite)this.speGroup, 576);
        this.oprTypeInfoText.setAlwaysShowScrollBars(false);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, -1).applyTo((Control)this.oprTypeInfoText);
        this.oprTypeInfoText.setBackground(this.parent.getBackground());
    }

    private void createFilterEventTable() {
        Label label1 = new Label((Composite)this.speGroup, 0);
        label1.setText(CountersMessages.EVENT_FILTER);
        label1.setToolTipText(CountersMessages.EVENT_FILTER_TOOLTIP);
        CheckboxTableViewer newCheckList = CheckboxTableViewer.newCheckList((Composite)this.speGroup, (int)68352);
        assert (newCheckList != null);
        this.eventTable = newCheckList;
        GridDataFactory.fillDefaults().grab(true, false).hint(-1, 100).applyTo((Control)this.eventTable.getTable());
        ObservableSetContentProvider observableListContentProvider = new ObservableSetContentProvider();
        this.eventTable.setContentProvider((IContentProvider)observableListContentProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.eventTable, (int)1);
        this.eventTable.setComparator(new ViewerComparator());
        this.eventTable.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                SpeFilterEventProperties event = (SpeFilterEventProperties)element;
                return event.getName();
            }

            public String getToolTipText(Object element) {
                String description = ((SpeFilterEventProperties)element).getDescription();
                if (description != null) {
                    return SWTUtils.wrap(description, 80);
                }
                return null;
            }
        });
        this.invertEventFilterComposite = new Composite((Composite)this.speGroup, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).margins(0, 0).applyTo(this.invertEventFilterComposite);
        this.invert_event_filter_button = new Button(this.invertEventFilterComposite, 32);
        this.invert_event_filter_button.setText(CountersMessages.INVERT_EVENT_FILTER);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.invert_event_filter_button);
        this.filterEventInfoText = new StyledText((Composite)this.speGroup, 576);
        this.filterEventInfoText.setAlwaysShowScrollBars(false);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, -1).applyTo((Control)this.filterEventInfoText);
        this.filterEventInfoText.setBackground(this.parent.getBackground());
    }

    private void setInput() {
        if (this.speViewModel != null) {
            this.eventTable.setInput(this.speViewModel.getVisibleEvents());
            if (this.speViewModel.getSupportsSpev1p2()) {
                this.invert_event_filter_button.setEnabled(true);
                this.invertEventFilterComposite.setToolTipText(CountersMessages.INVERT_EVENT_FILTER_TOOLTIP_ENABLED);
            } else {
                this.invert_event_filter_button.setEnabled(false);
                this.invertEventFilterComposite.setToolTipText(CountersMessages.INVERT_EVENT_FILTER_TOOLTIP_DISABLED);
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private DataBindingContext setDataBindings() {
        if (this.speViewModel == null) {
            return null;
        }
        DataBindingContext bindingContext = new DataBindingContext();
        @NonNull @NonNull ISWTObservableValue observeMinLatText = WidgetProperties.text((int)24).observe((Widget)NullChecking.neverNull((Object)this.minLatency_text));
        @NonNull @NonNull IConverter convertStringToInt = IConverter.create(String.class, Integer.TYPE, minLat -> Integer.parseInt(minLat));
        @NonNull @NonNull UpdateValueStrategy stringtoIntStartegy = UpdateValueStrategy.create((IConverter)convertStringToInt);
        stringtoIntStartegy.setAfterGetValidator(minLat -> {
            try {
                int intValue = Integer.parseInt(minLat);
                boolean validateMinLatency = SpeFilterViewModel.validateMinLatency(intValue);
                if (validateMinLatency) {
                    this.eventHandler.updateValidty(true);
                    return ValidationStatus.ok();
                }
            }
            catch (Exception exception) {
                this.eventHandler.updateValidty(false);
                return ValidationStatus.error((String)CountersMessages.MIN_LATENCY_ERROR);
            }
            this.eventHandler.updateValidty(false);
            return ValidationStatus.error((String)CountersMessages.MIN_LATENCY_ERROR);
        });
        @NonNull @NonNull UpdateValueStrategy intToStringStartegy = UpdateValueStrategy.create((IConverter)IConverter.create(Integer.TYPE, String.class, minLat -> String.valueOf(minLat)));
        Binding bindValue = bindingContext.bindValue((IObservableValue)observeMinLatText, this.speViewModel.getMinLatency(), stringtoIntStartegy, intToStringStartegy);
        this.decorator = ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)131200);
        @NonNull ISWTObservableValue observeLoadButton = WidgetProperties.buttonSelection().observe((Widget)((Button)NullChecking.neverNull((Object)this.load_button)));
        bindingContext.bindValue((IObservableValue)observeLoadButton, this.speViewModel.isLoad(), null, null);
        @NonNull ISWTObservableValue observeStoreButton = WidgetProperties.buttonSelection().observe((Widget)((Button)NullChecking.neverNull((Object)this.store_button)));
        bindingContext.bindValue((IObservableValue)observeStoreButton, this.speViewModel.isStore(), null, null);
        @NonNull ISWTObservableValue observeBranchButton = WidgetProperties.buttonSelection().observe((Widget)((Button)NullChecking.neverNull((Object)this.branch_button)));
        bindingContext.bindValue((IObservableValue)observeBranchButton, this.speViewModel.isBranch(), null, null);
        IViewerObservableSet observeCheckedElements = ViewerProperties.checkedElements(SpeFilterEventProperties.class).observe((Viewer)this.eventTable);
        @NonNull IObservableSet<@NonNull SpeFilterEventProperties> eventsChecked = this.speViewModel.getEventsChecked();
        bindingContext.bindSet((IObservableSet)observeCheckedElements, eventsChecked, null, null);
        @NonNull ISWTObservableValue observeInvertEventFilterButton = WidgetProperties.buttonSelection().observe((Widget)((Button)NullChecking.neverNull((Object)this.invert_event_filter_button)));
        bindingContext.bindValue((IObservableValue)observeInvertEventFilterButton, this.speViewModel.isInvertEventFilter(), null, null);
        @NonNull ISWTObservableValue observe = NotListenableWidgetProperties.styledText().observe((Widget)((StyledText)NullChecking.neverNull((Object)this.filterEventInfoText)));
        Binding bindValue2 = bindingContext.bindValue((IObservableValue)observe, this.speViewModel.getObservableEventInfo(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        this.filterWarning = ControlDecorationSupport.create(this.speViewModel.getEventInfoWarning(), (int)128, (IObservable[])new IObservable[]{bindValue2.getTarget()});
        @NonNull ISWTObservableValue opTypeObersavable = NotListenableWidgetProperties.styledText().observe((Widget)((StyledText)NullChecking.neverNull((Object)this.oprTypeInfoText)));
        bindingContext.bindValue((IObservableValue)opTypeObersavable, this.speViewModel.getObservableOprTypeInfo(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), null);
        return bindingContext;
    }

    public void clearDecorator() {
        if (this.decorator != null) {
            this.decorator.dispose();
        }
        if (this.filterWarning != null) {
            this.filterWarning.dispose();
        }
    }

    public Control getControl() {
        return this.speGroup;
    }

    public void displaySpeConfiguration(@NonNull IConfiguredEvent event) {
        @NonNull SpeFilterConfiguration filterConfiguration = (SpeFilterConfiguration)event;
        this.speViewModel = new SpeFilterViewModel(filterConfiguration);
        this.setInput();
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.m_bindingContext = this.setDataBindings();
    }

    public void addvalidityListener(@NonNull IBooleanConsumer listner) {
        this.validityListeners.add(listner);
    }
}

