/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.cmdline;

import com.arm.streamline.editortabs.report.TableExport;
import com.arm.streamline.report.model.IFunction;
import com.arm.streamline.report.model.IInstructionsFile;
import com.arm.streamline.report.model.SourceFile;
import com.arm.streamline.report.model.icounters.IInstructionCounter;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterColumnDisplayTypeVisitor;
import com.arm.streamline.report.model.icounters.IInstructionCounterDecimalColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterFunctionViews;
import com.arm.streamline.report.model.icounters.IInstructionCounterHistogramColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterNumberColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterPercentAndValueColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterPercentColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterRatioColumn;
import com.arm.streamline.report.model.icounters.IInstructionCounterSource;
import com.arm.streamline.report.model.icounters.impl.InstructionCounterRatioColumnWithValueAndPercentSubColumns;
import com.arm.utils.NullChecking;
import com.arm.utils.StreamUtils;
import com.arm.utils.function.IThrowingFunction;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ExportDisasm {
    protected static final @NonNull IDisasmRow BREAK = new IDisasmRow(){

        @Override
        public <T, R, E extends Throwable> R accept(@NonNull IDisasmRowVisitor<T, R, E> visitor, T data) throws E {
            return visitor.brk(data);
        }
    };
    protected static final @NonNull IInstructionCounterColumnDisplayTypeVisitor<// Could not load outer class - annotation placement on inner may be incorrect
    IInstructionsFile.IInstructionsFileInstructionEntry, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull IInstructionsFile.IInstructionsFileInstructionEntry, @NonNull String, RuntimeException> COLUMN_VISITOR = new IInstructionCounterColumnDisplayTypeVisitor<IInstructionsFile.IInstructionsFileInstructionEntry, IInstructionsFile.IInstructionsFileInstructionEntry, String, RuntimeException>(){

        public @NonNull String displayAsHistogram(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileInstructionEntry data, @NonNull IInstructionCounterHistogramColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            return (String)NullChecking.applyIfNonNullOrDefault((Object)column.mapToHistogram((Object)data), (Object)"", this::formatHistogram);
        }

        public @NonNull String displayAsNumber(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileInstructionEntry data, @NonNull IInstructionCounterNumberColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            return (String)NullChecking.applyIfNonNullOrDefault((Object)column.mapToNumber((Object)data), (Object)"", String::valueOf);
        }

        public @NonNull String displayAsDecimal(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileInstructionEntry data, @NonNull IInstructionCounterDecimalColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            return (String)NullChecking.applyIfNonNullOrDefault((Object)column.mapToNumber((Object)data), (Object)"", String::valueOf);
        }

        public @NonNull String displayAsPercent(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileInstructionEntry data, @NonNull IInstructionCounterPercentColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            return (String)NullChecking.applyIfNonNullOrDefault((Object)column.mapToPercent((Object)data), (Object)"", this::formatPercent);
        }

        public @NonNull String displayAsPercentAndValue(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileInstructionEntry data, @NonNull IInstructionCounterPercentAndValueColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            throw new AssertionError((Object)"Expected to export subcolumns instead");
        }

        public @NonNull String displayAsRatio(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileInstructionEntry data, @NonNull IInstructionCounterRatioColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            throw new AssertionError((Object)"Expected to export subcolumns instead");
        }

        public @NonNull String displayAsRatioWithValueAndPercentSubColumns(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileInstructionEntry data, @NonNull InstructionCounterRatioColumnWithValueAndPercentSubColumns<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            throw new AssertionError((Object)"Expected to export subcolumns instead");
        }

        private @NonNull String formatHistogram(long @NonNull [] data) {
            return Arrays.stream(data).mapToObj(String::valueOf).collect(Collectors.joining("/", "", ""));
        }

        private @NonNull String formatPercent(@NonNull Double percent) {
            return String.format("%01.02f", percent);
        }
    };
    private static final @NonNull IInstructionCounterColumnDisplayTypeVisitor<// Could not load outer class - annotation placement on inner may be incorrect
    IInstructionsFile.IInstructionsFileInstructionEntry, Void, @NonNull Stream<@NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
    IInstructionsFile.IInstructionsFileInstructionEntry>>, RuntimeException> EXPORTABLE_EXTRACTOR = new IInstructionCounterColumnDisplayTypeVisitor<IInstructionsFile.IInstructionsFileInstructionEntry, Void, Stream<IInstructionCounterColumn<IInstructionsFile.IInstructionsFileInstructionEntry>>, RuntimeException>(){

        public @NonNull Stream<@NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry>> displayAsHistogram(Void data, @NonNull IInstructionCounterHistogramColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            return Stream.of(column);
        }

        public @NonNull Stream<@NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry>> displayAsNumber(Void data, @NonNull IInstructionCounterNumberColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            return Stream.of(column);
        }

        public @NonNull Stream<@NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry>> displayAsDecimal(Void data, @NonNull IInstructionCounterDecimalColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            return Stream.of(column);
        }

        public @NonNull Stream<@NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry>> displayAsPercent(Void data, @NonNull IInstructionCounterPercentColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            return Stream.of(column);
        }

        public @NonNull Stream<@NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry>> displayAsPercentAndValue(Void data, @NonNull IInstructionCounterPercentAndValueColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            return Stream.of(column.valueSubColumn(), column.percentSubColumn());
        }

        public @NonNull Stream<@NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry>> displayAsRatio(Void data, @NonNull IInstructionCounterRatioColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            return Stream.of(column.valueSubColumns());
        }

        public @NonNull Stream<@NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry>> displayAsRatioWithValueAndPercentSubColumns(Void data, @NonNull InstructionCounterRatioColumnWithValueAndPercentSubColumns<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> column) throws RuntimeException {
            return Stream.of(column.valueSubColumns()).flatMap(pvc -> Stream.of(pvc.valueSubColumn(), pvc.percentSubColumn()));
        }
    };

    public static @NonNull Predicate<@NonNull IFunction> acceptOnlyFunctionsWithData(@NonNull IInstructionCounterSource source) {
        IInstructionCounterFunctionViews functionViews = source.getFunctionViews();
        return f -> functionViews.hasFunctionAnyData(f);
    }

    public static @NonNull Predicate<@NonNull IFunction> acceptOnlyFunctionsWithDataFrom(@NonNull IInstructionCounterSource source, @NonNull Set<@NonNull String> imageNames) {
        IInstructionCounterFunctionViews functionViews = source.getFunctionViews();
        return f -> {
            @NonNull SourceFile sf = f.getImageFile();
            return (imageNames.contains(sf.getName()) || imageNames.contains(sf.getFullPath())) && functionViews.hasFunctionAnyData(f);
        };
    }

    public static @NonNull Predicate<@NonNull IFunction> acceptOnlyFunctionsWithDataFrom(@NonNull IInstructionCounterSource source, @NonNull String imageName) {
        IInstructionCounterFunctionViews functionViews = source.getFunctionViews();
        return f -> {
            @NonNull SourceFile sf = f.getImageFile();
            return (imageName.contentEquals(sf.getName()) || imageName.contentEquals(sf.getFullPath())) && functionViews.hasFunctionAnyData(f);
        };
    }

    public static @NonNull Stream<@NonNull IDisasmRow> createRowStream(@NonNull IInstructionsFile instructionsFile, @NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
    IInstructionsFile.IInstructionsFileInstructionEntry> @NonNull [] instructionColumns, @NonNull Predicate<@NonNull IFunction> functionPredicate) {
        return ExportDisasm.createRowStream(instructionsFile, 0, instructionsFile.getCount(), instructionColumns, functionPredicate);
    }

    public static @NonNull Stream<@NonNull IDisasmRow> createRowStream(@NonNull IInstructionsFile instructionsFile, int fromInstruction, int count, final @NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
    IInstructionsFile.IInstructionsFileInstructionEntry> @NonNull [] instructionColumns, final @NonNull Predicate<@NonNull IFunction> functionPredicate) {
        if (fromInstruction < 0 || count < 0 || fromInstruction + count > instructionsFile.getCount()) {
            throw new IllegalArgumentException();
        }
        if (count == 0) {
            return Stream.empty();
        }
        // Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileEntryVisitor<Void, @Nullable IDisasmRow, RuntimeException> visitor = new IInstructionsFile.IInstructionsFileEntryVisitor<Void, IDisasmRow, RuntimeException>(){

            public @Nullable IDisasmRow visit(// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull IInstructionsFile.IInstructionsFileBreakEntry entry, Void data) throws RuntimeException {
                if (!this.filter(entry.getFunction())) {
                    return null;
                }
                return BREAK;
            }

            public @Nullable IDisasmRow visit(// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull IInstructionsFile.IInstructionsFileFunctionEntry entry, Void data) throws RuntimeException {
                if (!this.filter(entry)) {
                    return null;
                }
                return new FunctionDisasmRow(entry);
            }

            public @Nullable IDisasmRow visit(// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull IInstructionsFile.IInstructionsFileInstructionEntry entry, Void data) throws RuntimeException {
                if (!this.filter(entry.getFunction())) {
                    return null;
                }
                return new InstructionDisasmRow(entry, instructionColumns);
            }

            private boolean filter(// Could not load outer class - annotation placement on inner may be incorrect
            @Nullable IInstructionsFile.IInstructionsFileFunctionEntry function) {
                if (function == null) {
                    return false;
                }
                return functionPredicate.test(function.getFunction());
            }
        };
        return StreamUtils.filterOutNull(IntStream.range(fromInstruction, fromInstruction + count).mapToObj(arg_0 -> ((IInstructionsFile)instructionsFile).getEntry(arg_0)).map(arg_0 -> ExportDisasm.lambda$4((IInstructionsFile.IInstructionsFileEntryVisitor)visitor, arg_0)));
    }

    public static @NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
    IInstructionsFile.IInstructionsFileInstructionEntry> @NonNull [] extractAllExportableColumns(@NonNull IInstructionCounterSource source) {
        return (IInstructionCounterColumn[])StreamUtils.filterOutNull(source.getInstructionCounters().stream().map(IInstructionCounter::getCodeColumns)).map(c -> c.instructionColumn).flatMap(c -> (Stream)c.acceptDisplayTypeVisitor(EXPORTABLE_EXTRACTOR, null)).toArray(IInstructionCounterColumn[]::new);
    }

    public static void generateCsv(@NonNull IInstructionsFile instructionsFile, @NonNull IInstructionCounterSource source, @NonNull OutputStream outputStream) throws IOException {
        ExportDisasm.generateOutput(instructionsFile, source, columns -> ExportDisasm.createCsvConsumer(columns, outputStream), ExportDisasm.acceptOnlyFunctionsWithData(source));
    }

    public static void generateCsvFor(@NonNull IInstructionsFile instructionsFile, @NonNull IInstructionCounterSource source, @NonNull Set<@NonNull String> imageNames, @NonNull IThrowingFunction<@NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
    IInstructionsFile.IInstructionsFileInstructionEntry> @NonNull [], @NonNull ColumnFormatter<IOException>, IOException> outputFactory) throws IOException {
        ExportDisasm.generateOutput(instructionsFile, source, outputFactory, ExportDisasm.acceptOnlyFunctionsWithDataFrom(source, imageNames));
    }

    public static void generateCsvFor(@NonNull IInstructionsFile instructionsFile, @NonNull IInstructionCounterSource source, @NonNull Set<@NonNull String> imageNames, @NonNull OutputStream outputStream) throws IOException {
        ExportDisasm.generateOutput(instructionsFile, source, columns -> ExportDisasm.createCsvConsumer(columns, outputStream), ExportDisasm.acceptOnlyFunctionsWithDataFrom(source, imageNames));
    }

    public static void generateCsvFor(@NonNull IInstructionsFile instructionsFile, @NonNull IInstructionCounterSource source, @NonNull String imageName, @NonNull IThrowingFunction<@NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
    IInstructionsFile.IInstructionsFileInstructionEntry> @NonNull [], @NonNull ColumnFormatter<IOException>, IOException> outputFactory) throws IOException {
        ExportDisasm.generateOutput(instructionsFile, source, outputFactory, ExportDisasm.acceptOnlyFunctionsWithDataFrom(source, imageName));
    }

    public static void generateCsvFor(@NonNull IInstructionsFile instructionsFile, @NonNull IInstructionCounterSource source, @NonNull String imageName, @NonNull OutputStream outputStream) throws IOException {
        ExportDisasm.generateOutput(instructionsFile, source, columns -> ExportDisasm.createCsvConsumer(columns, outputStream), ExportDisasm.acceptOnlyFunctionsWithDataFrom(source, imageName));
    }

    public static <E1 extends Throwable, E2 extends Throwable> void generateOutput(@NonNull IInstructionsFile instructionsFile, @NonNull IInstructionCounterSource source, @NonNull IThrowingFunction<@NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
    IInstructionsFile.IInstructionsFileInstructionEntry> @NonNull [], ? extends @NonNull IDisasmRowVisitor<Void, Void, E2>, E1> outputFactory) throws E1, E2 {
        ExportDisasm.generateOutput(instructionsFile, source, outputFactory, ExportDisasm.acceptOnlyFunctionsWithData(source));
    }

    public static <E1 extends Throwable, E2 extends Throwable> void generateOutput(@NonNull IInstructionsFile instructionsFile, @NonNull IInstructionCounterSource source, @NonNull IThrowingFunction<@NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
    IInstructionsFile.IInstructionsFileInstructionEntry> @NonNull [], ? extends @NonNull IDisasmRowVisitor<Void, Void, E2>, E1> outputFactory, @NonNull Predicate<@NonNull IFunction> predicate) throws E1, E2 {
        @NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> @NonNull [] exportableColumns = ExportDisasm.extractAllExportableColumns(source);
        @NonNull Stream<@NonNull IDisasmRow> stream = ExportDisasm.createRowStream(instructionsFile, exportableColumns, predicate);
        @NonNull IDisasmRowVisitor visitor = (IDisasmRowVisitor)outputFactory.apply(exportableColumns);
        Iterator<@NonNull T> it = stream.iterator();
        while (it.hasNext()) {
            ((IDisasmRow)it.next()).accept(visitor, null);
        }
    }

    public static <E1 extends Throwable, E2 extends Throwable> void generateOutput(@NonNull IInstructionsFile instructionsFile, @NonNull IInstructionCounterSource source, @NonNull IThrowingFunction<@NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
    IInstructionsFile.IInstructionsFileInstructionEntry> @NonNull [], ? extends @NonNull IDisasmRowVisitor<Void, Void, E2>, E1> outputFactory, @NonNull String imageName) throws E1, E2 {
        ExportDisasm.generateOutput(instructionsFile, source, outputFactory, ExportDisasm.acceptOnlyFunctionsWithDataFrom(source, imageName));
    }

    private static @NonNull ColumnFormatter<IOException> createCsvConsumer(@NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
    IInstructionsFile.IInstructionsFileInstructionEntry> @NonNull [] columns, @NonNull OutputStream outputStream) throws IOException {
        @NonNull String title = StreamUtils.concat((Stream[])new Stream[]{Arrays.stream(ColumnFormatter.COLUMNS).map(TableExport::makeCSVSafe), Arrays.stream(columns).map(ExportDisasm::makeColumnTitle)}).collect(Collectors.joining(",", "", "\n"));
        outputStream.write(title.getBytes(StandardCharsets.UTF_8));
        return new ColumnFormatter<IOException>(row -> {
            @NonNull String string = Arrays.stream(row).map(TableExport::makeCSVSafe).collect(Collectors.joining(",", "", "\n"));
            outputStream.write(string.getBytes(StandardCharsets.UTF_8));
        });
    }

    private static @NonNull String makeColumnTitle(@NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
    IInstructionsFile.IInstructionsFileInstructionEntry> column) {
        @Nullable IInstructionCounterColumn parent = column.getParentColumn();
        if (parent == null) {
            return column.getTitle();
        }
        return String.format("%s: %s", parent.getTitle(), column.getTitle());
    }

    private static /* synthetic */ IDisasmRow lambda$4(IInstructionsFile.IInstructionsFileEntryVisitor iInstructionsFileEntryVisitor, IInstructionsFile.IInstructionsFileEntry t) {
        return (IDisasmRow)t.accept(iInstructionsFileEntryVisitor, null);
    }

    public static class ColumnFormatter<T extends Throwable>
    implements IDisasmRowVisitor<Void, Void, T> {
        public static final @NonNull String @NonNull [] COLUMNS = new String[]{"Image", "Function", "Address", "Type", "OpCode", "Disassembly", "Source File", "Source Line", "Inlined"};
        private final @NonNull IConsumer<T> consumer;

        protected static @Nullable String getValidSourceLocation(@NonNull SourceFile imageFile, @Nullable SourceFile sourceFile, int sourceLine) {
            if (sourceFile == null || sourceLine <= 0) {
                return null;
            }
            if (imageFile.equals((Object)sourceFile)) {
                return null;
            }
            if (sourceFile.isBinary()) {
                return null;
            }
            return sourceFile.getFullPath();
        }

        protected static boolean is16bit(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileInstructionEntry.Type type) {
            switch (type) {
                case T32_16BIT: 
                case T32EE_16BIT: {
                    return true;
                }
                case A32: 
                case A64: 
                case T32_32BIT: 
                case T32EE_32BIT: {
                    return false;
                }
            }
            throw new AssertionError(type);
        }

        protected static @NonNull String opcodeType(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileInstructionEntry.Type type) {
            switch (type) {
                case A32: {
                    return "A32";
                }
                case A64: {
                    return "A64";
                }
                case T32_16BIT: 
                case T32EE_16BIT: {
                    return "T16";
                }
                case T32_32BIT: 
                case T32EE_32BIT: {
                    return "T32";
                }
            }
            throw new AssertionError(type);
        }

        public ColumnFormatter(@NonNull IConsumer<T> consumer) {
            this.consumer = consumer;
        }

        @Override
        public Void brk(Void data) throws T {
            return null;
        }

        @Override
        public Void function(Void data, @NonNull IFunction function) throws T {
            this.consumer.row(new String[]{function.getImageFile().getName(), function.getName()});
            return null;
        }

        @Override
        public Void instruction(Void data, long address, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileInstructionEntry.Type type, @Nullable SourceFile sourceFile, int sourceLine, int opcode, @NonNull String disasm, @NonNull IFunction function, boolean inline, @NonNull String @NonNull [] values) throws T {
            boolean is16bit = ColumnFormatter.is16bit(type);
            @Nullable String sourceLocation = ColumnFormatter.getValidSourceLocation(function.getImageFile(), sourceFile, sourceLine);
            @NonNull String @NonNull [] row = new String[COLUMNS.length + values.length];
            row[0] = function.getImageFile().getName();
            row[1] = function.getName();
            row[2] = String.format("0x%016x", address);
            row[3] = ColumnFormatter.opcodeType(type);
            row[4] = String.format(is16bit ? "0x%04x" : "0x%08x", opcode);
            row[5] = disasm;
            row[6] = sourceLocation != null ? sourceLocation : "";
            row[7] = sourceLocation != null ? String.format("%d", sourceLine) : "";
            row[8] = inline ? "I" : "";
            System.arraycopy(values, 0, row, COLUMNS.length, values.length);
            this.consumer.row(row);
            return null;
        }

        public static interface IConsumer<T extends Throwable> {
            public void row(@NonNull String @NonNull [] var1) throws T;
        }
    }

    protected static final class FunctionDisasmRow
    implements IDisasmRow {
        protected final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileFunctionEntry entry;

        public FunctionDisasmRow(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileFunctionEntry entry) {
            this.entry = entry;
        }

        @Override
        public <T, R, E extends Throwable> R accept(@NonNull IDisasmRowVisitor<T, R, E> visitor, T data) throws E {
            return visitor.function(data, this.entry.getFunction());
        }
    }

    public static interface IDisasmRow {
        public <T, R, E extends Throwable> R accept(@NonNull IDisasmRowVisitor<T, R, E> var1, T var2) throws E;
    }

    public static interface IDisasmRowVisitor<T, R, E extends Throwable> {
        public R brk(T var1) throws E;

        public R function(T var1, @NonNull IFunction var2) throws E;

        public R instruction(T var1, long var2, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileInstructionEntry.Type var4, @Nullable SourceFile var5, int var6, int var7, @NonNull String var8, @NonNull IFunction var9, boolean var10, @NonNull String @NonNull [] var11) throws E;
    }

    protected static final class InstructionDisasmRow
    implements IDisasmRow {
        protected final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileInstructionEntry entry;
        protected final @NonNull String @NonNull [] values;

        private static @NonNull String extract(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileInstructionEntry entry, @NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> instructionCounterColumn) {
            return (String)instructionCounterColumn.acceptDisplayTypeVisitor(COLUMN_VISITOR, (Object)entry);
        }

        public InstructionDisasmRow(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull IInstructionsFile.IInstructionsFileInstructionEntry entry, @NonNull IInstructionCounterColumn<// Could not load outer class - annotation placement on inner may be incorrect
        IInstructionsFile.IInstructionsFileInstructionEntry> @NonNull [] instructionColumns) {
            this.entry = entry;
            this.values = new String[instructionColumns.length];
            int index = 0;
            while (index < instructionColumns.length) {
                this.values[index] = InstructionDisasmRow.extract(entry, instructionColumns[index]);
                ++index;
            }
        }

        @Override
        public <T, R, E extends Throwable> R accept(@NonNull IDisasmRowVisitor<T, R, E> visitor, T data) throws E {
            return visitor.instruction(data, this.entry.getAddress(), this.entry.getType(), this.entry.getSourceFile(), this.entry.getLine(), this.entry.getFormattedOpcode(), this.entry.getDisassembly(), this.entry.getFunction().getFunction(), this.entry.isInlined(), this.values);
        }
    }
}

