/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard.events;

import com.arm.streamline.barmancfg.wizard.events.ProcessorPmuEventPair;
import com.arm.streamline.barmancfg.wizard.events.ProcessorPmuEventRow;
import com.arm.streamline.barmancfg.wizard.events.SelectedEventsOutlineModel;
import com.arm.streamline.barmancfg.wizard.events.SelectedProcessorPmuRow;
import com.arm.streamline.counterconfig.BaseCountersOutline;
import com.arm.streamline.utility.io.LocalObjectTransfer;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.SimpleColumn;
import com.arm.utils.NullChecking;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PmuSelectedEventsOutline
extends BaseCountersOutline
implements DropTargetListener {
    private final DropTarget mDropTarget = new DropTarget((Control)this, 1);

    public static void addChild(@NonNull SelectedEventsOutlineModel model, @NonNull SelectedProcessorPmuRow pRow, @NonNull ProcessorPmuEventPair event) {
        for (Row child : new ArrayList(pRow.getChildren())) {
            ProcessorPmuEventRow eRow = (ProcessorPmuEventRow)child;
            if (!eRow.getEvent().equals(event)) continue;
            eRow.removeFromParent();
        }
        ProcessorPmuEventRow newRow = new ProcessorPmuEventRow(event, model);
        pRow.addChild(newRow);
        int insertionPoint = model.getIndexOfRow(pRow);
        for (Row child : (List)NullChecking.neverNull(pRow.getChildren())) {
            insertionPoint = Math.max(insertionPoint, model.getIndexOfRow(child));
        }
        model.addRow(insertionPoint + 1, newRow);
    }

    public PmuSelectedEventsOutline(Composite parent, @NonNull OutlineModel<SimpleColumn> modelSelected) {
        super(parent, modelSelected, false);
        this.mDropTarget.setTransfer(new Transfer[]{LocalObjectTransfer.get(Row.class)});
        this.mDropTarget.addDropListener((DropTargetListener)this);
    }

    public void dragEnter(DropTargetEvent event) {
        if (this.isValidDrag(event)) {
            this.setDropHighlight(true);
            event.detail = 1;
        } else {
            this.setDropHighlight(false);
            event.detail = 0;
        }
    }

    public void dragLeave(DropTargetEvent event) {
        this.setDropHighlight(false);
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (this.isValidDrag(event)) {
            this.setDropHighlight(true);
            event.detail = 1;
        } else {
            this.setDropHighlight(false);
            event.detail = 0;
        }
    }

    public void dragOver(DropTargetEvent event) {
        event.detail = 1;
    }

    public void drop(DropTargetEvent event) {
        Row<SimpleColumn>[] rowArray = this.getDropTargetTransfer().getTransferObjects();
        int n = rowArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessorPmuEventRow eRow;
            Row<SimpleColumn> row = rowArray[n2];
            if (row instanceof ProcessorPmuEventRow && (eRow = (ProcessorPmuEventRow)row).isEnabled()) {
                this.dropEvent(eRow.getEvent());
            }
            ++n2;
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void dropEvent(@NonNull ProcessorPmuEventPair event) {
        SelectedEventsOutlineModel model = (SelectedEventsOutlineModel)NullChecking.neverNull((Object)((SelectedEventsOutlineModel)this.getModel()));
        SelectedProcessorPmuRow pmuRow = null;
        for (Row row : model.getRows()) {
            ProcessorPmuEventRow eRow;
            if (row instanceof SelectedProcessorPmuRow) {
                SelectedProcessorPmuRow pRow = (SelectedProcessorPmuRow)row;
                if (!pRow.getPmu().equals((Object)event.getPmu())) continue;
                assert (pmuRow == null);
                pmuRow = pRow;
                continue;
            }
            if (!(row instanceof ProcessorPmuEventRow) || !(eRow = (ProcessorPmuEventRow)row).getEvent().equals(event)) continue;
            return;
        }
        if (pmuRow == null) {
            pmuRow = new SelectedProcessorPmuRow(event.getPmu());
            model.addRow(pmuRow, true);
        }
        PmuSelectedEventsOutline.addChild(model, pmuRow, event);
    }

    @Override
    protected boolean isRowDraggable(Row<SimpleColumn> row) {
        return row instanceof ProcessorPmuEventRow;
    }

    private LocalObjectTransfer<Row<SimpleColumn>> getDropTargetTransfer() {
        return (LocalObjectTransfer)this.mDropTarget.getTransfer()[0];
    }

    private boolean isValidDrag(DropTargetEvent event) {
        if ((event.operations & 1) == 1) {
            return this.getDropTargetTransfer().isSupportedType(event.currentDataType);
        }
        return false;
    }
}

