/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard;

import com.arm.streamline.barmancfg.BarmanGenerator;
import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.configuration.DataStorageBackend;
import com.arm.streamline.barmancfg.configuration.DefaultConfigSettings;
import com.arm.streamline.barmancfg.configuration.STMBackendConfiguration;
import com.arm.streamline.barmancfg.configuration.StreamingConfiguration;
import com.arm.streamline.barmancfg.wizard.BarmanITMConfigPage;
import com.arm.streamline.barmancfg.wizard.BarmanWizardMessages;
import com.arm.streamline.barmancfg.wizard.BarmanWizardSTMConfigPage;
import com.arm.streamline.barmancfg.wizard.utils.AbstractFileInputHelper;
import com.arm.streamline.barmancfg.wizard.utils.WizardUtils;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.streamline.utility.SWTUtils;
import com.arm.streamline.utility.ui.ILastFilterPathStore;
import com.arm.streamline.utility.ui.SimpleLastFilterPathStore;
import com.arm.streamline.widget.TextField;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class BarmanSelectConfigOptionsPage
extends WizardPage {
    public static final String PAGE_NAME = "PAGE_1";
    public static final String PAGE_TITLE = BarmanWizardMessages.PAGE_1_TITLE;
    private static @NonNull ILastFilterPathStore LAST_XML_PATH = new SimpleLastFilterPathStore();
    protected @Nullable File configCustomEventsLocation;
    protected @Nullable File configCustomPmusLocation;
    protected @NonNull DataStorageBackend configDataStorageBackend;
    protected boolean configEnableBuiltinMemFuncs;
    protected boolean configEnableDebugLogging;
    protected boolean configEnableLogging;
    protected int configMaxCores;
    protected int configMaxMmapLayoutEntries;
    protected int configMaxTaskEntries;
    protected @Nullable Long configMinimumSamplePeriod;
    private final @NonNull BarmanConfiguration defaults;
    private @Nullable IWizardPage page;
    final boolean openAdvancedPage;

    private static boolean isNullOrFilePath(@Nullable File file) {
        return file == null || file.exists() && file.isFile();
    }

    public BarmanSelectConfigOptionsPage(@NonNull BarmanConfiguration defaults, boolean openAdvancedPage) {
        super(PAGE_NAME, PAGE_TITLE, null);
        this.defaults = defaults;
        this.configDataStorageBackend = defaults.getDataStorageBackend();
        this.configEnableBuiltinMemFuncs = defaults.getConfigSettings().isEnableBuiltinMemFuncs();
        this.configEnableDebugLogging = defaults.getConfigSettings().isEnableDebugLogging();
        this.configEnableLogging = defaults.getConfigSettings().isEnableLogging();
        this.configMaxCores = defaults.getConfigSettings().getMaxCores();
        this.configMaxMmapLayoutEntries = defaults.getConfigSettings().getMaxMmapLayoutEntries();
        this.configMaxTaskEntries = defaults.getConfigSettings().getMaxTaskEntries();
        this.configMinimumSamplePeriod = defaults.getConfigSettings().getMinimumSamplePeriod();
        this.configCustomPmusLocation = (File)NullChecking.applyIfNonNull((Object)defaults.getPmusXmlPath(), File::new);
        this.configCustomEventsLocation = (File)NullChecking.applyIfNonNull((Object)defaults.getEventsXmlPath(), File::new);
        this.openAdvancedPage = openAdvancedPage;
    }

    public void createControl(Composite parent) {
        final Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        SWTUtils.createLabel(composite, BarmanWizardMessages.PAGE_1_LABEL_SELECT_DATA_STORE_BACKEND, BarmanWizardMessages.PAGE_1_TOOLTIP_SELECT_DATA_STORE_BACKEND, 0);
        final @NonNull ArrayList<@NonNull E> validValues = new ArrayList();
        Combo combo = SWTUtils.createCombo(composite, BarmanWizardMessages.PAGE_1_TOOLTIP_SELECT_DATA_STORE_BACKEND, DataStorageBackend.valuesSorted(), new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Combo widget = (Combo)e.widget;
                int selection = widget.getSelectionIndex();
                if (selection >= 0 && selection < validValues.size()) {
                    int index = widget.getSelectionIndex();
                    BarmanSelectConfigOptionsPage.this.configDataStorageBackend = (DataStorageBackend)((Object)validValues.get(index));
                    BarmanSelectConfigOptionsPage.this.validateComplete();
                }
            }
        }, o -> {
            switch ((DataStorageBackend)((Object)((Object)o))) {
                case CIRCULAR_RAM_BUFFER: {
                    return BarmanWizardMessages.PAGE_1_LABEL_CIRCULAR_RAM_BUFFER;
                }
                case LINEAR_RAM_BUFFER: {
                    return BarmanWizardMessages.PAGE_1_LABEL_LINEAR_RAM_BUFFER;
                }
                case STM_INTERFACE: {
                    return BarmanWizardMessages.PAGE_1_LABEL_STM_INTERFACE;
                }
                case ITM_INTERFACE: {
                    return BarmanWizardMessages.PAGE_1_LABEL_ITM_INTERFACE;
                }
            }
            throw new AssertionError();
        }, validValues);
        combo.select(Math.max(validValues.indexOf((Object)this.configDataStorageBackend), 0));
        Spinner maxCores = WizardUtils.addSpinner(composite, 1, 128, BarmanWizardMessages.PAGE_1_LABEL_MAX_CORES, BarmanWizardMessages.PAGE_1_TOOLTIP_MAX_CORES, n -> {
            this.configMaxCores = n;
            return n;
        });
        maxCores.setSelection(this.configMaxCores);
        @NonNull Composite[] advancedOptions = new Composite[1];
        ExpandableComposite expComp = new ExpandableComposite(composite, 90);
        advancedOptions[0] = new Composite((Composite)expComp, 0);
        expComp.setText(BarmanWizardMessages.PAGE_1_LABEL_ADVANCED_OPTIONS);
        expComp.setClient((Control)advancedOptions[0]);
        expComp.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanged(ExpansionEvent arg0) {
                composite.layout();
            }

            public void expansionStateChanging(ExpansionEvent arg0) {
            }
        });
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).span(2, 1).applyTo((Control)expComp);
        expComp.setExpanded(this.openAdvancedPage);
        advancedOptions[0].setLayout((Layout)new GridLayout(2, true));
        Spinner maxMmapLayoutEntries = WizardUtils.addSpinner(advancedOptions[0], 0, Integer.MAX_VALUE, BarmanWizardMessages.PAGE_1_LABEL_MAX_MMAP_LAYOUT_ENTRIES, BarmanWizardMessages.PAGE_1_TOOLTIP_MAX_MMAP_LAYOUT_ENTRIES, n -> {
            this.configMaxMmapLayoutEntries = n;
            return n;
        });
        maxMmapLayoutEntries.setSelection(this.configMaxMmapLayoutEntries);
        Spinner maxTaskEntries = WizardUtils.addSpinner(advancedOptions[0], 0, Integer.MAX_VALUE, BarmanWizardMessages.PAGE_1_LABEL_MAX_TASK_ENTRIES, BarmanWizardMessages.PAGE_1_TOOLTIP_MAX_TASK_ENTRIES, n -> {
            this.configMaxTaskEntries = n;
            return n;
        });
        maxTaskEntries.setSelection(this.configMaxTaskEntries);
        Label label = new Label(advancedOptions[0], 16384);
        label.setText(BarmanWizardMessages.PAGE_1_LABEL_MIN_SAMPLE_PERIOD);
        label.setToolTipText(BarmanWizardMessages.PAGE_1_TOOLTIP_MIN_SAMPLE_PERIOD);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
        TextField minimumSamplePeriod = new TextField(advancedOptions[0]);
        GridDataFactory.fillDefaults().minSize(25, -1).hint(100, -1).align(16384, 0x1000000).applyTo((Control)minimumSamplePeriod);
        Color defaultColour = minimumSamplePeriod.getTextForeground();
        Color errorColour = minimumSamplePeriod.getDisplay().getSystemColor(3);
        minimumSamplePeriod.setText(String.valueOf(this.configMinimumSamplePeriod));
        minimumSamplePeriod.setToolTipText(BarmanWizardMessages.PAGE_1_TOOLTIP_MIN_SAMPLE_PERIOD);
        minimumSamplePeriod.addFieldModifiedListener(f -> {
            try {
                Long value = Long.decode(minimumSamplePeriod.getText());
                if (value < 0L) {
                    throw new NumberFormatException();
                }
                this.configMinimumSamplePeriod = value;
                minimumSamplePeriod.setTextForeground(defaultColour);
            }
            catch (NumberFormatException e) {
                this.configMinimumSamplePeriod = null;
                minimumSamplePeriod.setTextForeground(errorColour);
            }
            this.validateComplete();
        });
        Button[] enableDebugLogging = new Button[1];
        Button enableLogging = WizardUtils.addCheckbox(advancedOptions[0], BarmanWizardMessages.PAGE_1_LABEL_ENABLE_LOGGING, BarmanWizardMessages.PAGE_1_TOOLTIP_ENABLE_LOGGING, b -> {
            this.configEnableLogging = b;
            if (enableDebugLogging[0] != null) {
                enableDebugLogging[0].setEnabled(this.configEnableLogging);
            }
            return b;
        });
        enableLogging.setSelection(this.configEnableLogging);
        enableDebugLogging[0] = WizardUtils.addCheckbox(advancedOptions[0], BarmanWizardMessages.PAGE_1_LABEL_ENABLE_DEBUG_LOGGING, BarmanWizardMessages.PAGE_1_TOOLTIP_ENABLE_DEBUG_LOGGING, b -> {
            if (!this.configEnableLogging) {
                return (Boolean)NullChecking.neverNull((Object)Boolean.FALSE);
            }
            this.configEnableDebugLogging = b;
            return b;
        });
        enableDebugLogging[0].setEnabled(enableLogging.getSelection());
        enableDebugLogging[0].setSelection(this.configEnableDebugLogging);
        Button enableBuiltinMemFuncs = WizardUtils.addCheckbox(advancedOptions[0], BarmanWizardMessages.PAGE_1_LABEL_ENABLE_BUILTIN_MEMFUNCS, BarmanWizardMessages.PAGE_1_TOOLTIP_ENABLE_BUILTIN_MEMFUNCS, b -> {
            this.configEnableBuiltinMemFuncs = b;
            return b;
        });
        enableBuiltinMemFuncs.setSelection(this.configEnableBuiltinMemFuncs);
        ((GridData)enableBuiltinMemFuncs.getLayoutData()).horizontalSpan = 2;
        WizardUtils.addFileInput(advancedOptions[0], BarmanWizardMessages.PAGE_1_LABEL_CUSTOM_PMU_XML, BarmanWizardMessages.PAGE_1_TOOLTIP_CUSTOM_PMU_XML, BarmanWizardMessages.PAGE_1_TOOLTIP_SET_CUSTOM_PMU_XML, this.getPmusXmlPath(), new AbstractFileInputHelper(LAST_XML_PATH, new String[]{"pmus.xml", "All XML files"}, new String[]{"pmus.xml", "*.xml"}){

            @Override
            protected @Nullable File handleValidatedInputChanged(@NonNull File currentValue) {
                BarmanSelectConfigOptionsPage.this.configCustomPmusLocation = currentValue;
                return currentValue;
            }

            @Override
            protected void handleInputCleared() {
                BarmanSelectConfigOptionsPage.this.configCustomPmusLocation = null;
            }

            @Override
            protected void handleInputInvalid(@NonNull String currentValue) {
                BarmanSelectConfigOptionsPage.this.configCustomPmusLocation = null;
            }

            @Override
            protected boolean validate(@NonNull File currentValue) {
                return true;
            }
        });
        WizardUtils.addFileInput(advancedOptions[0], BarmanWizardMessages.PAGE_1_LABEL_CUSTOM_EVENT_XML, BarmanWizardMessages.PAGE_1_TOOLTIP_CUSTOM_EVENT_XML, BarmanWizardMessages.PAGE_1_TOOLTIP_SET_CUSTOM_EVENT_XML, this.getEventsXmlPath(), new AbstractFileInputHelper(LAST_XML_PATH, new String[]{"events.xml", "All XML files"}, new String[]{"events.xml", "*.xml"}){

            @Override
            protected @Nullable File handleValidatedInputChanged(@NonNull File currentValue) {
                BarmanSelectConfigOptionsPage.this.configCustomEventsLocation = currentValue;
                return currentValue;
            }

            @Override
            protected void handleInputCleared() {
                BarmanSelectConfigOptionsPage.this.configCustomEventsLocation = null;
            }

            @Override
            protected void handleInputInvalid(@NonNull String currentValue) {
                BarmanSelectConfigOptionsPage.this.configCustomEventsLocation = null;
            }

            @Override
            protected boolean validate(@NonNull File currentValue) {
                return true;
            }
        });
        this.setControl((Control)composite);
        this.setPageComplete(false);
        this.validateComplete();
    }

    public @Nullable DataStorageBackend getDataStorageBackend() {
        return this.configDataStorageBackend;
    }

    public @Nullable DefaultConfigSettings getDefaultConfigSettings() {
        Long minimumSamplePeriod = this.configMinimumSamplePeriod;
        if (minimumSamplePeriod == null) {
            return null;
        }
        return new DefaultConfigSettings(this.configEnableLogging, this.configEnableDebugLogging, this.configEnableBuiltinMemFuncs, this.configMaxCores, this.configMaxTaskEntries, this.configMaxMmapLayoutEntries, minimumSamplePeriod);
    }

    public @Nullable String getEventsXmlPath() {
        return (String)NullChecking.applyIfNonNull((Object)this.configCustomEventsLocation, File::getAbsolutePath);
    }

    public IWizardPage getNextPage() {
        @NonNull IWizardPage nextPage = (IWizardPage)NullChecking.neverNull((Object)super.getNextPage());
        switch (this.configDataStorageBackend) {
            case STM_INTERFACE: {
                if (this.page == null || !(this.page instanceof BarmanWizardSTMConfigPage)) {
                    STMBackendConfiguration stmConfig = this.defaults.getStmConfiguration();
                    StreamingConfiguration streamingConfig = this.defaults.getStreamingConfiguration();
                    if (stmConfig == null) {
                        stmConfig = new STMBackendConfiguration();
                    }
                    if (streamingConfig == null) {
                        streamingConfig = new StreamingConfiguration();
                    }
                    this.page = new BarmanWizardSTMConfigPage((IWizard)NullChecking.neverNull((Object)this.getWizard()), nextPage, stmConfig, streamingConfig, () -> this.configMaxCores);
                }
                return this.page;
            }
            case ITM_INTERFACE: {
                if (this.page == null || !(this.page instanceof BarmanITMConfigPage)) {
                    this.page = nextPage;
                }
                return this.page;
            }
        }
        return nextPage;
    }

    public @Nullable String getPmusXmlPath() {
        return (String)NullChecking.applyIfNonNull((Object)this.configCustomPmusLocation, File::getAbsolutePath);
    }

    public @Nullable Map<Integer, ProcessorPmu> getProcessorPmus() throws IOException {
        String eventsXml = this.getEventsXmlPath();
        String pmusXml = this.getPmusXmlPath();
        return BarmanGenerator.getProcessorPmuConfigurations(pmusXml, eventsXml, this.configDataStorageBackend.getAllowedClassifications());
    }

    protected void validateComplete() {
        this.setPageComplete(this.configMinimumSamplePeriod != null && BarmanSelectConfigOptionsPage.isNullOrFilePath(this.configCustomPmusLocation) && BarmanSelectConfigOptionsPage.isNullOrFilePath(this.configCustomEventsLocation));
    }
}

