/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.preprocessor.javaresources;

import com.arm.streamline.barmancfg.preprocessor.AbstractCFileResource;
import com.arm.streamline.barmancfg.preprocessor.ICFileResourceLocator;
import com.arm.streamline.barmancfg.preprocessor.javaresources.CFileResource;
import com.arm.utils.NullChecking;
import java.io.InputStream;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CFileResourceLocator
implements ICFileResourceLocator {
    private final @NonNull Class<?> clazz;
    private final @NonNull List<@NonNull String> searchPrefixes;

    public CFileResourceLocator(@NonNull Class<?> clazz, @NonNull List<@NonNull String> searchPrefixes) {
        this.clazz = clazz;
        this.searchPrefixes = searchPrefixes;
    }

    @Override
    public @Nullable AbstractCFileResource find(@NonNull String path) {
        for (String prefix : this.searchPrefixes) {
            AbstractCFileResource result = this.tryPath(prefix, path);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public @NonNull InputStream open(@NonNull CFileResource resource) {
        return (InputStream)NullChecking.neverNull((Object)this.clazz.getResourceAsStream(resource.getPath()));
    }

    private @Nullable AbstractCFileResource tryPath(@NonNull String prefix, @NonNull String path) {
        String resourcePath = (String)NullChecking.neverNull((Object)String.format("%s/%s", prefix.replaceAll("/$", ""), path.replaceAll("^/", "")));
        if (this.clazz.getResource(resourcePath) != null) {
            return new CFileResource(this, path, resourcePath);
        }
        return null;
    }
}

