/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.gen.header;

import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.configuration.CustomChart;
import com.arm.streamline.barmancfg.configuration.CustomChartSeries;
import com.arm.streamline.barmancfg.gen.header.IBarmanHeaderGenerator;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterDisplay;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.utils.NullChecking;
import com.arm.utils.text.BasicStringUtils;
import org.eclipse.jdt.annotation.NonNull;

public class CustomCountersConstantsGenerator
implements IBarmanHeaderGenerator {
    public static final String TOKEN_BARMAN_H = "CUSTOM_COUNTERS_CONSTANTS_HEADER";
    public static final String TOKEN_COUNTERS_H = "CUSTOM_COUNTERS_CONSTANTS";
    public static final String TOKEN_COUNTERS_C = "CUSTOM_COUNTERS_DEFINITIONS";

    private static void appendConstantList(@NonNull StringBuilder builder, @NonNull String constant) {
        if (builder.length() > 0) {
            builder.append(",\n");
        }
        builder.append("    &").append(constant);
    }

    private static @NonNull String generateBarmanH(@NonNull BarmanConfiguration configuration) {
        StringBuilder result = new StringBuilder();
        result.append("/* ----------------- Custom counters ----------------- */\n\n");
        for (CustomChart chart : configuration.getCustomCharts()) {
            for (CustomChartSeries series : chart.getSeries()) {
                if (series.isSample()) {
                    String samplingFunctionName = CustomCountersConstantsGenerator.makeSeriesSamplingFunctionName(chart, series);
                    result.append("/** Custom counter sampling function for custom counter ").append(chart.getName()).append(" - ").append(series.getName()).append(" */\n").append("BM_NONNULL((1))\n").append("extern bm_bool ").append(samplingFunctionName).append("(bm_uint64 * value_out);\n\n");
                    continue;
                }
                String updateFunctionName = CustomCountersConstantsGenerator.makeSeriesUpdateFunctionName(chart, series);
                String updateFunctionNowName = String.format("%s_now", updateFunctionName);
                String perCoreTypedParam = chart.isPerCpu() ? ", bm_uint32 core" : "";
                result.append("/** Custom counter update function for custom counter ").append(chart.getName()).append(" - ").append(series.getName()).append("\n * - This version takes a timestamp and possibly also core value as arguments\n */\n").append("bm_bool ").append(updateFunctionName).append("(bm_uint64 timestamp").append(perCoreTypedParam).append(", bm_uint64 value);\n\n");
                result.append("/** Custom counter update function for custom counter ").append(chart.getName()).append(" - ").append(series.getName()).append("\n * - This version takes just the value and sends the current timestamp and core\n */\n").append("bm_bool ").append(updateFunctionNowName).append("(bm_uint64 value);\n\n");
            }
        }
        return (String)NullChecking.neverNull((Object)result.toString());
    }

    private static @NonNull String generateCountersH(@NonNull BarmanConfiguration configuration) {
        StringBuilder result = new StringBuilder();
        int seriesCounter = 0;
        for (CustomChart chart : configuration.getCustomCharts()) {
            seriesCounter += chart.getSeries().size();
        }
        result.append("/* ----------------- Custom counters ----------------- */\n\n");
        result.append("#define BM_NUM_CUSTOM_COUNTERS ").append(seriesCounter).append("\n");
        result.append("#define BM_CUSTOM_CHARTS_COUNT ").append(configuration.getCustomCharts().size()).append("\n\n");
        if (seriesCounter > 0) {
            result.append("extern const struct bm_custom_counter_chart * const BM_CUSTOM_CHARTS[BM_CUSTOM_CHARTS_COUNT];\n");
            result.append("extern const struct bm_custom_counter_chart_series * const BM_CUSTOM_CHARTS_SERIES[BM_NUM_CUSTOM_COUNTERS];\n\n");
        }
        return (String)NullChecking.neverNull((Object)result.toString());
    }

    private static @NonNull String generateCountersC(@NonNull BarmanConfiguration configuration) {
        StringBuilder result = new StringBuilder();
        StringBuilder chartArrayBuilder = new StringBuilder();
        StringBuilder allSeriesArrayBuilder = new StringBuilder();
        int chartNo = 0;
        int seriesCounter = 0;
        for (CustomChart chart : configuration.getCustomCharts()) {
            StringBuilder seriesArrayBuilder = new StringBuilder();
            result.append("/* ----------------- Custom counter chart ").append(chart.getName()).append(" ----------------- */\n\n");
            for (CustomChartSeries series : chart.getSeries()) {
                String seriesConstant = CustomCountersConstantsGenerator.makeSeriesConstantName(chart, series);
                Integer colour = series.getColour();
                String samplingFunctionName = CustomCountersConstantsGenerator.makeSeriesSamplingFunctionName(chart, series);
                result.append("static const struct bm_custom_counter_chart_series ").append(seriesConstant).append(" = {").append(chartNo).append(", \"").append(BasicStringUtils.escapeString((String)series.getName())).append("\", \"").append(BasicStringUtils.escapeString((String)series.getUnits())).append("\", \"").append(BasicStringUtils.escapeString((String)series.getDescription())).append("\", ").append(CustomCountersConstantsGenerator.makeSeriesClassEnum(series.getClazz())).append(", ").append(CustomCountersConstantsGenerator.makeSeriesDisplayEnum(series.getDisplay())).append(", ").append(series.getMultiplier()).append(", ").append((String)(colour != null ? "0x" + Integer.toHexString(colour & 0xFFFFFF) : "~0u")).append(", ").append(series.isSample() ? String.format("&%s", samplingFunctionName) : "BM_NULL").append("};\n");
                CustomCountersConstantsGenerator.appendConstantList(seriesArrayBuilder, seriesConstant);
                CustomCountersConstantsGenerator.appendConstantList(allSeriesArrayBuilder, seriesConstant);
                if (!series.isSample()) {
                    String updateFunctionName = CustomCountersConstantsGenerator.makeSeriesUpdateFunctionName(chart, series);
                    String updateFunctionNowName = String.format("%s_now", updateFunctionName);
                    String perCoreTypedParam = chart.isPerCpu() ? ", bm_uint32 core" : "";
                    String perCoreParam = chart.isPerCpu() ? "core, " : "0, ";
                    String getCoreParam = chart.isPerCpu() ? ", barman_get_core_no()" : "";
                    result.append("\n").append("bm_bool ").append(updateFunctionName).append("(bm_uint64 timestamp").append(perCoreTypedParam).append(", bm_uint64 value)\n").append("{\n").append("    return barman_protocol_write_per_core_custom_counter(timestamp, ").append(perCoreParam).append("\n#if BM_CONFIG_MAX_TASK_INFOS > 0\n        barman_ext_get_current_task_id(),\n#endif\n        ").append(seriesCounter).append(", value);\n}\n\n");
                    result.append("bm_bool ").append(updateFunctionNowName).append("(bm_uint64 value)\n").append("{\n").append("    return ").append(updateFunctionName).append("(").append("barman_ext_get_timestamp()").append(getCoreParam).append(", value);\n}\n\n");
                }
                ++seriesCounter;
            }
            String seriesArrayConstant = CustomCountersConstantsGenerator.makeSeriesArrayConstantName(chart);
            result.append("static const struct bm_custom_counter_chart_series * const ").append(seriesArrayConstant).append("[").append(chart.getSeries().size()).append("]").append(" = {").append(chart.getSeries().isEmpty() ? "" : "\n").append((CharSequence)seriesArrayBuilder).append(chart.getSeries().isEmpty() ? "" : "\n").append("};\n");
            String chartConstant = CustomCountersConstantsGenerator.makeChartConstantName(chart);
            result.append("static const struct bm_custom_counter_chart ").append(chartConstant).append(" = {\"").append(BasicStringUtils.escapeString((String)chart.getName())).append("\", ").append(CustomCountersConstantsGenerator.makeChartSeriesCompositionEnum(chart.getSeriesComposition())).append(", ").append(CustomCountersConstantsGenerator.makeChartRenderingTypeEnum(chart.getRenderingType())).append(", ").append(chart.isAverageSelection() ? "BM_TRUE" : "BM_FALSE").append(", ").append(chart.isAverageCores() ? "BM_TRUE" : "BM_FALSE").append(", ").append(chart.isPercentage() ? "BM_TRUE" : "BM_FALSE").append(", ").append(chart.isPerCpu() ? "BM_TRUE" : "BM_FALSE").append(", ").append(chart.getSeries().size()).append(", ").append(seriesArrayConstant).append("};\n");
            result.append("\n");
            CustomCountersConstantsGenerator.appendConstantList(chartArrayBuilder, chartConstant);
            ++chartNo;
        }
        if (seriesCounter > 0) {
            result.append("/* ----------------- Custom counters ----------------- */\n\n");
            result.append("const struct bm_custom_counter_chart * const BM_CUSTOM_CHARTS[BM_CUSTOM_CHARTS_COUNT] = {").append("\n").append((CharSequence)chartArrayBuilder).append("\n").append("};\n");
            result.append("const struct bm_custom_counter_chart_series * const BM_CUSTOM_CHARTS_SERIES[BM_NUM_CUSTOM_COUNTERS] = {").append("\n").append((CharSequence)allSeriesArrayBuilder).append("\n").append("};\n\n");
        }
        return (String)NullChecking.neverNull((Object)result.toString());
    }

    private static @NonNull String makeChartConstantName(@NonNull CustomChart chart) {
        return (String)NullChecking.neverNull((Object)String.format("BM_CUSTOM_CHART_%s", chart.getKeyName().toUpperCase()));
    }

    private static @NonNull String makeChartRenderingTypeEnum(@NonNull GraphRenderingType renderingType) {
        switch (renderingType) {
            case BAR: {
                return "BM_RENDERING_TYPE_BAR";
            }
            case FILLED: {
                return "BM_RENDERING_TYPE_FILLED";
            }
            case LINE: {
                return "BM_RENDERING_TYPE_LINE";
            }
        }
        throw new AssertionError(renderingType);
    }

    private static @NonNull String makeChartSeriesCompositionEnum(@NonNull SeriesComposition seriesComposition) {
        switch (seriesComposition) {
            case LOG10: {
                return "BM_SERIES_COMPOSITION_LOG10";
            }
            case OVERLAY: {
                return "BM_SERIES_COMPOSITION_OVERLAY";
            }
            case STACKED: {
                return "BM_SERIES_COMPOSITION_STACKED";
            }
        }
        throw new AssertionError(seriesComposition);
    }

    private static @NonNull String makeSeriesArrayConstantName(@NonNull CustomChart chart) {
        return (String)NullChecking.neverNull((Object)String.format("BM_CUSTOM_CHART_%s_SERIES_LIST", chart.getKeyName().toUpperCase()));
    }

    private static @NonNull String makeSeriesClassEnum(@NonNull CounterClass clazz) {
        switch (clazz) {
            case ABSOLUTE: {
                return "BM_SERIES_CLASS_ABSOLUTE";
            }
            case ACTIVITY: {
                return "BM_SERIES_CLASS_ACTIVITY";
            }
            case DELTA: {
                return "BM_SERIES_CLASS_DELTA";
            }
            case INCIDENT: {
                return "BM_SERIES_CLASS_INCIDENT";
            }
        }
        throw new AssertionError((Object)("Invalid CounterClass: " + String.valueOf(clazz)));
    }

    private static @NonNull String makeSeriesConstantName(@NonNull CustomChart chart, @NonNull CustomChartSeries series) {
        return (String)NullChecking.neverNull((Object)String.format("BM_CUSTOM_CHART_%s_SERIES_%s", chart.getKeyName().toUpperCase(), series.getKeyName().toUpperCase()));
    }

    private static @NonNull String makeSeriesDisplayEnum(@NonNull CounterDisplay display) {
        switch (display) {
            case ACCUMULATE: {
                return "BM_SERIES_DISPLAY_ACCUMULATE";
            }
            case AVERAGE: {
                return "BM_SERIES_DISPLAY_AVERAGE";
            }
            case HERTZ: {
                return "BM_SERIES_DISPLAY_HERTZ";
            }
            case MAXIMUM: {
                return "BM_SERIES_DISPLAY_MAXIMUM";
            }
            case MINIMUM: {
                return "BM_SERIES_DISPLAY_MINIMUM";
            }
        }
        throw new AssertionError(display);
    }

    private static @NonNull String makeSeriesSamplingFunctionName(@NonNull CustomChart chart, @NonNull CustomChartSeries series) {
        return (String)NullChecking.neverNull((Object)String.format("barman_cc_%s_%s_sample_now", chart.getKeyName(), series.getKeyName()).toLowerCase());
    }

    private static @NonNull String makeSeriesUpdateFunctionName(@NonNull CustomChart chart, @NonNull CustomChartSeries series) {
        return (String)NullChecking.neverNull((Object)String.format("barman_cc_%s_%s_update_value", chart.getKeyName(), series.getKeyName()).toLowerCase());
    }

    @Override
    public @NonNull String generate(@NonNull String token, @NonNull BarmanConfiguration configuration) {
        switch (token) {
            case "CUSTOM_COUNTERS_CONSTANTS_HEADER": {
                return CustomCountersConstantsGenerator.generateBarmanH(configuration);
            }
            case "CUSTOM_COUNTERS_CONSTANTS": {
                return CustomCountersConstantsGenerator.generateCountersH(configuration);
            }
            case "CUSTOM_COUNTERS_DEFINITIONS": {
                return CustomCountersConstantsGenerator.generateCountersC(configuration);
            }
        }
        throw new AssertionError((Object)token);
    }
}

