/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.v1;

import com.arm.streamline.barman.recordstream.AbstractBarmanRecord;
import com.arm.streamline.barman.recordstream.IBarmanEventStream;
import gnu.trove.TCollections;
import gnu.trove.iterator.TIntLongIterator;
import gnu.trove.map.TIntLongMap;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class BarmanSampleRecordWithoutTaskV3
extends AbstractBarmanRecord {
    private final int core;
    private final @NonNull TIntLongMap counterValues;

    public BarmanSampleRecordWithoutTaskV3(long timestamp, int core, @NonNull TIntLongMap counterValues) {
        super(timestamp);
        this.core = core;
        this.counterValues = counterValues;
    }

    public int getCore() {
        return this.core;
    }

    public @NonNull TIntLongMap getCounterValues() {
        return TCollections.unmodifiableMap((TIntLongMap)this.counterValues);
    }

    @Override
    public void process(@NonNull IBarmanEventStream eventStream) throws IOException {
        TIntLongIterator it = this.counterValues.iterator();
        while (it.hasNext()) {
            it.advance();
            eventStream.counter(this.timestamp, this.core, it.key(), it.value());
        }
    }

    public String toString() {
        return String.format("SampleRecordWithoutTaskV3 {core: %s, timestamp : %s, values : %s}", this.core, this.timestamp, this.counterValues);
    }
}

