/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.v1;

import com.arm.streamline.barman.recordstream.AbstractBarmanRecord;
import com.arm.streamline.barman.recordstream.IBarmanEventStream;
import gnu.trove.TCollections;
import gnu.trove.iterator.TIntLongIterator;
import gnu.trove.map.TIntLongMap;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class BarmanSampleRecordV1
extends AbstractBarmanRecord {
    private final int core;
    private final @NonNull TIntLongMap counterValues;
    private final long pc;
    private final int taskId;
    private final  @NonNull BarmanTaskSwitchRecordV1.Reason taskSwitchReason;

    public BarmanSampleRecordV1(long timestamp, int core, int taskId,  @NonNull BarmanTaskSwitchRecordV1.Reason taskSwitchReason, long pc, @NonNull TIntLongMap counterValues) {
        super(timestamp);
        this.core = core;
        this.taskId = taskId;
        this.taskSwitchReason = taskSwitchReason;
        this.pc = pc;
        this.counterValues = counterValues;
    }

    public int getCore() {
        return this.core;
    }

    public @NonNull TIntLongMap getCounterValues() {
        return TCollections.unmodifiableMap((TIntLongMap)this.counterValues);
    }

    public long getPC() {
        return this.pc;
    }

    public int getTaskId() {
        return this.taskId;
    }

    @Override
    public void process(@NonNull IBarmanEventStream eventStream) throws IOException {
        eventStream.schedSwitch(this.timestamp, this.core, this.taskId, this.taskSwitchReason.getDatabaseValue());
        if (this.pc != 0L) {
            eventStream.absoluteSample(this.timestamp, this.taskId, new long[]{this.pc});
        }
        TIntLongIterator it = this.counterValues.iterator();
        while (it.hasNext()) {
            it.advance();
            eventStream.counter(this.timestamp, this.core, this.taskId, it.key(), it.value());
        }
    }

    public String toString() {
        return String.format("SampleRecordV1 {core: %s, timestamp : %s, taskId : %s, taskSwitchReason: %s, pc : 0x%x, values : %s}", new Object[]{this.core, this.timestamp, this.taskId, this.taskSwitchReason, this.pc, this.counterValues});
    }
}

