/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.recordstream;

import com.arm.streamline.barman.recordstream.IBarmanBlockLength;
import com.arm.streamline.barman.recordstream.IBarmanRecordStreamReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;

public interface IBarmanSeekableRecordStreamReader
extends IBarmanRecordStreamReader {
    public long getFrameOffset() throws IOException;

    public @NonNull IBarmanBlockLength readBlockLength() throws IOException;

    public void seekFrame(long var1) throws IOException;

    public @NonNull ByteBuffer readBytes(int var1) throws IOException;

    @Override
    default public @NonNull IBarmanRecordStreamReader.Block readBlock() throws IOException {
        IBarmanBlockLength barmanBlockLength = this.readBlockLength();
        long length = barmanBlockLength.getLength();
        long offset = this.getFrameOffset();
        if (length > Integer.MAX_VALUE) {
            throw new AssertionError();
        }
        if (!barmanBlockLength.isPadding() && length > 0L) {
            return new IBarmanRecordStreamReader.Block(this.readBytes((int)length), offset);
        }
        this.seekFrame(offset + length);
        return new IBarmanRecordStreamReader.Block(null, offset);
    }
}

