/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.recordstream;

public interface IBarmanBlockLength {
    public long getLength();

    public boolean isPadding();

    public static class EigthByte
    implements IBarmanBlockLength {
        private final long length;

        EigthByte(long length) {
            this.length = length;
        }

        @Override
        public long getLength() {
            return this.length & Long.MAX_VALUE;
        }

        @Override
        public boolean isPadding() {
            return (this.length & Long.MIN_VALUE) != 0L;
        }
    }

    public static class FourByte
    implements IBarmanBlockLength {
        private final long length;

        FourByte(long length) {
            this.length = length;
        }

        @Override
        public long getLength() {
            return this.length & Integer.MAX_VALUE;
        }

        @Override
        public boolean isPadding() {
            return (this.length & 0x80000000L) != 0L;
        }
    }
}

