/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.recordstream;

import com.arm.streamline.barman.BarmanDataError;
import com.arm.streamline.barman.BarmanDataInput;
import com.arm.streamline.barman.BarmanSeekableDataInput;
import com.arm.streamline.barman.recordstream.BarmanDataStoreParameters;
import com.arm.streamline.barman.recordstream.IBarmanBlockLength;
import com.arm.streamline.barman.recordstream.IBarmanSeekableRecordStreamReader;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;

public class BarmanLinearRecordStreamInput
implements IBarmanSeekableRecordStreamReader {
    private final @NonNull BarmanDataInput<?> dataInput;
    private final @NonNull BarmanDataStoreParameters dataStoreParameters;
    private final long initialOffset;

    public BarmanLinearRecordStreamInput(@NonNull BarmanDataInput<?> dataInput, @NonNull BarmanDataStoreParameters dataStoreParameters) throws IOException, BarmanDataError {
        this.dataInput = dataInput;
        this.dataStoreParameters = dataStoreParameters;
        this.initialOffset = dataInput.getOffset();
        if (dataStoreParameters.getReadOffset() < 0L || dataStoreParameters.getReadOffset() > Integer.MAX_VALUE || dataStoreParameters.getReadOffset() > dataStoreParameters.getWriteOffset()) {
            throw new BarmanDataError();
        }
        dataInput.skipBytes((int)dataStoreParameters.getReadOffset());
    }

    @Override
    public void close() throws IOException {
        this.dataInput.close();
    }

    @Override
    public long getFrameOffset() throws IOException {
        return this.dataInput.getOffset() - this.initialOffset;
    }

    @Override
    public @NonNull IBarmanBlockLength readBlockLength() throws IOException {
        long result = this.dataInput.readMachineWord();
        return this.dataInput.getMachineWordLength() == 8 ? new IBarmanBlockLength.EigthByte(result) : new IBarmanBlockLength.FourByte(result);
    }

    @Override
    public @NonNull ByteBuffer readBytes(int length) throws IOException {
        ByteBuffer buffer = this.dataInput.readBytes(length);
        this.validateLength();
        return buffer;
    }

    @Override
    public void seekFrame(long offset) throws IOException {
        BarmanSeekableDataInput seekable;
        if (this.dataInput instanceof BarmanSeekableDataInput) {
            seekable = (BarmanSeekableDataInput)this.dataInput;
            if (offset >= this.dataStoreParameters.getWriteOffset()) {
                throw new EOFException();
            }
            if (offset < this.dataStoreParameters.getReadOffset()) {
                throw new IOException();
            }
        } else {
            throw new AssertionError();
        }
        seekable.seek(this.initialOffset + offset);
    }

    private void validateLength() throws IOException {
        if (this.dataInput.getOffset() - this.initialOffset > this.dataStoreParameters.getWriteOffset()) {
            throw new EOFException();
        }
    }
}

