/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.recordstream;

import com.arm.streamline.barman.BarmanSeekableDataInput;
import com.arm.streamline.barman.recordstream.BarmanDataStoreParameters;
import com.arm.streamline.barman.recordstream.IBarmanBlockLength;
import com.arm.streamline.barman.recordstream.IBarmanSeekableRecordStreamReader;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNull;

public class BarmanCircularRecordStreamInput
implements IBarmanSeekableRecordStreamReader {
    private final @NonNull BarmanSeekableDataInput dataInput;
    private final long dataLength;
    private final long initialReadOffset;
    private final long originalOffset;
    private long readLength;
    private final long wrapOffset;

    public BarmanCircularRecordStreamInput(@NonNull BarmanSeekableDataInput dataInput, @NonNull BarmanDataStoreParameters dataStoreParameters) throws IOException {
        this.dataInput = dataInput;
        this.dataLength = dataStoreParameters.getCircularDataLength();
        this.originalOffset = dataInput.getOffset();
        this.readLength = 0L;
        this.initialReadOffset = dataStoreParameters.getReadOffset() % dataStoreParameters.getBufferLength();
        this.wrapOffset = dataStoreParameters.getBufferLength() - dataStoreParameters.getReadOffset() % dataStoreParameters.getBufferLength();
        dataInput.seek(this.originalOffset + this.initialReadOffset);
    }

    @Override
    public void close() throws IOException {
        this.dataInput.close();
    }

    @Override
    public long getFrameOffset() throws IOException {
        return this.readLength;
    }

    @Override
    public @NonNull IBarmanBlockLength readBlockLength() throws IOException {
        this.validateWrap(this.dataInput.getMachineWordLength());
        long result = this.dataInput.readMachineWord();
        this.validateLength(this.dataInput.getMachineWordLength());
        return this.dataInput.getMachineWordLength() == 8 ? new IBarmanBlockLength.EigthByte(result) : new IBarmanBlockLength.FourByte(result);
    }

    @Override
    public @NonNull ByteBuffer readBytes(int length) throws IOException {
        if (this.readLength < this.wrapOffset && this.readLength + (long)length > this.wrapOffset) {
            throw new AssertionError();
        }
        ByteBuffer buffer = this.dataInput.readBytes(length);
        this.validateLength(length);
        return buffer;
    }

    @Override
    public void seekFrame(long offset) throws IOException {
        if (offset >= this.dataLength) {
            throw new EOFException();
        }
        if (offset >= this.wrapOffset) {
            this.dataInput.seek(this.originalOffset + (offset - this.wrapOffset));
        } else {
            this.dataInput.seek(this.originalOffset + this.initialReadOffset + offset);
        }
        this.readLength = offset;
    }

    private void validateLength(int length) throws EOFException {
        this.readLength += (long)length;
        if (this.readLength > this.dataLength) {
            throw new EOFException();
        }
    }

    private void validateWrap(int length) throws IOException {
        if (this.readLength <= this.wrapOffset && this.readLength + (long)length > this.wrapOffset) {
            this.readLength += this.wrapOffset - this.readLength;
            this.dataInput.seek(this.originalOffset);
        }
    }
}

