/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.pass_one_two;

import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.database.SummaryWriter;
import com.arm.streamline.analysis.database.api.IAnalysisWriterFactoryV2;
import com.arm.streamline.analysis.database.stream.factory.AnalysisDatabaseWriterFactoryV2;
import com.arm.streamline.analysis.database.stream.factory.AnalysisDatabaseWriterStateTracker;
import com.arm.streamline.analysis.database.stream.factory.IAnalysisDatabaseWriterStateTracker;
import com.arm.streamline.analysis.model.DeviceTypeCalculator;
import com.arm.streamline.analysis.model.StaticCounterSeriesKey;
import com.arm.streamline.analysis.model.SummaryRecord;
import com.arm.streamline.analysis.model.threads.IUniqueProcess;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.analysis.model.topology.ClusterInformationRewriter;
import com.arm.streamline.barman.BarmanClustersInfo;
import com.arm.streamline.barman.BarmanMessages;
import com.arm.streamline.barman.IBarmanHeaderProcessor;
import com.arm.streamline.barman.pass_two.BarmanEventStream;
import com.arm.streamline.barman.pass_two.IBarmanUniqueThreadTracker;
import com.arm.streamline.barman.recordstream.BarmanRecordStreamProducer;
import com.arm.streamline.barman.recordstream.IBarmanEventStream;
import com.arm.streamline.barman.recordstream.IBarmanRecord;
import com.arm.streamline.barman.recordstream.IBarmanRecordFactory;
import com.arm.streamline.barman.recordstream.IBarmanSeekableRecordStreamReader;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.model.warnings.IWarnings;
import com.arm.streamline.report.model.VariableReplacer;
import com.arm.streamline.report.model.pe.ProcessingElementDescriptor;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.utils.collections.Pair;
import com.arm.utils.datainput.SeekableInputStream;
import com.arm.utils.function.IThrowingFunction;
import com.arm.utils.function.IThrowingSupplier;
import com.arm.utils.function.Throwing;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BarmanPassOneTwo<T extends IBarmanRecord> {
    private final @NonNull IBarmanHeaderProcessor<T> headerProcessor;
    private final @NonNull IThrowingSupplier<@NonNull IBarmanSeekableRecordStreamReader, Exception> recordStreamInputSupplier;
    private final @NonNull List<@NonNull StaticCounterSeriesKey> staticCounterSeriesKeys;
    private final @NonNull IThrowingFunction<@NonNull IAnalysisDatabaseWriterStateTracker, @NonNull IAnalysisWriterFactoryV2, IOException> analysisWriterFactorySupplier;

    public BarmanPassOneTwo(@NonNull File barmanRawFile, @NonNull IBarmanHeaderProcessor<T> headerProcessor, @NonNull List<@NonNull CounterRecord> counterRecords, @NonNull ProcessingElementReferenceSet peReferenceSet) {
        this(headerProcessor, counterRecords.stream().map(StaticCounterSeriesKey::new).collect(Collectors.toList()), (IThrowingSupplier<IBarmanSeekableRecordStreamReader, Exception>)((IThrowingSupplier)() -> (IBarmanSeekableRecordStreamReader)Throwing.closeIfThrows(headerProcessor::createNewRecordStreamInput, (Object)((SeekableInputStream)Throwing.closeIfThrows(SeekableInputStream::new, (Object)new FileInputStream(barmanRawFile), (Closeable[])new Closeable[0])), (Closeable[])new Closeable[0])), (IThrowingFunction<IAnalysisDatabaseWriterStateTracker, IAnalysisWriterFactoryV2, IOException>)((IThrowingFunction)stateTracker -> new AnalysisDatabaseWriterFactoryV2(stateTracker, peReferenceSet, (TIntObjectMap)new TIntObjectHashMap())));
    }

    protected BarmanPassOneTwo(@NonNull IBarmanHeaderProcessor<T> headerProcessor, @NonNull List<@NonNull StaticCounterSeriesKey> staticCounterSeriesKeys, @NonNull IThrowingSupplier<@NonNull IBarmanSeekableRecordStreamReader, Exception> recordStreamInputSupplier, @NonNull IThrowingFunction<@NonNull IAnalysisDatabaseWriterStateTracker, @NonNull IAnalysisWriterFactoryV2, IOException> analysisWriterFactorySupplier) {
        this.recordStreamInputSupplier = recordStreamInputSupplier;
        this.headerProcessor = headerProcessor;
        this.staticCounterSeriesKeys = staticCounterSeriesKeys;
        this.analysisWriterFactorySupplier = analysisWriterFactorySupplier;
    }

    public static @NonNull ByteBuffer doLoad(@NonNull IBarmanSeekableRecordStreamReader dataInput, long offset, int length) throws IOException {
        dataInput.seekFrame(offset);
        return dataInput.readBytes(length);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void process(@NonNull String captureName, @NonNull File apcPath, @NonNull File dbDirectory, @NonNull DeviceTypeCalculator deviceTypeCalculator, @NonNull IWarnings warnings, @NonNull BooleanSupplier interrupted, @NonNull Consumer<@NonNull Exception> errorHandler, @NonNull LongConsumer durationTracker) {
        try {
            Throwable throwable = null;
            Object var10_14 = null;
            try (IBarmanSeekableRecordStreamReader recordStreamInput = (IBarmanSeekableRecordStreamReader)this.recordStreamInputSupplier.get();){
                @NonNull List<@NonNull BarmanFrameAddress> addresses = BarmanRecordStreamProducer.getFrameAddresses(recordStreamInput, this.headerProcessor.createNewCoreAndTimestampFactory(), BarmanFrameAddress::new, arg_0 -> ((IWarnings)warnings).add(arg_0), interrupted);
                if (addresses.isEmpty()) {
                    throw new IOException(AnalysisMessages.NO_DATA_RECEIVED);
                }
                if (!dbDirectory.mkdirs() && !dbDirectory.isDirectory()) {
                    throw new FileNotFoundException(dbDirectory.getAbsolutePath());
                }
                @NonNull HashMap<@NonNull IUniqueProcess, @NonNull Set<@NonNull IUniqueThread>> uniqueThreadsMap = new HashMap<IUniqueProcess, Set<IUniqueThread>>();
                @NonNull ProcessingElementReferenceSet peReferenceSet = new ProcessingElementReferenceSet();
                @NonNull AnalysisDatabaseWriterStateTracker analysisWriterStateTracker = new AnalysisDatabaseWriterStateTracker(dbDirectory, deviceTypeCalculator, this.staticCounterSeriesKeys, Collections.emptySet(), warnings);
                @NonNull TLongObjectHashMap eventStreamAdapters = new TLongObjectHashMap(1, 0.5f, 0L);
                @NonNull IntSupplier uidSupplier = new IntSupplier(){
                    private int uid = 0;

                    @Override
                    public int getAsInt() {
                        return this.uid++;
                    }
                };
                long earliestTimestamp = BarmanPassOneTwo.convertFirstTimestamp(this.headerProcessor, addresses.get((int)0).timestamp);
                long lastTimestamp = this.convertLastTimestamp(this.headerProcessor, addresses);
                long duration = lastTimestamp - earliestTimestamp;
                durationTracker.accept(duration);
                Throwable throwable2 = null;
                Object var26_28 = null;
                try (@NonNull IAnalysisWriterFactoryV2 analysisWriterFactory = (IAnalysisWriterFactoryV2)this.analysisWriterFactorySupplier.apply((Object)analysisWriterStateTracker);){
                    IBarmanRecordFactory<T> recordFactory = this.headerProcessor.createNewRecordFactory();
                    long lastEventStreamAdapterVmUID = 0L;
                    BarmanEventStream eventStreamAdapter = null;
                    for (BarmanFrameAddress addressEntry : addresses) {
                        if (interrupted.getAsBoolean()) {
                            throw new InterruptedException();
                        }
                        if (eventStreamAdapter == null || lastEventStreamAdapterVmUID != addressEntry.vmUID) {
                            eventStreamAdapter = (BarmanEventStream)eventStreamAdapters.get(addressEntry.vmUID);
                            if (eventStreamAdapter == null) {
                                @NonNull IBarmanUniqueThreadTracker barmanUniqueThreadTracker = this.headerProcessor.createBarmanUniqueThreadTrackerFor(addressEntry.vmUID, uniqueThreadsMap, uidSupplier, arg_0 -> ((IWarnings)warnings).add(arg_0));
                                eventStreamAdapter = new BarmanEventStream(addressEntry.vmUID, earliestTimestamp, peReferenceSet, barmanUniqueThreadTracker, this.staticCounterSeriesKeys, arg_0 -> ((IWarnings)warnings).add(arg_0), analysisWriterFactory);
                                eventStreamAdapters.put(addressEntry.vmUID, (Object)eventStreamAdapter);
                            }
                            lastEventStreamAdapterVmUID = addressEntry.vmUID;
                        }
                        @NonNull T record = recordFactory.create(BarmanPassOneTwo.doLoad(recordStreamInput, addressEntry.offset, addressEntry.length));
                        record.process((IBarmanEventStream)eventStreamAdapter);
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                @Nullable SummaryRecord summary = new SummaryRecord(this.headerProcessor.getHeader().getCreatedUnixTimestampSeconds() * 1000000000L, OptionalLong.empty(), OptionalLong.empty());
                @NonNull Map<@NonNull ProcessingElementReference, @NonNull ProcessingElementDescriptor> processingElementProperties = this.headerProcessor.getProcessingElementProperties(peReferenceSet);
                @NonNull List<@NonNull T> staticCounterRecords = this.staticCounterSeriesKeys.stream().map(StaticCounterSeriesKey::getCounterRecord).collect(Collectors.toList());
                boolean alwaysSupportMultipleClusterRewrite = false;
                @NonNull BarmanClustersInfo originalClusterInfo = this.headerProcessor.getHeader().getClustersInfo();
                @NonNull @NonNull @NonNull @NonNull Pair mappedClusterInfo = ClusterInformationRewriter.write((OutputStream)VariableReplacer.getOutPutStream((File)dbDirectory), staticCounterRecords, (boolean)false, (IClustersInfo)originalClusterInfo, (ProcessingElementReferenceSet)peReferenceSet, processingElementProperties);
                @NonNull @NonNull List sortedCpuList = (List)mappedClusterInfo.first;
                @NonNull IClustersInfo clusterInfo = (IClustersInfo)mappedClusterInfo.second;
                analysisWriterStateTracker.writeState(peReferenceSet, (TLongObjectMap)eventStreamAdapters, uniqueThreadsMap, duration, captureName, false, sortedCpuList, processingElementProperties, clusterInfo, (TLongObjectMap)new TLongObjectHashMap());
                SummaryWriter.write((File)apcPath, (long)duration, (SummaryRecord)summary, Collections.emptyMap(), (TLongObjectMap)new TLongObjectHashMap(0, 0.0f, 0L), processingElementProperties, Collections.emptySet());
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (InterruptedIOException | InterruptedException | ClosedByInterruptException exception) {
        }
        catch (BufferUnderflowException e) {
            errorHandler.accept(new RuntimeException(BarmanMessages.TRUNCATED_SAMPLE_RECORD, e));
        }
        catch (Exception e) {
            errorHandler.accept(e);
        }
    }

    private long convertLastTimestamp(@NonNull IBarmanHeaderProcessor<T> headerProcessor, @NonNull List<@NonNull BarmanFrameAddress> addresses) {
        int size = addresses.size();
        int i = size - 1;
        while (i >= 0) {
            long rawTimestamp = addresses.get((int)i).timestamp;
            if (rawTimestamp != -1L) {
                return headerProcessor.convertTimestampToNs(rawTimestamp);
            }
            --i;
        }
        return 0L;
    }

    private static long convertFirstTimestamp(@NonNull IBarmanHeaderProcessor<?> headerProcessor, long rawTimestamp) {
        if (rawTimestamp == -1L) {
            return 0L;
        }
        return headerProcessor.convertTimestampToNs(rawTimestamp);
    }

    public static final class BarmanFrameAddress
    implements Comparable<BarmanFrameAddress> {
        public final int length;
        public final long offset;
        public final long timestamp;
        public final long vmUID;

        public BarmanFrameAddress(long vmUID, long timestamp, long offset, int length) {
            this.vmUID = vmUID;
            this.timestamp = timestamp;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public int compareTo(BarmanFrameAddress o) {
            int result = Long.compare(this.timestamp, o.timestamp);
            if (result != 0) {
                return result;
            }
            return Long.compare(this.offset, o.offset);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof BarmanFrameAddress) {
                BarmanFrameAddress that = (BarmanFrameAddress)obj;
                return this.vmUID == that.vmUID && this.timestamp == that.timestamp && this.offset == that.offset && this.length == that.length;
            }
            return false;
        }

        public int hashCode() {
            return Long.hashCode(this.offset);
        }

        public String toString() {
            return String.format("BarmanFrameAddress [vmUID=%s, timestamp=%s, offset=%s, length=%s]", this.vmUID, this.timestamp, this.offset, this.length);
        }
    }
}

