/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman;

import com.arm.streamline.barman.BarmanDataError;
import com.arm.streamline.barman.BarmanTypeAndVersion;
import com.arm.streamline.barman.IBarmanHeader;
import com.arm.streamline.barman.recordstream.IBarmanRecord;
import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class BarmanRecordListAndHeader {
    private byte @NonNull [] header;
    private @NonNull List<byte @NonNull []> records;
    private @NonNull BarmanTypeAndVersion typeAndVersion;

    public BarmanRecordListAndHeader(byte @NonNull [] header, @NonNull BarmanTypeAndVersion typeAndVersion, @NonNull List<byte @NonNull []> records) {
        this.header = header;
        this.typeAndVersion = typeAndVersion;
        this.records = records;
    }

    public byte @NonNull [] getHeader() {
        return this.header;
    }

    public @NonNull List<byte @NonNull []> getRecords() {
        return this.records;
    }

    public @NonNull IBarmanHeader<IBarmanRecord> getHeader(@NonNull Map<Integer, ProcessorPmu> pmus, @NonNull Events events) throws IOException, BarmanDataError {
        return this.typeAndVersion.getHeader(pmus, events, new ByteArrayInputStream(this.header, 12, this.header.length - 12));
    }

    public boolean isBigEndian() {
        return this.typeAndVersion.isBigEndian();
    }

    public boolean isBits64() {
        return this.typeAndVersion.isBits64();
    }
}

