/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.database.stream.factory.DatabaseLayout;
import com.arm.streamline.analysis.model.DeviceTypeCalculator;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.barman.BarmanDurationTracker;
import com.arm.streamline.barman.IBarmanHeader;
import com.arm.streamline.barman.IBarmanHeaderProcessor;
import com.arm.streamline.barman.pass_one_two.BarmanPassOneTwo;
import com.arm.streamline.barman.recordstream.IBarmanRecord;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.model.warnings.IWarnings;
import com.arm.streamline.common.model.warnings.Warnings;
import com.arm.streamline.model.session.SessionImage;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;

public final class BarmanPassOneTwoProcessor
extends AnalysisBase {
    private final @NonNull BarmanDurationTracker durationTracker;
    private final @NonNull IBarmanHeaderProcessor<IBarmanRecord> headerProcessor;
    private final @NonNull File barmanRawFile;
    private final @NonNull File apcDirectory;
    private final @NonNull DeviceTypeCalculator deviceTypeCalculator;
    private final @NonNull List<@NonNull SessionImage> imageList;
    private final @NonNull ProcessingElementReferenceSet peReferenceSet;

    public BarmanPassOneTwoProcessor(@NonNull IBarmanHeaderProcessor<IBarmanRecord> headerProcessor, @NonNull File apcDirectory, @NonNull File barmanRawFile, @NonNull BarmanDurationTracker durationTracker, @NonNull DeviceTypeCalculator deviceTypeCalculator, @NonNull SessionProcessor sessionProcessor, @NonNull List<@NonNull SessionImage> imageList) {
        super(sessionProcessor);
        this.apcDirectory = apcDirectory;
        this.deviceTypeCalculator = deviceTypeCalculator;
        this.imageList = imageList;
        this.headerProcessor = headerProcessor;
        this.barmanRawFile = barmanRawFile;
        this.durationTracker = durationTracker;
        this.peReferenceSet = new ProcessingElementReferenceSet();
        sessionProcessor.setShowProcesses(headerProcessor.shouldShowProcesses());
        this.setName("Barman Database", barmanRawFile.getName());
        this.setPriorityLower();
        this.start();
    }

    @Override
    protected void process() {
        @NonNull File dbDirectory = DatabaseLayout.getDatabaseRoot((File)this.apcDirectory);
        @NonNull File imagesDirectory = new File(this.apcDirectory, "images");
        @NonNull IBarmanHeader<IBarmanRecord> header = this.headerProcessor.getHeader();
        @NonNull List<@NonNull CounterRecord> counterRecordList = header.getCounters().getCounterRecords();
        @NonNull IBarmanHeaderProcessor<IBarmanRecord> headerProcessor = header.createNewHeaderProcessor(BarmanPassOneTwoProcessor.imageMap(imagesDirectory, this.imageList));
        @NonNull BarmanPassOneTwo<IBarmanRecord> passOneTwo = new BarmanPassOneTwo<IBarmanRecord>(this.barmanRawFile, headerProcessor, counterRecordList, this.peReferenceSet);
        @NonNull Warnings warnings = new Warnings();
        @NonNull BooleanSupplier interrupted = Thread.currentThread()::isInterrupted;
        @NonNull Consumer<@NonNull Exception> errorHandler = this::error;
        passOneTwo.process(header.getTargetDescription(), this.apcDirectory, dbDirectory, this.deviceTypeCalculator, (IWarnings)warnings, interrupted, errorHandler, this.durationTracker::updateDuration);
    }

    private static @NonNull Map<@NonNull String, @NonNull File> imageMap(@NonNull File imageDirectory, @NonNull List<@NonNull SessionImage> list) {
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        @NonNull HashMap<@NonNull String, @NonNull File> result = new HashMap<String, File>();
        for (SessionImage image : list) {
            File imageFile = new File(imageDirectory, image.getImageName());
            if (!imageFile.isFile()) continue;
            result.put(imageFile.getName(), imageFile.getAbsoluteFile());
        }
        return result;
    }
}

