/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman;

import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class BarmanDurationTracker {
    private static final String TAG_BARMAN = "barman";
    private static final String ATTR_DURATION = "duration";
    private long durationInNanosecs;
    private final @NonNull File outputFile;

    public BarmanDurationTracker(@NonNull File outputFile) {
        this.outputFile = outputFile;
        this.load();
    }

    public long getDurationInNanosecs() {
        return this.durationInNanosecs;
    }

    public void save() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (XMLGenerator generator = XMLGenerator.create((File)this.outputFile);){
                generator.startDocument();
                generator.startTag(TAG_BARMAN);
                generator.addAttribute(ATTR_DURATION, this.durationInNanosecs);
                generator.endTag();
                generator.endDocument();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            this.outputFile.delete();
        }
    }

    public void updateDuration(long durationInNanosecs) {
        this.durationInNanosecs = Math.max(this.durationInNanosecs, durationInNanosecs);
    }

    private void load() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (XMLParser xml = XMLParser.create((File)this.outputFile);){
                String tag;
                while ((tag = xml.nextTag()) != null) {
                    if (TAG_BARMAN.equals(tag)) {
                        this.durationInNanosecs = xml.getLongAttribute(ATTR_DURATION, 0L);
                        break;
                    }
                    xml.skip();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

