/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman;

import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.barman.BarmanDurationTracker;
import com.arm.streamline.barman.BarmanPassOneTwoProcessor;
import com.arm.streamline.barman.IBarmanHeaderProcessor;
import com.arm.streamline.barman.recordstream.IBarmanRecord;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.databrowser.AbstractDatabaseGenerator;
import com.arm.streamline.databrowser.ICaptureProxy;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.protocol.misc.AttachedApkEntries;
import com.arm.streamline.report.model.topology.IClustersInfo;
import java.io.File;
import org.eclipse.jdt.annotation.NonNull;

public class BarmanDatabaseGenerator
extends AbstractDatabaseGenerator {
    private final @NonNull File mBarmanRawFile;
    private final @NonNull BarmanDurationTracker mDurationTracker;
    private final @NonNull IBarmanHeaderProcessor<IBarmanRecord> mHeaderProcessor;

    public BarmanDatabaseGenerator(@NonNull IBarmanHeaderProcessor<IBarmanRecord> headerProcessor, @NonNull File barmanRawFile, @NonNull BarmanDurationTracker durationTracker) {
        this.mHeaderProcessor = headerProcessor;
        this.mBarmanRawFile = barmanRawFile;
        this.mDurationTracker = durationTracker;
    }

    @Override
    protected void processRecords(IAnalysisInputSettings analysisSettings, boolean generateSpeSampleLog, String capturePath, ICaptureDetails captureDetails, IClustersInfo clustersInfo, SessionProcessor sessionProcessor, ICaptureProxy proxy, @NonNull IAnalysisHandler handler, @NonNull AttachedApkEntries attachedApkEntries) throws Exception {
        File apcDirectory = new File(capturePath);
        BarmanPassOneTwoProcessor pass = new BarmanPassOneTwoProcessor(this.mHeaderProcessor, apcDirectory, this.mBarmanRawFile, this.mDurationTracker, captureDetails.createDeviceTypeCalculator(), sessionProcessor, analysisSettings.getImages());
        this.checkError();
        pass.join();
        this.checkError();
    }
}

