/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.application.preferences;

import com.arm.streamline.application.PluginVersion;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.application.StreamlineTheme;
import com.arm.streamline.application.preferences.IPreferences;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.preferences.CommonPreferences;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.databrowser.ElfImage;
import com.arm.streamline.model.session.PathWithEnabledFlag;
import com.arm.utils.NullChecking;
import com.arm.utils.Platform;
import com.arm.utils.function.IBooleanConsumer;
import com.arm.utils.io.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;

public class StreamlinePreferences {
    public static final String ADB_PATH = "com.arm.streamline.adb.path";
    public static final String CAPTURE_DATA_LOCATIONS = "com.arm.streamline.dataLocations";
    public static final String MGD_KEEP_TRACING = "com.arm.streamline.mgd.keep_tracing";
    public static final String MGD_PATH = "com.arm.streamline.mgd.executable";
    public static final String SHOW_DELETE_CONFIRM_DIALOG = "com.arm.streamline.show_delete_confirm_dialog";
    public static final String SHOW_DELETE_TEMPLATE_CONFIRM_DIALOG = "com.arm.streamline.show_delete_template_confirm_dialog";
    public static final String SHOW_GATORKO_IN_USE_WARN_DIALOG = "com.arm.streamline.show_gatorko_in_use_warn_dialog";
    public static final String SHOW_PROC_IN_USE_WARN_DIALOG = "com.arm.streamline.show_proc_in_use_warn_dialog";
    public static final String SHOW_REMOVE_CHART_CONFIRM_DIALOG = "com.arm.streamline.show_remove_chart_confirm_dialog";
    public static final String SHOW_REMOVE_SERIES_CONFIRM_DIALOG = "com.arm.streamline.show_remove_series_confirm_dialog";
    public static final String SHOW_RM_UNSAVED_CHARTS_STOP_CAPTURE_DIALOG = "com.arm.streamline.show_rm_unsaved_charts_dialog";
    public static final String THEME_ID = "com.arm.streamline.theme_id";
    public static final String USE_NEW_BACKEND = "com.arm.streamline.use_dbv3_backend";
    public static final String USE_SYNCHRONIZED_ITM_STREAMS = "com.arm.streamline.baremetal.itm.use_synchronized_stream";
    private static @Nullable Preferences appPreferences = null;
    private static final String AUTH_CACHE = "com.arm.streamline.auth_cache";
    private static final String CONTINUE_WITH_FALLBACK_LICENSE = "com.arm.streamline.continue_with_fallback_license";
    private static final String CURRENT_APPLICATION_VERSION = "com.arm.streamline.current_version";
    private static final String EXPIRY_DATE_MESSAGE_LOCALDATE = "com.arm.streamline.expiry_date_message_localdate";
    private static final String FIRST_RUN = "com.arm.streamline.first_run";
    private static final String LAST_CONNECTION_BROWSER_SETTINGS = "com.arm.streamline.last_connection_browser_settings";
    private static final String LAST_PROGRAM_IMAGES_DIALOG_SETTINGS = "com.arm.streamline.last_program_images_dialog_settings";
    private static final String LAST_TARGET_TYPE_BROWSER_SETTINGS = "com.arm.streamline.last_target_type_browser_settings";
    private static final String OPTIONS_IMAGES_KEY = "com.arm.streamline.images";
    private static final String RETRIEVE_IMAGES = "com.arm.streamline.retrieve_images";
    private static final String SESSION_PREF_KEY = "Streamline.Session";
    private static final String SNIPPET_CONFIGURATION = "com.arm.streamline.snippet_configuration";
    private static final String TARGET_SETUP_SCRIPT_PATH = "com.arm.streamline.target_setup_script_path";
    private static final String LAST_TEMPLATE_INSTALL_LOAD_PATH = "com.arm.streamline.last_template_install_load_path";

    public static @Nullable Path getAndroidHomePath() {
        Path platformDefaultAndroidHome;
        String androidHomeEnv = System.getenv("ANDROID_HOME");
        if (androidHomeEnv != null && !androidHomeEnv.isBlank()) {
            return Path.of(androidHomeEnv, new String[0]);
        }
        String homeDirectory = System.getProperty("user.home");
        if (homeDirectory == null) {
            return null;
        }
        switch (Platform.getPlatform()) {
            case LINUX: {
                Path path = Paths.get(homeDirectory, "Android", "Sdk");
                break;
            }
            case WINDOWS: {
                Path path = Paths.get(homeDirectory, "Local", "Android", "sdk");
                break;
            }
            case MACINTOSH: {
                Path path = Paths.get(homeDirectory, "Library", "Android", "sdk");
                break;
            }
            case UNKNOWN: {
                Path path = null;
                break;
            }
            default: {
                Path path = platformDefaultAndroidHome = null;
            }
        }
        if (platformDefaultAndroidHome != null && Files.isDirectory(platformDefaultAndroidHome, new LinkOption[0])) {
            return platformDefaultAndroidHome;
        }
        return null;
    }

    public static @Nullable File getDefaultAdbPath() {
        File adbPath = CommonFileUtils.findExecutableOnPath((String)"adb");
        if (adbPath != null) {
            return adbPath;
        }
        Path androidHome = StreamlinePreferences.getAndroidHomePath();
        if (androidHome == null || !Files.isDirectory(androidHome, new LinkOption[0])) {
            return null;
        }
        Path platformTools = Paths.get(androidHome.toString(), "platform-tools");
        if (!Files.isDirectory(platformTools, new LinkOption[0])) {
            return null;
        }
        return CommonFileUtils.findExecutableIn((String)"adb", Arrays.asList(platformTools.toAbsolutePath().toString()));
    }

    public static final void cycleTheme() {
        StreamlineTheme theme = StreamlinePreferences.getTheme().next();
        StreamlinePreferences.getPreferenceStore().setValue(THEME_ID, theme.name());
    }

    public static @NonNull Set<ElfImage> deserializeImagesFromString(@Nullable String fromString) throws AssertionError {
        @NonNull HashSet<ElfImage> images = new HashSet<ElfImage>();
        if (fromString != null && !fromString.equals("")) {
            String[] entries = fromString.split(";");
            @Nullable ElfImage image = null;
            String[] stringArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                if (entry.startsWith("img:")) {
                    image = new ElfImage(new File(entry.substring(4)));
                    images.add(image);
                } else if (entry.startsWith("dbg:") && image != null) {
                    image.setSeparateDebugDir(new File(entry.substring(4)));
                } else {
                    throw new AssertionError();
                }
                ++n2;
            }
        }
        return images;
    }

    public static synchronized @NonNull IPreferences getApplicationPreferences() {
        if (appPreferences == null) {
            appPreferences = new Preferences();
        }
        return (IPreferences)NullChecking.neverNull((Object)appPreferences);
    }

    public static final String getAuthCache() {
        return StreamlinePreferences.getPreferenceStore().getString(AUTH_CACHE);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull List<@NonNull File> getDataLocations() {
        if (StreamlinePlugin.getInstance() != null) {
            IPreferenceStore defaultPreferenceStore = StreamlinePreferences.getPreferenceStore();
            @NonNull String locationsString = (String)NullChecking.neverNull((Object)defaultPreferenceStore.getString(CAPTURE_DATA_LOCATIONS));
            @NonNull Set uniquePaths = Arrays.stream(locationsString.split(File.pathSeparator)).map(s -> FileUtils.canonicalise((File)new File((String)s))).collect(Collectors.toCollection(LinkedHashSet::new));
            return Collections.unmodifiableList(new ArrayList(uniquePaths));
        }
        return Collections.emptyList();
    }

    public static @NonNull Set<ElfImage> getDefaultImages() {
        String fromString = StreamlinePreferences.getPreferenceStore().getString(OPTIONS_IMAGES_KEY);
        return StreamlinePreferences.deserializeImagesFromString(fromString);
    }

    public static final IDialogSettings getLastConnectionBrowserSettings() {
        return StreamlinePreferences.settingsFromString(StreamlinePreferences.getPreferenceStore().getString(LAST_CONNECTION_BROWSER_SETTINGS));
    }

    public static final @Nullable LocalDate getHideLicenseExpiryWarningLicenseExpirationDate() {
        long value = StreamlinePreferences.getPreferenceStore().getLong(EXPIRY_DATE_MESSAGE_LOCALDATE);
        if (value == 0L) {
            return null;
        }
        return LocalDate.ofEpochDay(value);
    }

    public static final boolean getContinueWithFallbackLicense() {
        return StreamlinePreferences.getPreferenceStore().getBoolean(CONTINUE_WITH_FALLBACK_LICENSE);
    }

    public static final IDialogSettings getLastProgramImagesDialogSettings() {
        return StreamlinePreferences.settingsFromString(StreamlinePreferences.getPreferenceStore().getString(LAST_PROGRAM_IMAGES_DIALOG_SETTINGS));
    }

    public static final IDialogSettings getLastTargetTypeBrowserSettings() {
        return StreamlinePreferences.settingsFromString(StreamlinePreferences.getPreferenceStore().getString(LAST_TARGET_TYPE_BROWSER_SETTINGS));
    }

    public static final boolean getRetrieveImages() {
        return StreamlinePreferences.getPreferenceStore().getBoolean(RETRIEVE_IMAGES);
    }

    public static final String getSession() {
        return StreamlinePreferences.getPreferenceStore().getString(SESSION_PREF_KEY);
    }

    public static final String getSnippetConfiguration() {
        return StreamlinePreferences.getPreferenceStore().getString(SNIPPET_CONFIGURATION);
    }

    public static final String getTargetSetupScriptPath() {
        return StreamlinePreferences.getPreferenceStore().getString(TARGET_SETUP_SCRIPT_PATH);
    }

    public static final StreamlineTheme getTheme() {
        return StreamlineTheme.get(StreamlinePreferences.getPreferenceStore().getString(THEME_ID));
    }

    public static final void initialize() {
        IPreferenceStore sp = StreamlinePreferences.getPreferenceStore();
        sp.setDefault(SHOW_DELETE_CONFIRM_DIALOG, true);
        sp.setDefault(SHOW_RM_UNSAVED_CHARTS_STOP_CAPTURE_DIALOG, true);
        sp.setDefault(SHOW_DELETE_TEMPLATE_CONFIRM_DIALOG, true);
        sp.setDefault(SHOW_REMOVE_CHART_CONFIRM_DIALOG, true);
        sp.setDefault(SHOW_REMOVE_SERIES_CONFIRM_DIALOG, true);
        sp.setDefault(SHOW_GATORKO_IN_USE_WARN_DIALOG, true);
        sp.setDefault(SHOW_PROC_IN_USE_WARN_DIALOG, true);
        sp.setDefault(THEME_ID, StreamlineTheme.DARK.name());
        sp.setDefault(SNIPPET_CONFIGURATION, "");
        sp.setDefault(LAST_CONNECTION_BROWSER_SETTINGS, "");
        sp.setDefault(LAST_TARGET_TYPE_BROWSER_SETTINGS, "");
        sp.setDefault(LAST_PROGRAM_IMAGES_DIALOG_SETTINGS, "");
        sp.setDefault(AUTH_CACHE, "");
        sp.setDefault(RETRIEVE_IMAGES, false);
        sp.setDefault(TARGET_SETUP_SCRIPT_PATH, "");
        sp.setDefault(CONTINUE_WITH_FALLBACK_LICENSE, false);
        sp.setDefault(CAPTURE_DATA_LOCATIONS, CommonPreferences.getDefaultDocumentPath());
        sp.setDefault(ADB_PATH, "");
        sp.setDefault(MGD_PATH, "");
        sp.setDefault(USE_SYNCHRONIZED_ITM_STREAMS, true);
        sp.setDefault(USE_NEW_BACKEND, true);
        sp.setDefault(LAST_TEMPLATE_INSTALL_LOAD_PATH, System.getProperty("user.home", "."));
        CommonPreferences.getPreferenceStore();
    }

    public static boolean isApplicationVersionUpToDate() {
        @NonNull IPreferenceStore prefStore = StreamlinePreferences.getPreferenceStore();
        @Nullable String currentVersion = prefStore.getString(CURRENT_APPLICATION_VERSION);
        @NonNull PluginVersion pluginVersion = StreamlinePlugin.getVersion();
        @NonNull String version = pluginVersion.getVersionIdentifier();
        if (currentVersion != null && version.equals(currentVersion)) {
            return true;
        }
        prefStore.setValue(CURRENT_APPLICATION_VERSION, version);
        return false;
    }

    public static boolean isFirstRun() {
        @NonNull IPreferenceStore prefStore = StreamlinePreferences.getPreferenceStore();
        @Nullable String value = prefStore.getString(FIRST_RUN);
        if (value == null || value.isEmpty()) {
            prefStore.setValue(FIRST_RUN, "no");
            return true;
        }
        return false;
    }

    public static String makeFilteredPathsString(@NonNull List<@NonNull PathWithEnabledFlag> paths, boolean b) {
        return paths.stream().filter(p -> p.isUsed() == b).map(p -> p.getFile().getAbsolutePath()).collect(Collectors.joining(File.pathSeparator));
    }

    public static @NonNull String serializeImagesToString(Set<ElfImage> images) {
        StringBuilder builder = new StringBuilder();
        for (ElfImage image : images) {
            builder.append("img:");
            builder.append(image.getFile().toString());
            builder.append(';');
            @Nullable File separateDebugDir = image.getSeparateDebugDir();
            if (separateDebugDir == null) continue;
            builder.append("dbg:");
            builder.append(separateDebugDir.toString());
            builder.append(';');
        }
        return (String)NullChecking.neverNull((Object)builder.toString());
    }

    public static final void setAuthCache(String cache) {
        StreamlinePreferences.getPreferenceStore().setValue(AUTH_CACHE, cache);
    }

    public static void setDataLocations(@NonNull List<@NonNull File> watchSet) {
        Set orderedSet = watchSet.stream().map(f -> FileUtils.canonicalise((File)f).getAbsolutePath()).collect(Collectors.toCollection(LinkedHashSet::new));
        String dataLocations = orderedSet.stream().collect(Collectors.joining(File.pathSeparator));
        StreamlinePreferences.getPreferenceStore().setValue(CAPTURE_DATA_LOCATIONS, dataLocations);
    }

    public static void setDefaultImages(@NonNull Set<ElfImage> images) {
        String string = StreamlinePreferences.serializeImagesToString(images);
        StreamlinePreferences.getPreferenceStore().setValue(OPTIONS_IMAGES_KEY, string);
    }

    public static final void setLastConnectionBrowserSettings(IDialogSettings settings) {
        StreamlinePreferences.getPreferenceStore().setValue(LAST_CONNECTION_BROWSER_SETTINGS, StreamlinePreferences.settingsToString(settings));
    }

    public static final void setHideLicenseExpiryWarningLicenseExpirationDate(@Nullable LocalDate expiryDate) {
        StreamlinePreferences.getPreferenceStore().setValue(EXPIRY_DATE_MESSAGE_LOCALDATE, expiryDate != null ? expiryDate.toEpochDay() : 0L);
    }

    public static final void setContinueWithFallbackLicense(boolean value) {
        StreamlinePreferences.getPreferenceStore().setValue(CONTINUE_WITH_FALLBACK_LICENSE, value);
    }

    public static final void setLastProgramImagesDialogSettings(IDialogSettings settings) {
        StreamlinePreferences.getPreferenceStore().setValue(LAST_PROGRAM_IMAGES_DIALOG_SETTINGS, StreamlinePreferences.settingsToString(settings));
    }

    public static final void setLastTargetTypeBrowserSettings(IDialogSettings settings) {
        StreamlinePreferences.getPreferenceStore().setValue(LAST_TARGET_TYPE_BROWSER_SETTINGS, StreamlinePreferences.settingsToString(settings));
    }

    public static final void setRetrieveImages(boolean enabled) {
        StreamlinePreferences.getPreferenceStore().setValue(RETRIEVE_IMAGES, enabled);
    }

    public static void setSession(String sessionString) {
        StreamlinePreferences.getPreferenceStore().setValue(SESSION_PREF_KEY, sessionString);
    }

    public static final void setShowDeleteConfirmDialog(boolean show) {
        StreamlinePreferences.getPreferenceStore().setValue(SHOW_DELETE_CONFIRM_DIALOG, show);
    }

    public static final void setShowDeleteTemplateConfirmDialog(boolean show) {
        StreamlinePreferences.getPreferenceStore().setValue(SHOW_DELETE_TEMPLATE_CONFIRM_DIALOG, show);
    }

    public static final void setShowGatorKoWarnDialog(boolean show) {
        StreamlinePreferences.getPreferenceStore().setValue(SHOW_GATORKO_IN_USE_WARN_DIALOG, show);
    }

    public static final void setShowProcWarnDialog(boolean show) {
        StreamlinePreferences.getPreferenceStore().setValue(SHOW_PROC_IN_USE_WARN_DIALOG, show);
    }

    public static final void setShowRemoveChartConfirmDialog(boolean show) {
        StreamlinePreferences.getPreferenceStore().setValue(SHOW_REMOVE_CHART_CONFIRM_DIALOG, show);
    }

    public static final void setShowRemoveSeriesConfirmDialog(boolean show) {
        StreamlinePreferences.getPreferenceStore().setValue(SHOW_REMOVE_SERIES_CONFIRM_DIALOG, show);
    }

    public static final void setShowRemoveUnSavedChartConfirmDialog(boolean show) {
        StreamlinePreferences.getPreferenceStore().setValue(SHOW_RM_UNSAVED_CHARTS_STOP_CAPTURE_DIALOG, show);
    }

    public static final void setSnippetConfiguration(String value) {
        StreamlinePreferences.getPreferenceStore().setValue(SNIPPET_CONFIGURATION, value);
    }

    public static final void setTargetSetupScriptPath(String path) {
        StreamlinePreferences.getPreferenceStore().setValue(TARGET_SETUP_SCRIPT_PATH, path);
    }

    public static final boolean showDeleteConfirmDialog() {
        return StreamlinePreferences.getPreferenceStore().getBoolean(SHOW_DELETE_CONFIRM_DIALOG);
    }

    public static final boolean showDeleteTemplateConfirmDialog() {
        return StreamlinePreferences.getPreferenceStore().getBoolean(SHOW_DELETE_TEMPLATE_CONFIRM_DIALOG);
    }

    public static final boolean showGatorkoWarnDialog() {
        return StreamlinePreferences.getPreferenceStore().getBoolean(SHOW_GATORKO_IN_USE_WARN_DIALOG);
    }

    public static final boolean showProcWarnDialog() {
        return StreamlinePreferences.getPreferenceStore().getBoolean(SHOW_PROC_IN_USE_WARN_DIALOG);
    }

    public static final boolean showRemoveChartConfirmDialog() {
        return StreamlinePreferences.getPreferenceStore().getBoolean(SHOW_REMOVE_CHART_CONFIRM_DIALOG);
    }

    public static final boolean showRemoveSeriesConfirmDialog() {
        return StreamlinePreferences.getPreferenceStore().getBoolean(SHOW_REMOVE_SERIES_CONFIRM_DIALOG);
    }

    public static final boolean showRemoveUnsavedChartConfirmDialog() {
        return StreamlinePreferences.getPreferenceStore().getBoolean(SHOW_RM_UNSAVED_CHARTS_STOP_CAPTURE_DIALOG);
    }

    public static final void watchNewNativeBackendProperty(@NonNull IBooleanConsumer observer) {
        IPreferenceStore prefStore = StreamlinePreferences.getPreferenceStore();
        prefStore.addPropertyChangeListener(event -> {
            if (USE_NEW_BACKEND.contentEquals(event.getProperty())) {
                observer.accept(Boolean.valueOf(event.getNewValue().toString()).booleanValue());
            }
        });
        observer.accept(prefStore.getBoolean(USE_NEW_BACKEND));
    }

    public static String lastTemplateInstallLoadPath() {
        return StreamlinePreferences.getPreferenceStore().getString(LAST_TEMPLATE_INSTALL_LOAD_PATH);
    }

    public static void setLastTemplateInstallLoadPath(@NonNull String value) {
        StreamlinePreferences.getPreferenceStore().setValue(LAST_TEMPLATE_INSTALL_LOAD_PATH, value);
    }

    private static final IDialogSettings settingsFromString(String text) {
        DialogSettings settings = new DialogSettings("prefs");
        if (text != null && !text.isEmpty()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8)));){
                    settings.load((Reader)reader);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
        return settings;
    }

    private static final String settingsToString(IDialogSettings settings) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter(baos);){
                settings.save((Writer)writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            CommonPlugin.error((Throwable)exception);
            return "";
        }
        try {
            return baos.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException uee) {
            CommonPlugin.error((Throwable)uee);
            return "";
        }
    }

    public static @NonNull IPreferenceStore getPreferenceStore() {
        @NonNull StreamlinePlugin instance = (StreamlinePlugin)((Object)NullChecking.neverNull((Object)((Object)StreamlinePlugin.getInstance())));
        return (IPreferenceStore)NullChecking.neverNull((Object)instance.getPreferenceStore());
    }

    static class Preferences
    implements IPreferences {
        Preferences() {
        }

        @Override
        public @Nullable File getAdbPath() {
            String pref = StreamlinePreferences.getPreferenceStore().getString(StreamlinePreferences.ADB_PATH);
            if (pref == null || pref.isEmpty()) {
                return null;
            }
            return new File(pref);
        }

        @Override
        public @Nullable File getAdbPathOrDefault() {
            File adbPath = this.getAdbPath();
            if (adbPath != null && adbPath.isFile() && adbPath.canExecute()) {
                return adbPath;
            }
            return StreamlinePreferences.getDefaultAdbPath();
        }

        @Override
        public Path getMgdExecutable() {
            return Paths.get(StreamlinePreferences.getPreferenceStore().getString(StreamlinePreferences.MGD_PATH), new String[0]);
        }

        @Override
        public boolean getMgdKeepTracing() {
            return StreamlinePreferences.getPreferenceStore().getBoolean(StreamlinePreferences.MGD_KEEP_TRACING);
        }

        @Override
        public boolean importItmAsSychronizedTrace() {
            return StreamlinePreferences.getPreferenceStore().getBoolean(StreamlinePreferences.USE_SYNCHRONIZED_ITM_STREAMS);
        }

        @Override
        public void setAdbPath(String adbPath) {
            StreamlinePreferences.getPreferenceStore().setValue(StreamlinePreferences.ADB_PATH, adbPath);
        }

        @Override
        public void setMgdExecutable(Path executable) {
            StreamlinePreferences.getPreferenceStore().setValue(StreamlinePreferences.MGD_PATH, executable.toString());
        }

        @Override
        public void setMgdKeepTracing(boolean mgdKeepTracing) {
            StreamlinePreferences.getPreferenceStore().setValue(StreamlinePreferences.MGD_KEEP_TRACING, mgdKeepTracing);
        }
    }
}

