/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.application.preferences;

import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.application.preferences.FileEditor;
import com.arm.streamline.application.preferences.MgdDirectoryEditor;
import com.arm.streamline.application.preferences.PreferencesMessages;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.util.Platform;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ExternalToolsPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static @NonNull String ID = "com.arm.streamline.application.preferences.mgdPage";
    public static boolean DISABLE_MGD_INTEGRATION = true;

    public ExternalToolsPage() {
        super(1);
        this.setPreferenceStore(StreamlinePlugin.getInstance().getPreferenceStore());
        this.setDescription(PreferencesMessages.EXTERNAL_TOOLS_PAGE_DESCRIPTION);
    }

    public void init(IWorkbench workbench) {
    }

    private void addPathEditor(String name, String labelText, String tooltipText, String watermarkText, Composite parent) {
        FileEditor editor = new FileEditor(name, labelText, parent);
        Label label = editor.getLabelControl(parent);
        Text text = editor.getTextControl(parent);
        label.setToolTipText(tooltipText);
        text.setToolTipText(tooltipText);
        editor.setWatermark(watermarkText);
        this.addField((FieldEditor)editor);
    }

    private void addMgdMacPathEditor(String name, String labelText, String tooltipText, String watermarkText, Composite parent) {
        MgdDirectoryEditor editor = new MgdDirectoryEditor(name, labelText, parent);
        Label label = editor.getLabelControl(parent);
        Text text = editor.getTextControl(parent);
        label.setToolTipText(tooltipText);
        text.setToolTipText(tooltipText);
        editor.setWatermark(watermarkText);
        this.addField((FieldEditor)editor);
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.addPathEditor("com.arm.streamline.adb.path", DocumentsMessages.ADB_PATH, DocumentsMessages.ADB_PATH_TOOLTIP, DocumentsMessages.ADB_PATH_PROVIDE, parent);
        if (DISABLE_MGD_INTEGRATION) {
            return;
        }
        if (Platform.isMac()) {
            this.addMgdMacPathEditor("com.arm.streamline.mgd.executable", DocumentsMessages.MGD_MODE_INSTALLATION_DIR_LABEL, DocumentsMessages.BROWSE_MGD_TOOLTIP, DocumentsMessages.MGD_PATH_PROVIDE, parent);
        } else {
            this.addPathEditor("com.arm.streamline.mgd.executable", DocumentsMessages.MGD_MODE_INSTALLATION_DIR_LABEL, DocumentsMessages.BROWSE_MGD_TOOLTIP, DocumentsMessages.MGD_PATH_PROVIDE, parent);
        }
        BooleanFieldEditor editor = new BooleanFieldEditor("com.arm.streamline.mgd.keep_tracing", DocumentsMessages.MGD_MODE_CONTINUE_TRACING_CHECKBOX_TEXT, parent);
        editor.getDescriptionControl(parent).setToolTipText(DocumentsMessages.MGD_MODE_CONTINUE_TRACING_CHECKBOX_TOOLTIP);
        this.addField((FieldEditor)editor);
    }
}

