/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.application.actions;

import com.arm.streamline.application.actions.ActionsMessages;
import com.arm.streamline.common.CommonPlugin;
import java.lang.reflect.Method;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class MemoryMonitorAction
extends Action
implements IPropertyChangeListener,
DisposeListener {
    public static final String ID = "com.arm.streamline.preferences.memory_monitor";

    private static boolean showMemoryMonitor() {
        return PlatformUI.getPreferenceStore().getBoolean("SHOW_MEMORY_MONITOR");
    }

    public MemoryMonitorAction() {
        super(ActionsMessages.MEMORY_MONITOR);
        this.setChecked(MemoryMonitorAction.showMemoryMonitor());
        this.setId(ID);
        PlatformUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("SHOW_MEMORY_MONITOR".equals(event.getProperty())) {
            this.setChecked(MemoryMonitorAction.showMemoryMonitor());
        }
    }

    public void run() {
        this.setShowMemoryMonitor(!MemoryMonitorAction.showMemoryMonitor());
    }

    public void syncWorkbench() {
        this.syncWorkbench(MemoryMonitorAction.showMemoryMonitor());
    }

    public void widgetDisposed(DisposeEvent event) {
        if (!PlatformUI.getWorkbench().isClosing()) {
            this.setShowMemoryMonitor(false);
        }
    }

    private void setShowMemoryMonitor(boolean show) {
        PlatformUI.getPreferenceStore().setValue("SHOW_MEMORY_MONITOR", show);
        this.syncWorkbench(show);
    }

    private void syncWorkbench(boolean show) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null) {
            try {
                Class<?> windowClass = window.getClass();
                Method method = windowClass.getDeclaredMethod("showHeapStatus", Boolean.TYPE);
                if (method != null) {
                    method.invoke((Object)window, show);
                    if (show && (method = windowClass.getDeclaredMethod("getModel", new Class[0])) != null) {
                        Object widget;
                        MWindow model = (MWindow)method.invoke((Object)window, new Object[0]);
                        EModelService modelService = (EModelService)window.getService(EModelService.class);
                        MUIElement element = modelService.find("org.eclipse.ui.HeapStatus", (MUIElement)model);
                        if (element != null && (widget = element.getWidget()) instanceof Composite) {
                            Composite composite = (Composite)widget;
                            composite.removeDisposeListener((DisposeListener)this);
                            composite.addDisposeListener((DisposeListener)this);
                        }
                    }
                }
            }
            catch (Exception exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
    }
}

