/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.application;

import com.arm.streamline.application.PluginMessages;
import com.arm.streamline.application.StreamlineActionBarAdvisor;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.wizard.import_examples.ImportExamplesWizard;
import java.util.Set;
import javafx.application.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class StreamlineWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final Set<String> VIEWS_TO_KEEP_OPEN = Set.of("streamline.view.LandingPageView", "streamline.view.TargetView", "streamline.view.LauncherView");
    private StreamlineActionBarAdvisor mActionBarAdvisor;

    private static void removePreferenceMenu(Menu menu) {
        if (menu != null) {
            MenuItem[] menuItemArray = menu.getItems();
            int n = menuItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem item = menuItemArray[n2];
                if (item.getID() == -2) {
                    item.dispose();
                    break;
                }
                ++n2;
            }
        }
    }

    public StreamlineWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        this.mActionBarAdvisor = new StreamlineActionBarAdvisor(configurer);
        return this.mActionBarAdvisor;
    }

    public void postWindowCreate() {
        super.postWindowCreate();
        try {
            IEclipsePreferences is = InstanceScope.INSTANCE.getNode("org.eclipse.help.base");
            is.put("help_view_open_mode", "in browser");
            is.putBoolean("always_external_browser", true);
            is.flush();
        }
        catch (Throwable is) {
            // empty catch block
        }
        this.mActionBarAdvisor.getMemoryMonitorAction().syncWorkbench();
        if (com.arm.utils.Platform.isMacintosh()) {
            Display display = Display.getDefault();
            StreamlineWorkbenchWindowAdvisor.removePreferenceMenu(display.getMenuBar());
            StreamlineWorkbenchWindowAdvisor.removePreferenceMenu(display.getSystemMenu());
        }
    }

    public void postWindowOpen() {
        super.postWindowOpen();
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchWindow window = configurer.getWindow();
        Shell shell = window.getShell();
        Listener[] listenerArray = shell.getListeners(55);
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Listener zcl = listenerArray[n2];
            shell.removeListener(55, zcl);
            ++n2;
        }
        shell.getDisplay().asyncExec(() -> {
            configurer.setTitle(configurer.getTitle());
            if (StreamlinePreferences.isFirstRun()) {
                MessageBox dialog = new MessageBox(shell, 194);
                dialog.setText(PluginMessages.FIRST_RUN_MESSAGEBOX_TITLE);
                dialog.setMessage(PluginMessages.FIRST_RUN_MESSAGEBOX_MESSAGE);
                int result = dialog.open();
                if (result == 64) {
                    ImportExamplesWizard wizard = new ImportExamplesWizard();
                    WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
                    wizardDialog.setBlockOnOpen(true);
                    wizardDialog.open();
                }
            }
        });
        window.addPerspectiveListener((IPerspectiveListener)new IPerspectiveListener2(){
            boolean resettingAfterViewClosed = false;

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                StreamlineWorkbenchWindowAdvisor.openLandingPageViewIfNeeded(page);
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, IWorkbenchPartReference partRef, String changeId) {
                if (page.getWorkbenchWindow().isClosing()) {
                    return;
                }
                if ("viewHide".equals(changeId) && VIEWS_TO_KEEP_OPEN.contains(partRef.getId()) && !this.resettingAfterViewClosed) {
                    Display.getCurrent().asyncExec(() -> {
                        this.resettingAfterViewClosed = true;
                        page.resetPerspective();
                        EPartService partService = (EPartService)page.getWorkbenchWindow().getService(EPartService.class);
                        MPart part = partService.findPart("streamline.view.LandingPageView");
                        if (part != null) {
                            part.setCloseable(false);
                        }
                        this.resettingAfterViewClosed = false;
                    });
                }
            }
        });
        window.addPageListener(new IPageListener(){

            public void pageOpened(IWorkbenchPage page) {
                StreamlineWorkbenchWindowAdvisor.openLandingPageViewIfNeeded(page);
            }

            public void pageClosed(IWorkbenchPage page) {
            }

            public void pageActivated(IWorkbenchPage page) {
            }
        });
        listenerArray = window.getPages();
        n = listenerArray.length;
        n2 = 0;
        while (n2 < n) {
            Listener page = listenerArray[n2];
            StreamlineWorkbenchWindowAdvisor.openLandingPageViewIfNeeded((IWorkbenchPage)page);
            ++n2;
        }
    }

    public void preWindowOpen() {
        super.preWindowOpen();
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setTitle(PluginMessages.TITLE);
        Display display = Display.getCurrent();
        if (display != null) {
            Shell shell;
            Rectangle bounds = display.getPrimaryMonitor().getClientArea();
            configurer.setInitialSize(new Point(bounds.width, bounds.height));
            IWorkbenchWindow window = configurer.getWindow();
            if (window != null && (shell = window.getShell()) != null && shell.getBounds().height < 100) {
                shell.setLocation(bounds.x, bounds.y);
            }
        }
        configurer.setShowMenuBar(true);
        configurer.setShowCoolBar(false);
        configurer.setShowProgressIndicator(true);
        configurer.setShowStatusLine(true);
        Platform.setImplicitExit((boolean)false);
    }

    private static void openLandingPageViewIfNeeded(@NonNull IWorkbenchPage page) {
        IPerspectiveDescriptor perspective = page.getPerspective();
        if (perspective != null && perspective.getId().equals("streamline.perspective")) {
            EPartService partService = (EPartService)page.getWorkbenchWindow().getService(EPartService.class);
            MPart part = partService.findPart("streamline.view.LandingPageView");
            if (part == null || !part.isVisible()) {
                Display.getCurrent().asyncExec(() -> page.resetPerspective());
            } else {
                Display.getCurrent().asyncExec(() -> {
                    try {
                        page.showView("streamline.view.LauncherView", null, 2);
                    }
                    catch (PartInitException e) {
                        StreamlinePlugin.warning(e);
                    }
                    try {
                        page.showView("streamline.view.LandingPageView", null, 1);
                    }
                    catch (PartInitException e) {
                        StreamlinePlugin.warning(e);
                    }
                });
            }
        }
    }
}

